/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.message.json.ld;

import com.liferay.apio.architect.batch.BatchResult;
import com.liferay.apio.architect.internal.message.json.BatchResultMessageMapper;
import com.liferay.apio.architect.internal.message.json.JSONObjectBuilder;
import com.liferay.apio.architect.internal.message.json.SingleModelMessageMapper;
import com.liferay.apio.architect.internal.message.json.ld.JSONLDSingleModelMessageMapper;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;

@Component(service={BatchResultMessageMapper.class})
public class JSONLDBatchResultMessageMapper<T>
implements BatchResultMessageMapper<T> {
    private final SingleModelMessageMapper<T> _singleModelMessageMapper = new JSONLDSingleModelMessageMapper();

    @Override
    public String getMediaType() {
        return "application/ld+json";
    }

    @Override
    public Optional<SingleModelMessageMapper<T>> getSingleModelMessageMapperOptional() {
        return Optional.of(this._singleModelMessageMapper);
    }

    @Override
    public void mapCollectionURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        this._singleModelMessageMapper.mapSelfURL(jsonObjectBuilder, url);
    }

    @Override
    public void mapItemTotalCount(JSONObjectBuilder jsonObjectBuilder, int totalCount) {
        jsonObjectBuilder.field("totalItems").numberValue(totalCount);
    }

    @Override
    public void onFinish(JSONObjectBuilder jsonObjectBuilder, BatchResult<T> batchResult) {
        jsonObjectBuilder.field("@id").stringValue("_:batch/" + batchResult.resourceName);
        jsonObjectBuilder.field("@context").arrayValue(arrayBuilder -> arrayBuilder.add(builder -> builder.field("@vocab").stringValue("http://schema.org/")), arrayBuilder -> arrayBuilder.addString("https://www.w3.org/ns/hydra/core#"));
        jsonObjectBuilder.field("@type").arrayValue().addString("Collection");
    }

    @Override
    public void onFinishItem(JSONObjectBuilder batchResultJSONObjectBuilder, JSONObjectBuilder itemJSONObjectBuilder) {
        batchResultJSONObjectBuilder.field("member").arrayValue().add(itemJSONObjectBuilder);
    }
}

