/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.message.json.hal;

import com.liferay.apio.architect.internal.list.FunctionalList;
import com.liferay.apio.architect.internal.message.json.JSONObjectBuilder;
import com.liferay.apio.architect.internal.message.json.PageMessageMapper;
import com.liferay.apio.architect.internal.message.json.SingleModelMessageMapper;
import com.liferay.apio.architect.internal.message.json.hal.HALSingleModelMessageMapper;
import com.liferay.apio.architect.internal.wiring.osgi.manager.representable.RepresentableManager;
import com.liferay.apio.architect.representor.BaseRepresentor;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.single.model.SingleModel;
import java.util.List;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PageMessageMapper.class})
public class HALPageMessageMapper<T>
implements PageMessageMapper<T> {
    @Reference
    protected RepresentableManager representableManager;
    private final SingleModelMessageMapper<T> _singleModelMessageMapper = new HALSingleModelMessageMapper();

    @Override
    public String getMediaType() {
        return "application/hal+json";
    }

    @Override
    public Optional<SingleModelMessageMapper<T>> getSingleModelMessageMapperOptional() {
        return Optional.of(this._singleModelMessageMapper);
    }

    @Override
    public void mapCollectionURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.nestedField("_links", "collection", "href").stringValue(url);
    }

    @Override
    public void mapCurrentPageURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.nestedField("_links", "self", "href").stringValue(url);
    }

    @Override
    public void mapFirstPageURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.nestedField("_links", "first", "href").stringValue(url);
    }

    @Override
    public void mapItemTotalCount(JSONObjectBuilder jsonObjectBuilder, int totalCount) {
        jsonObjectBuilder.field("total").numberValue(totalCount);
    }

    @Override
    public void mapLastPageURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.nestedField("_links", "last", "href").stringValue(url);
    }

    @Override
    public void mapNextPageURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.nestedField("_links", "next", "href").stringValue(url);
    }

    @Override
    public void mapPageCount(JSONObjectBuilder jsonObjectBuilder, int count) {
        jsonObjectBuilder.field("count").numberValue(count);
    }

    @Override
    public void mapPreviousPageURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.nestedField("_links", "prev", "href").stringValue(url);
    }

    @Override
    public void onFinishItem(JSONObjectBuilder pageJSONObjectBuilder, JSONObjectBuilder itemJSONObjectBuilder, SingleModel<T> singleModel) {
        Optional<Representor<Representor>> optional = this.representableManager.getRepresentorOptional(singleModel.getResourceName());
        optional.map(BaseRepresentor::getTypes).ifPresent(types -> pageJSONObjectBuilder.nestedField("_embedded", (String)types.get(0)).arrayValue().add(itemJSONObjectBuilder));
    }

    @Override
    public void onFinishNestedCollection(JSONObjectBuilder singleModelJSONObjectBuilder, JSONObjectBuilder collectionJsonObjectBuilder, String fieldName, List<?> list, FunctionalList<String> embeddedPathElements) {
        singleModelJSONObjectBuilder.field("_embedded").field(fieldName).objectValue(collectionJsonObjectBuilder);
    }

    @Override
    public void onFinishNestedCollectionItem(JSONObjectBuilder collectionJsonObjectBuilder, JSONObjectBuilder itemJSONObjectBuilder, SingleModel<?> singleModel) {
        collectionJsonObjectBuilder.field("_embedded").arrayValue().add(itemJSONObjectBuilder);
    }
}

