/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FunctionalList<E> {
    private final E _first;
    private List<E> _init;
    private E _last;
    private List<E> _middle;
    private final List<E> _tail;

    public FunctionalList(FunctionalList<E> functionalList, E last) {
        if (functionalList == null) {
            this._first = last;
            this._tail = Collections.emptyList();
        } else {
            this._first = functionalList.head();
            Stream<E> stream = functionalList.tailStream();
            List tail = stream.collect(Collectors.toList());
            tail.add(last);
            this._tail = tail;
        }
    }

    public E head() {
        return this._first;
    }

    public Stream<E> initStream() {
        if (this._init == null) {
            ArrayList<E> init = new ArrayList<E>();
            init.add(this._first);
            Stream<E> stream = this.middleStream();
            init.addAll(stream.collect(Collectors.toList()));
            this._init = init;
        }
        return this._init.stream();
    }

    public Optional<E> lastOptional() {
        if (this._last == null) {
            if (this._tail.size() == 0) {
                return Optional.empty();
            }
            this._last = this._tail.get(this._tail.size() - 1);
        }
        return Optional.of(this._last);
    }

    public Stream<E> middleStream() {
        if (this._middle == null) {
            this._middle = this._tail.size() == 0 ? Collections.emptyList() : this._tail.subList(0, this._tail.size() - 1);
        }
        return this._middle.stream();
    }

    public Stream<E> tailStream() {
        return this._tail.stream();
    }
}

