/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.jaxrs.json.writer.base;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.internal.message.json.MessageMapper;
import com.liferay.apio.architect.internal.request.RequestInfo;
import com.liferay.apio.architect.internal.response.control.Embedded;
import com.liferay.apio.architect.internal.response.control.Fields;
import com.liferay.apio.architect.internal.unsafe.Unsafe;
import com.liferay.apio.architect.internal.url.ApplicationURL;
import com.liferay.apio.architect.internal.url.ServerURL;
import com.liferay.apio.architect.internal.wiring.osgi.manager.provider.ProviderManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.representable.NameManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.router.ItemRouterManager;
import com.liferay.apio.architect.language.AcceptLanguage;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.single.model.SingleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.ext.MessageBodyWriter;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseMessageBodyWriter<T, S extends MessageMapper>
implements MessageBodyWriter<T> {
    @Reference
    protected ItemRouterManager itemRouterManager;
    @Reference
    protected NameManager nameManager;
    @Reference
    protected ProviderManager providerManager;
    @Context
    private HttpServletRequest _httpServletRequest;
    @Context
    private Request _request;

    public abstract boolean canWrite(Class<?> var1, Type var2);

    public abstract Optional<S> getMessageMapperOptional(Request var1);

    public long getSize(T documentation, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> aClass, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.canWrite(aClass, genericType);
    }

    public void writeTo(T t, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException, WebApplicationException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        PrintWriter printWriter = new PrintWriter((Writer)outputStreamWriter, true);
        Optional<S> optional = this.getMessageMapperOptional(this._request);
        MessageMapper s = (MessageMapper)optional.orElseThrow(NotSupportedException::new);
        RequestInfo requestInfo = RequestInfo.create(builder -> builder.httpServletRequest(this._httpServletRequest).serverURL(this.providerManager.provideMandatory(this._httpServletRequest, ServerURL.class)).applicationURL(this.providerManager.provideMandatory(this._httpServletRequest, ApplicationURL.class)).embedded(this.providerManager.provideOptional(this._httpServletRequest, Embedded.class).orElse(__ -> false)).fields(this.providerManager.provideOptional(this._httpServletRequest, Fields.class).orElse(__ -> string -> true)).language(this.providerManager.provideOptional(this._httpServletRequest, AcceptLanguage.class).orElse(Locale::getDefault)).build());
        String result = this.write(t, s, requestInfo);
        httpHeaders.put((Object)"Content-Type", Collections.singletonList(s.getMediaType()));
        printWriter.println(result);
        printWriter.close();
    }

    protected Optional<SingleModel> getSingleModelOptional(Object identifier, Class<? extends Identifier> identifierClass) {
        return (Optional)Try.success((Object)identifierClass.getName()).mapOptional(this.nameManager::getNameOptional).mapOptional(this.itemRouterManager::getItemRoutesOptional).mapOptional(ItemRoutes::getItemFunctionOptional).map(function -> (Function)function.apply((Object)this._httpServletRequest)).flatMap(function -> (Try)function.apply(identifier)).map(Unsafe::unsafeCast).map(Optional::of).orElseGet(Optional::empty);
    }

    protected abstract String write(T var1, S var2, RequestInfo var3);
}

