/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.jaxrs.json.util;

import com.liferay.apio.architect.error.APIError;
import com.liferay.apio.architect.internal.message.json.ErrorMessageMapper;
import com.liferay.apio.architect.internal.wiring.osgi.manager.exception.mapper.ExceptionMapperManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.message.json.ErrorMessageMapperManager;
import com.liferay.apio.architect.internal.writer.ErrorWriter;
import java.util.Optional;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ErrorUtil.class})
public class ErrorUtil {
    @Reference
    private ErrorMessageMapperManager _errorMessageMapperManager;
    @Reference
    private ExceptionMapperManager _exceptionMapperManager;
    private final Logger _logger = LoggerFactory.getLogger(this.getClass());

    public Response getErrorResponse(Exception exception, Request request) {
        Optional<APIError> apiErrorOptional = this._exceptionMapperManager.map(exception);
        if (!apiErrorOptional.isPresent()) {
            this._logger.warn("No exception mapper found for {}", exception.getClass());
            if (exception instanceof WebApplicationException) {
                WebApplicationException webApplicationException = (WebApplicationException)exception;
                return webApplicationException.getResponse();
            }
            Response.ResponseBuilder responseBuilder = Response.serverError();
            return responseBuilder.build();
        }
        APIError apiError = apiErrorOptional.get();
        if (this._logger.isDebugEnabled()) {
            this._logger.debug(apiError.getMessage(), (Throwable)apiError.getException());
        } else {
            this._logger.error(apiError.getMessage());
        }
        int statusCode = apiError.getStatusCode();
        Optional<ErrorMessageMapper> errorMessageMapperOptional = this._errorMessageMapperManager.getErrorMessageMapperOptional(request);
        return errorMessageMapperOptional.map(errorMessageMapper -> Response.status((int)statusCode).type(errorMessageMapper.getMediaType()).entity((Object)ErrorWriter.writeError(errorMessageMapper, apiError)).build()).orElseGet(() -> Response.status((int)statusCode).build());
    }
}

