/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.jaxrs.json.reader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.liferay.apio.architect.form.Body;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.internal.form.JSONBodyImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.osgi.service.component.annotations.Component;

@Consumes(value={"application/json"})
@Provider
@Component(property={"osgi.jaxrs.application.select=(liferay.apio.architect.application=true)", "osgi.jaxrs.extension=true"}, service={MessageBodyReader.class})
public class JSONBodyMessageBodyReader
implements MessageBodyReader<Body> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public Body readFrom(Class<Body> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return JSONBodyMessageBodyReader._getBody(entityStream);
    }

    private static Body _getBody(InputStream entityStream) {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = (JsonNode)Try.fromFallibleWithResources(() -> new InputStreamReader(entityStream, StandardCharsets.UTF_8), arg_0 -> ((ObjectMapper)objectMapper).readTree(arg_0)).filter(node -> node.isObject() || node.isArray()).orElseThrow(() -> new BadRequestException("Body is not a valid JSON"));
        if (jsonNode.isObject()) {
            return JSONBodyMessageBodyReader._getBody((ObjectNode)jsonNode);
        }
        return JSONBodyMessageBodyReader._getListBody((ArrayNode)jsonNode);
    }

    private static Body _getBody(ObjectNode objectNode) {
        return new JSONBodyImpl((JsonNode)objectNode);
    }

    private static Body _getListBody(ArrayNode arrayNode) {
        return new JSONBodyImpl((JsonNode)arrayNode);
    }
}

