/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.jaxrs.json.filter;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.internal.jaxrs.json.util.ErrorUtil;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"osgi.jaxrs.application.select=(liferay.apio.architect.application=true)", "osgi.jaxrs.extension=true"}, service={ContainerResponseFilter.class})
public class FailureFilter
implements ContainerResponseFilter {
    @Reference
    private ErrorUtil _errorUtil;
    @Context
    private Request _request;

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        Try.fromFallible(() -> ((ContainerResponseContext)containerResponseContext).getEntity()).map(Try.Failure.class::cast).map(Try.Failure::getException).map(exception -> this._errorUtil.getErrorResponse((Exception)exception, this._request)).ifSuccess(response -> FailureFilter._updateContext(containerResponseContext, response));
    }

    private static void _updateContext(ContainerResponseContext containerResponseContext, Response response) {
        containerResponseContext.setStatus(response.getStatus());
        MultivaluedMap headers = containerResponseContext.getHeaders();
        headers.remove((Object)"Content-Type");
        MediaType mediaType = response.getMediaType();
        if (mediaType != null) {
            headers.add((Object)"Content-Type", (Object)mediaType.toString());
        }
        containerResponseContext.setEntity(response.getEntity());
    }
}

