/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.entrypoint;

import com.liferay.apio.architect.alias.routes.CustomItemFunction;
import com.liferay.apio.architect.alias.routes.CustomPageFunction;
import com.liferay.apio.architect.custom.actions.CustomRoute;
import com.liferay.apio.architect.form.Body;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.internal.endpoint.ExceptionSupplierUtil;
import com.liferay.apio.architect.operation.HTTPMethod;
import com.liferay.apio.architect.routes.CollectionRoutes;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.single.model.SingleModel;
import com.liferay.apio.architect.uri.Path;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;

public class CustomOperationsEndpoint<T, S, R> {
    private final Supplier<Optional<CollectionRoutes<T, S>>> _collectionRoutesSupplier;
    private final HttpServletRequest _httpServletRequest;
    private final Function<Path, S> _identifierFunction;
    private final Supplier<Optional<ItemRoutes<T, S>>> _itemRoutesSupplier;
    private final String _name;

    public CustomOperationsEndpoint(String name, HttpServletRequest httpServletRequest, Supplier<Optional<CollectionRoutes<T, S>>> collectionRoutesSupplier, Supplier<Optional<ItemRoutes<T, S>>> itemRoutesSupplier, Function<Path, S> identifierFunction) {
        this._name = name;
        this._httpServletRequest = httpServletRequest;
        this._collectionRoutesSupplier = collectionRoutesSupplier;
        this._itemRoutesSupplier = itemRoutesSupplier;
        this._identifierFunction = identifierFunction;
    }

    @DELETE
    @javax.ws.rs.Path(value="/{operation}/")
    public void addDeleteCollection(@PathParam(value="operation") String operation) {
        this._getCollectionSingleModelTry(operation, HTTPMethod.DELETE, null);
    }

    @DELETE
    @javax.ws.rs.Path(value="/{id}/{operation}/")
    public void addDeleteItem(@PathParam(value="operation") String operation, @PathParam(value="id") String id) {
        this._getItemSingleModelTry(operation, HTTPMethod.DELETE, id, null);
    }

    @GET
    @javax.ws.rs.Path(value="/{operation}/")
    public Try<SingleModel<R>> addGetCollection(@PathParam(value="operation") String operation) {
        return this._getCollectionSingleModelTry(operation, HTTPMethod.GET, null);
    }

    @GET
    @javax.ws.rs.Path(value="/{id}/{operation}/")
    public Try<SingleModel<R>> addGetItem(@PathParam(value="operation") String operation, @PathParam(value="id") String id) {
        return this._getItemSingleModelTry(operation, HTTPMethod.GET, id, null);
    }

    @Consumes(value={"application/json", "multipart/form-data"})
    @javax.ws.rs.Path(value="/{operation}/")
    @POST
    public Try<SingleModel<R>> addPostCollection(@PathParam(value="operation") String operation, Body body) {
        return this._getCollectionSingleModelTry(operation, HTTPMethod.POST, body);
    }

    @Consumes(value={"application/json", "multipart/form-data"})
    @javax.ws.rs.Path(value="/{id}/{operation}/")
    @POST
    public Try<SingleModel<R>> addPostItem(@PathParam(value="operation") String operation, @PathParam(value="id") String id, Body body) {
        return this._getItemSingleModelTry(operation, HTTPMethod.POST, id, body);
    }

    @Consumes(value={"application/json", "multipart/form-data"})
    @javax.ws.rs.Path(value="/{operation}/")
    @PUT
    public Try<SingleModel<R>> addPutCollection(@PathParam(value="operation") String operation, Body body) {
        return this._getCollectionSingleModelTry(operation, HTTPMethod.PUT, body);
    }

    @Consumes(value={"application/json", "multipart/form-data"})
    @javax.ws.rs.Path(value="/{id}/{operation}/")
    @PUT
    public Try<SingleModel<R>> addPutItem(@PathParam(value="operation") String operation, @PathParam(value="id") String id, Body body) {
        return this._getItemSingleModelTry(operation, HTTPMethod.PUT, id, body);
    }

    private Try<SingleModel<R>> _getCollectionSingleModelTry(String operation, HTTPMethod method, Body body) {
        return Try.fromOptional(this._collectionRoutesSupplier::get, ExceptionSupplierUtil.notFound(this._name)).mapOptional(routes -> {
            Map customRoutes = routes.getCustomRoutes();
            CustomRoute customRoute = (CustomRoute)customRoutes.get(operation);
            if (customRoute != null && method.equals((Object)customRoute.getMethod())) {
                return routes.getCustomPageFunctionsOptional();
            }
            return Optional.empty();
        }, ExceptionSupplierUtil.notAllowed(method, this._name)).map(stringRequestFunctionMap -> (CustomPageFunction)stringRequestFunctionMap.get(operation)).map(function -> (Function)function.apply((Object)this._httpServletRequest)).flatMap(function -> (Try)function.apply(body));
    }

    private Try<SingleModel<R>> _getItemSingleModelTry(String operation, HTTPMethod method, String id, Body body) {
        return Try.fromOptional(this._itemRoutesSupplier::get, ExceptionSupplierUtil.notFound(this._name)).mapOptional(routes -> {
            Map customRoutes = routes.getCustomRoutes();
            CustomRoute customRoute = (CustomRoute)customRoutes.get(operation);
            if (method.equals((Object)customRoute.getMethod())) {
                return routes.getCustomItemFunctionsOptional();
            }
            return Optional.empty();
        }, ExceptionSupplierUtil.notAllowed(method, this._name)).map(stringRequestFunctionMap -> (CustomItemFunction)stringRequestFunctionMap.get(operation)).map(functionRequestFunction -> (Function)functionRequestFunction.apply((Object)this._httpServletRequest)).map(function -> (Function)function.apply(this._identifierFunction.apply(new Path(this._name, id)))).flatMap(function -> (Try)function.apply(body));
    }
}

