/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.endpoint;

import com.liferay.apio.architect.documentation.APIDescription;
import com.liferay.apio.architect.documentation.APITitle;
import com.liferay.apio.architect.function.throwable.ThrowableFunction;
import com.liferay.apio.architect.function.throwable.ThrowableTriFunction;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.internal.documentation.Documentation;
import com.liferay.apio.architect.internal.endpoint.BatchEndpoint;
import com.liferay.apio.architect.internal.endpoint.BatchEndpointBuilder;
import com.liferay.apio.architect.internal.endpoint.BinaryEndpoint;
import com.liferay.apio.architect.internal.endpoint.ExceptionSupplierUtil;
import com.liferay.apio.architect.internal.endpoint.FormEndpoint;
import com.liferay.apio.architect.internal.endpoint.PageEndpointImpl;
import com.liferay.apio.architect.internal.endpoint.RootEndpoint;
import com.liferay.apio.architect.internal.entrypoint.CustomOperationsEndpoint;
import com.liferay.apio.architect.internal.entrypoint.EntryPoint;
import com.liferay.apio.architect.internal.url.ApplicationURL;
import com.liferay.apio.architect.internal.wiring.osgi.manager.base.ClassNameBaseManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.documentation.contributor.CustomDocumentationManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.provider.ProviderManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.representable.RepresentableManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.router.CollectionRouterManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.router.ItemRouterManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.router.NestedCollectionRouterManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.router.ReusableNestedCollectionRouterManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.uri.mapper.PathIdentifierMapperManager;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.routes.CollectionRoutes;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.apio.architect.single.model.SingleModel;
import com.liferay.apio.architect.uri.Path;
import java.util.Optional;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RootEndpoint.class})
public class RootEndpointImpl
implements RootEndpoint {
    @Reference
    private CollectionRouterManager _collectionRouterManager;
    @Reference
    private CustomDocumentationManager _customDocumentationManager;
    private Documentation _documentation;
    @Context
    private HttpServletRequest _httpServletRequest;
    @Reference
    private ItemRouterManager _itemRouterManager;
    @Reference
    private NestedCollectionRouterManager _nestedCollectionRouterManager;
    @Reference
    private PathIdentifierMapperManager _pathIdentifierMapperManager;
    @Reference
    private ProviderManager _providerManager;
    @Reference
    private RepresentableManager _representableManager;
    @Reference
    private ReusableNestedCollectionRouterManager _reusableNestedCollectionRouterManager;

    @Activate
    public void activate() {
        this._documentation = new Documentation(() -> this._provide(APITitle.class), () -> this._provide(APIDescription.class), () -> this._provide(ApplicationURL.class), () -> this._representableManager.getRepresentors(), () -> this._collectionRouterManager.getCollectionRoutes(), () -> this._itemRouterManager.getItemRoutes(), () -> this._nestedCollectionRouterManager.getNestedCollectionRoutes(), () -> this._reusableNestedCollectionRouterManager.getReusableCollectionRoutes(), () -> this._customDocumentationManager.getCustomDocumentation());
    }

    @Override
    public BatchEndpoint batchEndpoint(String name) {
        return BatchEndpointBuilder.name(name).httpServletRequest(this._httpServletRequest).singleModelFunction(id -> this._getSingleModelTry(name, (String)id)).representorSupplier(() -> this._getRepresentorOrFail(name)).collectionRoutesSupplier(() -> this._getCollectionRoutesOrFail(name)).nestedCollectionRoutesFunction(nestedName -> this._getNestedCollectionRoutesOrFail(name, (String)nestedName, null)).build();
    }

    @Override
    public BinaryEndpoint binaryEndpoint() {
        return new BinaryEndpoint((ThrowableFunction<String, Representor<Object>>)((ThrowableFunction)this::_getRepresentorOrFail), this::_getSingleModelTry);
    }

    @Override
    public CustomOperationsEndpoint customOperationsEndpoint(String name) {
        return new CustomOperationsEndpoint(name, this._httpServletRequest, () -> this._collectionRouterManager.getCollectionRoutesOptional(name), () -> this._itemRouterManager.getItemRoutesOptional(name), this._pathIdentifierMapperManager::mapToIdentifierOrFail);
    }

    @Override
    public Documentation documentation() {
        return this._documentation;
    }

    @Override
    public FormEndpoint formEndpoint() {
        return new FormEndpoint((ThrowableFunction<String, CollectionRoutes<Object, Object>>)((ThrowableFunction)this::_getCollectionRoutesOrFail), (ThrowableFunction<String, ItemRoutes<Object, Object>>)((ThrowableFunction)this::_getItemRoutesOrFail), (ThrowableTriFunction<String, String, String, NestedCollectionRoutes<Object, Object, Object>>)((ThrowableTriFunction)this::_getNestedCollectionRoutesOrFail));
    }

    @Override
    public EntryPoint home() {
        return () -> this._collectionRouterManager.getResourceNames();
    }

    @Override
    public PageEndpointImpl pageEndpoint(String name) {
        return new PageEndpointImpl(name, this._httpServletRequest, id -> this._getSingleModelTry(name, (String)id), () -> this._getCollectionRoutesOrFail(name), () -> this._getRepresentorOrFail(name), () -> this._getItemRoutesOrFail(name), this::_getNestedCollectionRoutesOrFail, path -> this._pathIdentifierMapperManager.mapToIdentifierOrFail((Path)path, (ClassNameBaseManager)((Object)this._reusableNestedCollectionRouterManager)));
    }

    private CollectionRoutes<Object, Object> _getCollectionRoutesOrFail(String name) {
        Optional optional = this._collectionRouterManager.getCollectionRoutesOptional(name);
        return optional.orElseThrow(ExceptionSupplierUtil.notFound(name));
    }

    private ItemRoutes<Object, Object> _getItemRoutesOrFail(String name) {
        Optional optional = this._itemRouterManager.getItemRoutesOptional(name);
        return optional.orElseThrow(ExceptionSupplierUtil.notFound(name));
    }

    private NestedCollectionRoutes<Object, Object, Object> _getNestedCollectionRoutesOrFail(String name, String nestedName, String id) {
        Optional optional = this._nestedCollectionRouterManager.getNestedCollectionRoutesOptional(name, nestedName);
        return optional.orElseGet(() -> this._getReusableNestedCollectionRoutes(name, nestedName, id));
    }

    private Representor<Object> _getRepresentorOrFail(String name) {
        Optional optional = this._representableManager.getRepresentorOptional(name);
        return optional.orElseThrow(ExceptionSupplierUtil.notFound(name));
    }

    private NestedCollectionRoutes _getReusableNestedCollectionRoutes(String name, String nestedName, String id) {
        Optional<NestedCollectionRoutes> reusableCollectionRoutesOptional = this._reusableNestedCollectionRouterManager.getReusableCollectionRoutesOptional(id);
        return reusableCollectionRoutesOptional.orElseThrow(ExceptionSupplierUtil.notFound(name, "{id}", nestedName));
    }

    private Try<SingleModel<Object>> _getSingleModelTry(String name, String id) {
        return Try.fromFallible(() -> this._getItemRoutesOrFail(name)).mapOptional(ItemRoutes::getItemFunctionOptional, ExceptionSupplierUtil.notFound(name, id)).map(requestFunction -> (Function)requestFunction.apply((Object)this._httpServletRequest)).map(identifierFunction -> identifierFunction.compose(path -> this._pathIdentifierMapperManager.mapToIdentifierOrFail((Path)path))).flatMap(pathFunction -> (Try)pathFunction.apply(new Path(name, id)));
    }

    private <T> Optional<T> _provide(Class<T> clazz) {
        return this._providerManager.provideOptional(this._httpServletRequest, clazz);
    }
}

