/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.endpoint;

import com.liferay.apio.architect.alias.IdentifierFunction;
import com.liferay.apio.architect.consumer.throwable.ThrowableConsumer;
import com.liferay.apio.architect.form.Body;
import com.liferay.apio.architect.function.throwable.ThrowableTriFunction;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.internal.endpoint.ExceptionSupplierUtil;
import com.liferay.apio.architect.internal.endpoint.PageEndpoint;
import com.liferay.apio.architect.operation.HTTPMethod;
import com.liferay.apio.architect.pagination.Page;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.routes.CollectionRoutes;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.apio.architect.single.model.SingleModel;
import com.liferay.apio.architect.supplier.ThrowableSupplier;
import com.liferay.apio.architect.uri.Path;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;

public class PageEndpointImpl<T, S>
implements PageEndpoint<T> {
    private final ThrowableSupplier<CollectionRoutes<T, S>> _collectionRoutesSupplier;
    private final HttpServletRequest _httpServletRequest;
    private final ThrowableSupplier<ItemRoutes<T, S>> _itemRoutesSupplier;
    private final String _name;
    private final ThrowableTriFunction<String, String, String, NestedCollectionRoutes<T, S, Object>> _nestedCollectionRoutesFunction;
    private final IdentifierFunction<S> _pathToIdentifierFunction;
    private final ThrowableSupplier<Representor<T>> _representorSupplier;
    private final Function<String, Try<SingleModel<T>>> _singleModelFunction;

    public PageEndpointImpl(String name, HttpServletRequest httpServletRequest, Function<String, Try<SingleModel<T>>> singleModelFunction, ThrowableSupplier<CollectionRoutes<T, S>> collectionRoutesSupplier, ThrowableSupplier<Representor<T>> representorSupplier, ThrowableSupplier<ItemRoutes<T, S>> itemRoutesSupplier, ThrowableTriFunction<String, String, String, NestedCollectionRoutes<T, S, Object>> nestedCollectionRoutesFunction, IdentifierFunction<S> pathToIdentifierFunction) {
        this._name = name;
        this._httpServletRequest = httpServletRequest;
        this._singleModelFunction = singleModelFunction;
        this._collectionRoutesSupplier = collectionRoutesSupplier;
        this._representorSupplier = representorSupplier;
        this._itemRoutesSupplier = itemRoutesSupplier;
        this._nestedCollectionRoutesFunction = nestedCollectionRoutesFunction;
        this._pathToIdentifierFunction = pathToIdentifierFunction;
    }

    @Override
    public Try<SingleModel<T>> addCollectionItem(Body body) {
        return Try.fromFallible(this._collectionRoutesSupplier).mapOptional(CollectionRoutes::getCreateItemFunctionOptional, ExceptionSupplierUtil.notAllowed(HTTPMethod.POST, this._name)).map(requestFunction -> (Function)requestFunction.apply((Object)this._httpServletRequest)).flatMap(bodyFunction -> (Try)bodyFunction.apply(body));
    }

    @Override
    public Try<SingleModel<T>> addNestedCollectionItem(String id, String nestedName, Body body) {
        return Try.fromFallible(() -> (NestedCollectionRoutes)this._nestedCollectionRoutesFunction.apply((Object)this._name, (Object)nestedName, (Object)id)).mapOptional(NestedCollectionRoutes::getNestedCreateItemFunctionOptional).map(requestFunction -> (Function)requestFunction.apply((Object)this._httpServletRequest)).flatMap(identifierFunction -> this._getFunctionTry(id, nestedName, (Function<Object, Function<Body, Try<SingleModel<T>>>>)identifierFunction)).flatMap(bodyFunction -> (Try)bodyFunction.apply(body)).mapFailMatching(NoSuchElementException.class, ExceptionSupplierUtil.notAllowed(HTTPMethod.POST, this._name, id, nestedName));
    }

    @Override
    public Response deleteCollectionItem(String id) throws Exception {
        ThrowableConsumer deleteItemThrowableConsumer = (ThrowableConsumer)Try.fromFallible(this._itemRoutesSupplier).mapOptional(ItemRoutes::getDeleteConsumerOptional, ExceptionSupplierUtil.notAllowed(HTTPMethod.DELETE, this._name, id)).map(requestFunction -> (ThrowableConsumer)requestFunction.apply((Object)this._httpServletRequest)).getUnchecked();
        Object s = this._pathToIdentifierFunction.apply((Object)new Path(this._name, id));
        deleteItemThrowableConsumer.accept(s);
        return Response.noContent().build();
    }

    @Override
    public Try<SingleModel<T>> getCollectionItemSingleModelTry(String id) {
        return this._singleModelFunction.apply(id);
    }

    @Override
    public Try<Page<T>> getCollectionPageTry() {
        return Try.fromFallible(this._collectionRoutesSupplier).mapOptional(CollectionRoutes::getGetPageFunctionOptional, ExceptionSupplierUtil.notFound(this._name)).flatMap(requestFunction -> (Try)requestFunction.apply((Object)this._httpServletRequest));
    }

    @Override
    public Try<Page<T>> getNestedCollectionPageTry(String id, String nestedName) {
        return Try.fromFallible(() -> (NestedCollectionRoutes)this._nestedCollectionRoutesFunction.apply((Object)this._name, (Object)nestedName, (Object)id)).map(NestedCollectionRoutes::getNestedGetPageFunctionOptional).map(Optional::get).map(requestFunction -> (IdentifierFunction)requestFunction.apply((Object)this._httpServletRequest)).map(pathFunction -> {
            if (this._name.equals("r")) {
                return (Function)pathFunction.apply((Object)new Path(id, nestedName));
            }
            return (Function)pathFunction.apply((Object)new Path(this._name, id));
        }).flatMap(identifierFunction -> this._getPageTry(id, nestedName, (Function<Object, Try<Page<T>>>)identifierFunction)).mapFailMatching(NoSuchElementException.class, ExceptionSupplierUtil.notFound(id, nestedName));
    }

    @Override
    public Try<SingleModel<T>> updateCollectionItem(String id, Body body) {
        return Try.fromFallible(this._itemRoutesSupplier).mapOptional(ItemRoutes::getUpdateItemFunctionOptional, ExceptionSupplierUtil.notAllowed(HTTPMethod.PUT, this._name, id)).map(requestFunction -> (Function)requestFunction.apply((Object)this._httpServletRequest)).map(identifierFunction -> identifierFunction.compose(this._pathToIdentifierFunction)).map(pathFunction -> (Function)pathFunction.apply(new Path(this._name, id))).flatMap(bodyFunction -> (Try)bodyFunction.apply(body));
    }

    private Try<Function<Body, Try<SingleModel<T>>>> _getFunctionTry(String id, String nestedName, Function<Object, Function<Body, Try<SingleModel<T>>>> identifierFunction) {
        if (this._name.equals("r")) {
            return Try.fromFallible(() -> (Function)identifierFunction.apply(this._pathToIdentifierFunction.apply((Object)new Path(id, nestedName))));
        }
        return this._singleModelFunction.apply(id).map(this::_getIdentifierFunction).map(identifierFunction::apply);
    }

    private Object _getIdentifierFunction(SingleModel<T> singleModel) throws Exception {
        Representor representor = (Representor)this._representorSupplier.get();
        return representor.getIdentifier(singleModel.getModel());
    }

    private Try<Page<T>> _getPageTry(String id, String nestedName, Function<Object, Try<Page<T>>> identifierFunction) {
        if (this._name.equals("r")) {
            return identifierFunction.apply(this._pathToIdentifierFunction.apply((Object)new Path(id, nestedName)));
        }
        return this._singleModelFunction.apply(id).map(this::_getIdentifierFunction).flatMap(identifierFunction::apply);
    }
}

