/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.endpoint;

import com.liferay.apio.architect.custom.actions.CustomRoute;
import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.function.throwable.ThrowableFunction;
import com.liferay.apio.architect.function.throwable.ThrowableTriFunction;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.internal.endpoint.ExceptionSupplierUtil;
import com.liferay.apio.architect.routes.CollectionRoutes;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import java.util.Optional;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

public class FormEndpoint {
    private final ThrowableFunction<String, CollectionRoutes<Object, Object>> _collectionRoutesFunction;
    private final ThrowableFunction<String, ItemRoutes<Object, Object>> _itemRoutesFunction;
    private final ThrowableTriFunction<String, String, String, NestedCollectionRoutes<Object, Object, Object>> _nestedCollectionRoutesFunction;

    public FormEndpoint(ThrowableFunction<String, CollectionRoutes<Object, Object>> collectionRoutesFunction, ThrowableFunction<String, ItemRoutes<Object, Object>> itemRoutesFunction, ThrowableTriFunction<String, String, String, NestedCollectionRoutes<Object, Object, Object>> nestedCollectionRoutesFunction) {
        this._collectionRoutesFunction = collectionRoutesFunction;
        this._itemRoutesFunction = itemRoutesFunction;
        this._nestedCollectionRoutesFunction = nestedCollectionRoutesFunction;
    }

    @GET
    @Path(value="c/{name}")
    public Try<Form> creatorForm(@PathParam(value="name") String name) {
        return Try.fromOptional(() -> (Optional)this._collectionRoutesFunction.andThen(CollectionRoutes::getFormOptional).apply((Object)name), ExceptionSupplierUtil.notFound(name));
    }

    @GET
    @Path(value="p/{name}/{nestedName}")
    public Try<Form<?>> customForm(@PathParam(value="name") String name, @PathParam(value="nestedName") String nestedName) {
        return Try.fromFallible(() -> (ItemRoutes)this._itemRoutesFunction.apply((Object)name)).map(ItemRoutes::getCustomRoutes).map(stringCustomRouteMap -> (CustomRoute)stringCustomRouteMap.get(nestedName)).flatMap(customRoute -> Try.fromOptional(() -> ((CustomRoute)customRoute).getFormOptional(), ExceptionSupplierUtil.notFound(name, nestedName)));
    }

    @GET
    @Path(value="c/{name}/{nestedName}")
    public Try<Form> nestedCreatorForm(@PathParam(value="name") String name, @PathParam(value="nestedName") String nestedName) {
        return Try.fromOptional(() -> (Optional)this._nestedCollectionRoutesFunction.andThen(NestedCollectionRoutes::getFormOptional).apply((Object)name, (Object)nestedName, (Object)nestedName), ExceptionSupplierUtil.notFound(name, nestedName));
    }

    @GET
    @Path(value="u/{name}")
    public Try<Form> updaterForm(@PathParam(value="name") String name) {
        return Try.fromOptional(() -> (Optional)this._itemRoutesFunction.andThen(ItemRoutes::getFormOptional).apply((Object)name), ExceptionSupplierUtil.notFound(name));
    }
}

