/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.endpoint;

import com.liferay.apio.architect.operation.HTTPMethod;
import java.util.function.Supplier;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;

public class ExceptionSupplierUtil {
    public static Supplier<NotAllowedException> notAllowed(HTTPMethod httpMethod, String ... path) {
        String message = httpMethod.name() + " method is not allowed for path " + String.join((CharSequence)"/", path);
        Response response = Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
        return () -> new NotAllowedException(message, response);
    }

    public static Supplier<NotFoundException> notFound(String ... path) {
        return () -> new NotFoundException("No endpoint found at path " + String.join((CharSequence)"/", path));
    }

    private ExceptionSupplierUtil() {
        throw new UnsupportedOperationException();
    }
}

