/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.endpoint;

import com.liferay.apio.architect.file.BinaryFile;
import com.liferay.apio.architect.function.throwable.ThrowableFunction;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.internal.endpoint.ExceptionSupplierUtil;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.single.model.SingleModel;
import java.util.function.BiFunction;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

public class BinaryEndpoint {
    private final ThrowableFunction<String, Representor<Object>> _representorFunction;
    private final BiFunction<String, String, Try<SingleModel<Object>>> _singleModelFunction;

    public BinaryEndpoint(ThrowableFunction<String, Representor<Object>> representorFunction, BiFunction<String, String, Try<SingleModel<Object>>> singleModelFunction) {
        this._representorFunction = representorFunction;
        this._singleModelFunction = singleModelFunction;
    }

    @GET
    @Path(value="{name}/{id}/{binaryId}")
    public Try<BinaryFile> getCollectionItemBinaryFileTry(@PathParam(value="name") String name, @PathParam(value="id") String id, @PathParam(value="binaryId") String binaryId) {
        return Try.fromFallible(() -> (Representor)this._representorFunction.apply((Object)name)).mapOptional(representor -> representor.getBinaryFunction(binaryId), ExceptionSupplierUtil.notFound(name, id, binaryId)).flatMap(binaryFunction -> this._singleModelFunction.apply(name, id).map(SingleModel::getModel).map(arg_0 -> binaryFunction.apply(arg_0)));
    }
}

