/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.endpoint;

import com.liferay.apio.architect.batch.BatchResult;
import com.liferay.apio.architect.form.Body;
import com.liferay.apio.architect.function.throwable.ThrowableFunction;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.internal.endpoint.BatchEndpoint;
import com.liferay.apio.architect.internal.endpoint.ExceptionSupplierUtil;
import com.liferay.apio.architect.operation.HTTPMethod;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.routes.CollectionRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.apio.architect.single.model.SingleModel;
import com.liferay.apio.architect.supplier.ThrowableSupplier;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;

public interface BatchEndpointBuilder {
    public static <T, S> RequestStep<T, S> name(String name) {
        return httpServletRequest -> singleModelFunction -> representorSupplier -> collectionRoutesSupplier -> nestedCollectionRoutesFunction -> () -> new BatchEndpointImpl(name, httpServletRequest, singleModelFunction, representorSupplier, collectionRoutesSupplier, nestedCollectionRoutesFunction);
    }

    @FunctionalInterface
    public static interface SingleModelFunctionStep<T, S> {
        public RepresentorSupplierStep<T, S> singleModelFunction(Function<String, Try<SingleModel<T>>> var1);
    }

    @FunctionalInterface
    public static interface RequestStep<T, S> {
        public SingleModelFunctionStep<T, S> httpServletRequest(HttpServletRequest var1);
    }

    @FunctionalInterface
    public static interface RepresentorSupplierStep<T, S> {
        public CollectionRoutesSupplierStep<T, S> representorSupplier(ThrowableSupplier<Representor<T>> var1);
    }

    @FunctionalInterface
    public static interface NestedCollectionRoutesFunctionStep<T, S> {
        public BuildStep<S> nestedCollectionRoutesFunction(ThrowableFunction<String, NestedCollectionRoutes<T, S, Object>> var1);
    }

    @FunctionalInterface
    public static interface CollectionRoutesSupplierStep<T, S> {
        public NestedCollectionRoutesFunctionStep<T, S> collectionRoutesSupplier(ThrowableSupplier<CollectionRoutes<T, S>> var1);
    }

    @FunctionalInterface
    public static interface BuildStep<T> {
        public BatchEndpoint<T> build();
    }

    public static class BatchEndpointImpl<T, S>
    implements BatchEndpoint<S> {
        private final ThrowableSupplier<CollectionRoutes<T, S>> _collectionRoutesSupplier;
        private final HttpServletRequest _httpServletRequest;
        private final String _name;
        private final ThrowableFunction<String, NestedCollectionRoutes<T, S, Object>> _nestedCollectionRoutesFunction;
        private final ThrowableSupplier<Representor<T>> _representorSupplier;
        private final Function<String, Try<SingleModel<T>>> _singleModelFunction;

        @Override
        public Try<BatchResult<S>> addBatchCollectionItems(Body body) {
            return Try.fromFallible(this._collectionRoutesSupplier).mapOptional(CollectionRoutes::getBatchCreateItemFunctionOptional, ExceptionSupplierUtil.notAllowed(HTTPMethod.POST, this._name)).map(requestFunction -> (Function)requestFunction.apply((Object)this._httpServletRequest)).flatMap(bodyFunction -> (Try)bodyFunction.apply(body));
        }

        @Override
        public Try<BatchResult<S>> addBatchNestedCollectionItems(String id, String nestedName, Body body) {
            return Try.fromFallible(() -> (NestedCollectionRoutes)this._nestedCollectionRoutesFunction.apply((Object)nestedName)).mapOptional(NestedCollectionRoutes::getNestedBatchCreateItemFunctionOptional, ExceptionSupplierUtil.notAllowed(HTTPMethod.POST, this._name)).map(requestFunction -> (Function)requestFunction.apply((Object)this._httpServletRequest)).map(bodyFunction -> (Function)bodyFunction.apply(body)).flatMap(identifierFunction -> this._singleModelFunction.apply(id).map(this::_getIdentifierFunction).flatMap(identifierFunction::apply)).mapFailMatching(NoSuchElementException.class, ExceptionSupplierUtil.notAllowed(HTTPMethod.POST, this._name, id, nestedName));
        }

        private BatchEndpointImpl(String name, HttpServletRequest httpServletRequest, Function<String, Try<SingleModel<T>>> singleModelFunction, ThrowableSupplier<Representor<T>> representorSupplier, ThrowableSupplier<CollectionRoutes<T, S>> collectionRoutesSupplier, ThrowableFunction<String, NestedCollectionRoutes<T, S, Object>> nestedCollectionRoutesFunction) {
            this._name = name;
            this._httpServletRequest = httpServletRequest;
            this._singleModelFunction = singleModelFunction;
            this._representorSupplier = representorSupplier;
            this._collectionRoutesSupplier = collectionRoutesSupplier;
            this._nestedCollectionRoutesFunction = nestedCollectionRoutesFunction;
        }

        private Object _getIdentifierFunction(SingleModel<T> singleModel) throws Exception {
            Representor representor = (Representor)this._representorSupplier.get();
            return representor.getIdentifier(singleModel.getModel());
        }
    }
}

