/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.annotation.representor;

import com.liferay.apio.architect.annotation.Vocabulary;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.internal.annotation.representor.NestedRepresentorTransformer;
import com.liferay.apio.architect.internal.unsafe.Unsafe;
import com.liferay.apio.architect.language.AcceptLanguage;
import com.liferay.apio.architect.representor.BaseRepresentor;
import com.liferay.apio.architect.representor.NestedRepresentor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;

public class RepresentorTransformerUtil {
    public static void addCommonFields(BaseRepresentor.BaseFirstStep<?, ?, ?> firstStep, Method method, Class<?> returnType, String key) {
        Vocabulary.LinkedModel linkedModel = method.getAnnotation(Vocabulary.LinkedModel.class);
        if (linkedModel != null) {
            firstStep.addLinkedModel(key, (Class)Unsafe.unsafeCast(linkedModel.value()), RepresentorTransformerUtil.getMethodFunction(method));
        } else if (returnType == String.class) {
            RepresentorTransformerUtil._addStringFields(firstStep, method, key);
        } else if (returnType == Date.class) {
            firstStep.addDate(key, RepresentorTransformerUtil.getMethodFunction(method));
        } else if (returnType == Boolean.class) {
            firstStep.addBoolean(key, RepresentorTransformerUtil.getMethodFunction(method));
        } else if (Number.class.isAssignableFrom(returnType)) {
            firstStep.addNumber(key, RepresentorTransformerUtil.getMethodFunction(method));
        } else if (returnType == List.class) {
            RepresentorTransformerUtil._addListFields(firstStep, method, key);
        } else {
            firstStep.addNested(key, RepresentorTransformerUtil.getMethodFunction(method), builder -> (NestedRepresentor)Unsafe.unsafeCast(NestedRepresentorTransformer.toRepresentor(returnType, builder)));
        }
    }

    public static <A, T, S> BiFunction<T, A, S> getMethodBiFunction(Method method) {
        return (t, a) -> Try.fromFallible(() -> method.invoke(t, a)).orElse(null);
    }

    public static <T, S> Function<T, S> getMethodFunction(Method method) {
        return t -> Try.fromFallible(() -> method.invoke(t, new Object[0])).orElse(null);
    }

    private static void _addListFields(BaseRepresentor.BaseFirstStep<?, ?, ?> firstStep, Method method, String key) {
        ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
        Class listClass = (Class)parameterizedType.getActualTypeArguments()[0];
        if (listClass == String.class) {
            firstStep.addStringList(key, RepresentorTransformerUtil.getMethodFunction(method));
        } else if (listClass == Boolean.class) {
            firstStep.addBooleanList(key, RepresentorTransformerUtil.getMethodFunction(method));
        } else if (Number.class.isAssignableFrom(listClass)) {
            firstStep.addNumberList(key, RepresentorTransformerUtil.getMethodFunction(method));
        } else {
            Vocabulary.Type field = listClass.getAnnotation(Vocabulary.Type.class);
            if (field != null) {
                firstStep.addNestedList(key, RepresentorTransformerUtil.getMethodFunction(method), builder -> (NestedRepresentor)Unsafe.unsafeCast(NestedRepresentorTransformer.toRepresentor(listClass, builder)));
            }
        }
    }

    private static void _addStringFields(BaseRepresentor.BaseFirstStep<?, ?, ?> firstStep, Method method, String key) {
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length > 0) {
            Class<?> firstParameter = parameters[0];
            if (firstParameter == Locale.class) {
                firstStep.addLocalizedStringByLocale(key, RepresentorTransformerUtil.getMethodBiFunction(method));
            } else if (firstParameter == AcceptLanguage.class) {
                firstStep.addLocalizedStringByLanguage(key, RepresentorTransformerUtil.getMethodBiFunction(method));
            }
        } else {
            Vocabulary.RelativeURL relativeURL = method.getAnnotation(Vocabulary.RelativeURL.class);
            if (relativeURL != null) {
                if (relativeURL.fromApplication()) {
                    firstStep.addApplicationRelativeURL(key, RepresentorTransformerUtil.getMethodFunction(method));
                } else {
                    firstStep.addRelativeURL(key, RepresentorTransformerUtil.getMethodFunction(method));
                }
            } else {
                firstStep.addString(key, RepresentorTransformerUtil.getMethodFunction(method));
            }
        }
    }
}

