/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.annotation.representor;

import com.liferay.apio.architect.annotation.Id;
import com.liferay.apio.architect.annotation.Vocabulary;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.internal.annotation.representor.RepresentorTransformerUtil;
import com.liferay.apio.architect.internal.representor.RepresentorImpl;
import com.liferay.apio.architect.internal.unsafe.Unsafe;
import com.liferay.apio.architect.related.RelatedCollection;
import com.liferay.apio.architect.representor.Representor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.reflect.MethodUtils;

public class RepresentorTransformer {
    public static <T extends Identifier<S>, S> Representor<T> toRepresentor(Class<T> typeClass, Function<Class<? extends Identifier<?>>, String> nameFunction, Map<String, List<RelatedCollection<?, ?>>> relatedCollections) {
        Vocabulary.Type type = typeClass.getAnnotation(Vocabulary.Type.class);
        Representor.Builder<T, S> builder = RepresentorTransformer._createBuilder(typeClass, nameFunction, (Map)Unsafe.unsafeCast(relatedCollections));
        Representor.FirstStep firstStep = builder.types(type.value(), new String[0]).identifier(s -> Try.fromFallible(() -> MethodUtils.getMethodsListWithAnnotation((Class)typeClass, Id.class)).filter(methods -> !methods.isEmpty()).map(methods -> (Method)methods.get(0)).map(identifierMethod -> identifierMethod.invoke(s, new Object[0])).orElse(null));
        List methods = MethodUtils.getMethodsListWithAnnotation(typeClass, Vocabulary.Field.class);
        methods.forEach(method -> RepresentorTransformer._processMethod(firstStep, method));
        return (Representor)firstStep.build();
    }

    private static <T extends Identifier<S>, S> Representor.Builder<T, S> _createBuilder(Class<T> typeClass, Function<Class<? extends Identifier<?>>, String> nameFunction, Map<String, List<RelatedCollection<T, ?>>> relatedCollections) {
        Supplier relatedCollectionsSupplier = () -> (List)relatedCollections.get(typeClass.getName());
        BiConsumer biConsumer = (identifierClass, relatedCollection) -> {
            List list = relatedCollections.computeIfAbsent(identifierClass.getName(), __ -> new ArrayList());
            list.add(relatedCollection);
        };
        return new RepresentorImpl.BuilderImpl(typeClass, nameFunction, biConsumer, relatedCollectionsSupplier);
    }

    private static <T extends Identifier<S>, S> void _processMethod(Representor.FirstStep<T> firstStep, Method method) {
        Class<?> returnType = method.getReturnType();
        Vocabulary.Field field = method.getAnnotation(Vocabulary.Field.class);
        String key = field.value();
        Vocabulary.RelatedCollection relatedCollection = method.getAnnotation(Vocabulary.RelatedCollection.class);
        Vocabulary.BidirectionalModel bidirectionalModel = method.getAnnotation(Vocabulary.BidirectionalModel.class);
        if (relatedCollection != null) {
            firstStep.addRelatedCollection(key, relatedCollection.value());
        } else if (bidirectionalModel != null) {
            Vocabulary.Field bidirectionalField = bidirectionalModel.field();
            firstStep.addBidirectionalModel(key, bidirectionalField.value(), (Class)Unsafe.unsafeCast(bidirectionalModel.modelClass()), RepresentorTransformerUtil.getMethodFunction(method));
        } else {
            RepresentorTransformerUtil.addCommonFields(firstStep, method, returnType, key);
        }
    }
}

