/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.annotation;

import com.liferay.apio.architect.annotation.Vocabulary;
import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.internal.annotation.representor.ActionRouterTypeExtractor;
import com.liferay.apio.architect.internal.annotation.representor.RepresentorTransformer;
import com.liferay.apio.architect.internal.annotation.representor.StringUtil;
import com.liferay.apio.architect.internal.wiring.osgi.manager.cache.ManagerCache;
import com.liferay.apio.architect.related.RelatedCollection;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.router.ActionRouter;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ActionRouterRepresentorManager.class})
public class ActionRouterRepresentorManager {
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, service=ActionRouter.class)
    private List<ActionRouter<?>> _actionRouters;
    private final Logger _logger = LoggerFactory.getLogger(this.getClass());

    @Activate
    public void activate() {
        ManagerCache.INSTANCE.clear();
    }

    public void computeRepresentors(Function<Class<? extends Identifier<?>>, String> nameFunction, Map<String, List<RelatedCollection<?, ?>>> relatedCollections) {
        if (this._actionRouters == null) {
            return;
        }
        Stream actionRouterStream = this._actionRouters.stream();
        actionRouterStream.map(ActionRouterTypeExtractor::extractTypeClass).forEach(typeClassTry -> typeClassTry.voidFold(__ -> this._logger.warn("Unable to extract class from action router"), typeClass -> this._computeRepresentor((Class)typeClass, nameFunction, relatedCollections)));
    }

    @Deactivate
    public void deactivate() {
        ManagerCache.INSTANCE.clear();
    }

    private <T extends Identifier<S>, S> void _computeRepresentor(Class<T> typeClass, Function<Class<? extends Identifier<?>>, String> nameFunction, Map<String, List<RelatedCollection<?, ?>>> relatedCollections) {
        Representor<T> representor = RepresentorTransformer.toRepresentor(typeClass, nameFunction, relatedCollections);
        Vocabulary.Type type = typeClass.getAnnotation(Vocabulary.Type.class);
        String name = StringUtil.toLowercaseSlug(type.value());
        ManagerCache.INSTANCE.putName(typeClass.getName(), name);
        ManagerCache.INSTANCE.putIdentifierClass(name, typeClass);
        ManagerCache.INSTANCE.putRepresentor(name, representor);
    }
}

