/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.antivirus.async.store.jmx;

import com.liferay.antivirus.async.store.event.AntivirusAsyncEvent;
import com.liferay.antivirus.async.store.event.AntivirusAsyncEventListener;
import com.liferay.antivirus.async.store.jmx.AntivirusAsyncStatisticsManagerMBean;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationStatistics;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.util.Dictionary;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.antivirus.async.store.configuration.AntivirusAsyncConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"jmx.objectname=com.liferay.antivirus:classification=antivirus_async,name=AntivirusAsyncStatistics", "jmx.objectname.cache.key=AntivirusAsyncStatistics"}, service={DynamicMBean.class})
public class AntivirusAsyncStatisticsManager
extends StandardMBean
implements AntivirusAsyncStatisticsManagerMBean {
    private static final Log _log = LogFactoryUtil.getLog(AntivirusAsyncStatisticsManager.class);
    private boolean _autoRefresh;
    private volatile DestinationStatistics _destinationStatistics;
    private long _lastRefresh;
    @Reference
    private MessageBus _messageBus;
    private final AtomicLong _processingErrorCounter = new AtomicLong();
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    private ServiceRegistration<AntivirusAsyncEventListener> _serviceRegistration;
    private final AtomicLong _sizeExceededCounter = new AtomicLong();
    private final AtomicLong _totalScannedCounter = new AtomicLong();
    private final AtomicLong _virusFoundCounter = new AtomicLong();

    @Activate
    public AntivirusAsyncStatisticsManager() throws NotCompliantMBeanException {
        super(AntivirusAsyncStatisticsManagerMBean.class);
    }

    @Override
    public int getActiveScanCount() {
        if (this._autoRefresh || this._destinationStatistics == null) {
            this.refresh();
        }
        if (this._destinationStatistics == null) {
            return 0;
        }
        return this._destinationStatistics.getActiveThreadCount();
    }

    @Override
    public String getLastRefresh() {
        return String.valueOf(this._lastRefresh);
    }

    @Override
    public long getPendingScanCount() {
        if (this._autoRefresh || this._destinationStatistics == null) {
            this.refresh();
        }
        long pendingScanCount = 0L;
        if (this._destinationStatistics != null) {
            pendingScanCount = this._destinationStatistics.getPendingMessageCount();
        }
        try {
            List scheduledJobs = this._schedulerEngineHelper.getScheduledJobs("Antivirus", StorageType.MEMORY_CLUSTERED);
            pendingScanCount += (long)scheduledJobs.size();
        }
        catch (SchedulerException schedulerException) {
            _log.error((Object)"Unable to get antivirus scheduled jobs", (Throwable)schedulerException);
        }
        return pendingScanCount;
    }

    @Override
    public long getProcessingErrorCount() {
        return this._processingErrorCounter.get();
    }

    @Override
    public long getSizeExceededCount() {
        return this._sizeExceededCounter.get();
    }

    @Override
    public long getTotalScannedCount() {
        return this._totalScannedCounter.get();
    }

    @Override
    public long getVirusFoundCount() {
        return this._virusFoundCounter.get();
    }

    @Override
    public boolean isAutoRefresh() {
        return this._autoRefresh;
    }

    @Override
    public void refresh() {
        if (System.currentTimeMillis() > this._lastRefresh) {
            Destination destination = this._messageBus.getDestination("liferay/antivirus");
            if (destination != null) {
                this._destinationStatistics = destination.getDestinationStatistics();
            }
            this._lastRefresh = System.currentTimeMillis();
            this._processingErrorCounter.set(0L);
            this._sizeExceededCounter.set(0L);
            this._totalScannedCounter.set(0L);
            this._virusFoundCounter.set(0L);
        }
    }

    @Override
    public void setAutoRefresh(boolean autoRefresh) {
        this._autoRefresh = autoRefresh;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceRegistration = bundleContext.registerService(AntivirusAsyncEventListener.class, message -> {
            AntivirusAsyncEvent antivirusAsyncEvent = (AntivirusAsyncEvent)((Object)((Object)message.get("antivirusAsyncEvent")));
            if (antivirusAsyncEvent == AntivirusAsyncEvent.PROCESSING_ERROR) {
                this._processingErrorCounter.incrementAndGet();
            } else if (antivirusAsyncEvent == AntivirusAsyncEvent.SIZE_EXCEEDED) {
                this._sizeExceededCounter.incrementAndGet();
            } else if (antivirusAsyncEvent == AntivirusAsyncEvent.SUCCESS) {
                this._totalScannedCounter.incrementAndGet();
            } else if (antivirusAsyncEvent == AntivirusAsyncEvent.VIRUS_FOUND) {
                this._totalScannedCounter.incrementAndGet();
                this._virusFoundCounter.incrementAndGet();
            }
        }, (Dictionary)new HashMapDictionary());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }
}

