/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.antivirus.async.store.internal.scheduler;

import com.liferay.antivirus.async.store.configuration.AntivirusAsyncConfiguration;
import com.liferay.antivirus.async.store.internal.event.AntivirusAsyncEventListenerManager;
import com.liferay.antivirus.async.store.util.AntivirusAsyncUtil;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.antivirus.async.store.configuration.AntivirusAsyncConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"osgi.command.function=scan", "osgi.command.scope=antivirus"}, service={SchedulerJobConfiguration.class})
public class AntivirusAsyncFileStoreSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    private static final Log _log = LogFactoryUtil.getLog(AntivirusAsyncFileStoreSchedulerJobConfiguration.class);
    @Reference
    private AntivirusAsyncEventListenerManager _antivirusAsyncEventListenerManager;
    @Reference
    private com.liferay.portal.kernel.util.File _file;
    @Reference
    private MessageBus _messageBus;
    @Reference(target="(rootDir=*)")
    private ServiceReference<Store> _storeServiceReference;
    private TriggerConfiguration _triggerConfiguration;

    public String getDestinationName() {
        return "liferay/antivirus_batch";
    }

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        File file = (File)this._storeServiceReference.getProperty("rootDir");
        return () -> this.scan(file.getAbsolutePath());
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return this._triggerConfiguration;
    }

    public void scan(String rootDirAbsolutePathString) {
        try {
            this._scan(rootDirAbsolutePathString);
        }
        catch (IOException ioException) {
            ReflectionUtil.throwException((Throwable)ioException);
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        AntivirusAsyncConfiguration antivirusAsyncConfiguration = (AntivirusAsyncConfiguration)ConfigurableUtil.createConfigurable(AntivirusAsyncConfiguration.class, properties);
        this._triggerConfiguration = TriggerConfiguration.createTriggerConfiguration((String)antivirusAsyncConfiguration.batchScanCronExpression());
        this._triggerConfiguration.setStartDate(new Date(System.currentTimeMillis() + TimeUnit.SECOND.toMillis(30L)));
    }

    private void _scan(String rootDirAbsolutePathString) throws IOException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Scanning " + rootDirAbsolutePathString));
        }
        final Path rootPath = Paths.get(rootDirAbsolutePathString, new String[0]);
        Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dirPath, IOException ioException) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                try {
                    AntivirusAsyncFileStoreSchedulerJobConfiguration.this._scheduleAntivirusScan(rootPath, filePath);
                }
                catch (Throwable throwable) {
                    _log.error((Object)("Unable to schedule antivirus scan for " + filePath), throwable);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void _scheduleAntivirusScan(Path rootPath, Path filePath) {
        String fileDirectoryParts;
        String fileExtension;
        Path relativePath = rootPath.relativize(filePath);
        if (relativePath.getNameCount() <= 1) {
            return;
        }
        Path companyIdPath = relativePath.getName(0);
        long companyId = GetterUtil.getLong((String)companyIdPath.toString());
        Path repositoryIdPath = (relativePath = companyIdPath.relativize(relativePath)).getName(0);
        long repositoryId = GetterUtil.getLong((String)repositoryIdPath.toString());
        if (repositoryId == 999999999999999999L) {
            return;
        }
        relativePath = repositoryIdPath.relativize(relativePath);
        String versionLabel = String.valueOf(relativePath.getFileName());
        relativePath = relativePath.subpath(0, relativePath.getNameCount() - 1);
        String fileNameFragment = "";
        int x = versionLabel.lastIndexOf(95);
        if (x > -1) {
            if (x > 0) {
                fileNameFragment = versionLabel.substring(0, x);
            }
            int y = versionLabel.lastIndexOf(46);
            versionLabel = versionLabel.substring(x + 1, y);
        }
        String fileName = String.valueOf(relativePath.getFileName());
        String fileDirectory = "";
        if (relativePath.getNameCount() > 1) {
            fileDirectory = String.valueOf(relativePath.subpath(0, relativePath.getNameCount() - 1));
        }
        if ((fileExtension = this._file.getExtension(fileName)).equals("afsh")) {
            fileExtension = "";
            fileName = this._file.stripExtension(fileName);
        }
        if (!fileNameFragment.isEmpty() && fileName.startsWith(fileDirectoryParts = fileDirectory.replaceAll("/", ""))) {
            fileDirectory = "";
        }
        if (!fileDirectory.isEmpty()) {
            fileName = StringBundler.concat((String[])new String[]{fileDirectory, "/", fileName});
            if (fileNameFragment.isEmpty()) {
                fileName = fileName + "/";
            }
        }
        Message message = new Message();
        message.put("companyId", (Object)companyId);
        message.put("fileExtension", (Object)fileExtension);
        message.put("fileName", (Object)fileName);
        message.put("jobName", (Object)AntivirusAsyncUtil.getJobName(companyId, repositoryId, fileName, versionLabel));
        message.put("repositoryId", (Object)repositoryId);
        try {
            long size = -1L;
            if (Files.exists(filePath, new LinkOption[0])) {
                size = Files.size(filePath);
            }
            message.put("size", (Object)size);
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
        }
        message.put("userId", (Object)0L);
        message.put("versionLabel", (Object)versionLabel);
        this._antivirusAsyncEventListenerManager.onPrepare(message);
        this._messageBus.sendMessage("liferay/antivirus", message);
    }
}

