/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.antivirus.async.store.internal.event;

import com.liferay.antivirus.async.store.event.AntivirusAsyncEvent;
import com.liferay.antivirus.async.store.event.AntivirusAsyncEventListener;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={AntivirusAsyncEventListenerManager.class})
public class AntivirusAsyncEventListenerManager {
    private static final String _CLASS_NAME_ANY = "<ANY>";
    private static final ServiceReferenceMapper<String, AntivirusAsyncEventListener> _serviceReferenceMapper = (serviceReference, emitter) -> {
        List classNames = StringUtil.asList((Object)serviceReference.getProperty("class.name"));
        for (String className : classNames) {
            emitter.emit((Object)className);
        }
        if (classNames.isEmpty()) {
            emitter.emit((Object)_CLASS_NAME_ANY);
        }
    };
    private ServiceTrackerMap<String, List<AntivirusAsyncEventListener>> _serviceTrackerMap;

    public void onMissing(Message message) {
        this._onEvent(AntivirusAsyncEvent.MISSING, message);
    }

    public void onPrepare(Message message) {
        this._onEvent(AntivirusAsyncEvent.PREPARE, message);
    }

    public void onProcessingError(Message message, Exception exception) {
        message.put("exception", (Object)exception);
        this._onEvent(AntivirusAsyncEvent.PROCESSING_ERROR, message);
    }

    public void onSizeExceeded(Message message, Exception exception) {
        message.put("exception", (Object)exception);
        this._onEvent(AntivirusAsyncEvent.SIZE_EXCEEDED, message);
    }

    public void onSuccess(Message message) {
        this._onEvent(AntivirusAsyncEvent.SUCCESS, message);
    }

    public void onVirusFound(Message message, Exception exception, String virusName) {
        message.put("exception", (Object)exception);
        message.put("virusName", (Object)virusName);
        this._onEvent(AntivirusAsyncEvent.VIRUS_FOUND, message);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, AntivirusAsyncEventListener.class, null, _serviceReferenceMapper);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private void _onEvent(AntivirusAsyncEvent antivirusAsyncEvent, Message message) {
        message.put("antivirusAsyncEvent", (Object)antivirusAsyncEvent);
        String className = message.getString("className");
        List antivirusAsyncEventListeners = (List)this._serviceTrackerMap.getService((Object)className);
        if (antivirusAsyncEventListeners != null) {
            antivirusAsyncEventListeners.forEach(antivirusAsyncEventListener -> antivirusAsyncEventListener.receive(message));
        }
        if ((antivirusAsyncEventListeners = (List)this._serviceTrackerMap.getService((Object)_CLASS_NAME_ANY)) != null) {
            antivirusAsyncEventListeners.forEach(listener -> listener.receive(message));
        }
    }
}

