/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.antivirus.async.store.internal;

import com.liferay.antivirus.async.store.internal.event.AntivirusAsyncEventListenerManager;
import com.liferay.antivirus.async.store.util.AntivirusAsyncUtil;
import com.liferay.document.library.kernel.exception.AccessDeniedException;
import com.liferay.document.library.kernel.exception.DirectoryNameException;
import com.liferay.document.library.kernel.store.DLStore;
import com.liferay.document.library.kernel.store.DLStoreRequest;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.document.library.kernel.util.DLValidator;
import com.liferay.petra.io.ByteArrayFileInputStream;
import com.liferay.petra.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.antivirus.async.store.configuration.AntivirusAsyncConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.ranking:Integer=1000"}, service={DLStore.class})
public class AntivirusAsyncDLStore
implements DLStore {
    @Reference
    private AntivirusAsyncEventListenerManager _antivirusAsyncEventListenerManager;
    @Reference
    private DLValidator _dlValidator;
    @Reference
    private com.liferay.portal.kernel.util.File _file;
    @Reference
    private MessageBus _messageBus;
    @Reference(target="(default=true)")
    private Store _store;

    public void addFile(DLStoreRequest dlStoreRequest, byte[] bytes) throws PortalException {
        this._validate(dlStoreRequest.getFileName(), null, null, dlStoreRequest.isValidateFileExtension(), null);
        try {
            this._store.addFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.getVersionLabel(), (InputStream)new UnsyncByteArrayInputStream(bytes));
            this._registerCallback(dlStoreRequest);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new PrincipalException((Throwable)accessDeniedException);
        }
    }

    public void addFile(DLStoreRequest dlStoreRequest, File file) throws PortalException {
        this._validate(dlStoreRequest.getFileName(), null, null, dlStoreRequest.isValidateFileExtension(), null);
        try (FileInputStream inputStream = new FileInputStream(file);){
            this._store.addFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.getVersionLabel(), (InputStream)inputStream);
            this._registerCallback(dlStoreRequest);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new PrincipalException((Throwable)accessDeniedException);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public void addFile(DLStoreRequest dlStoreRequest, InputStream inputStream1) throws PortalException {
        if (inputStream1 instanceof ByteArrayFileInputStream) {
            ByteArrayFileInputStream byteArrayFileInputStream = (ByteArrayFileInputStream)inputStream1;
            this.addFile(dlStoreRequest, byteArrayFileInputStream.getFile());
            return;
        }
        this._validate(dlStoreRequest.getFileName(), null, null, dlStoreRequest.isValidateFileExtension(), null);
        File tempFile = null;
        try {
            tempFile = this._file.createTempFile();
            this._file.write(tempFile, inputStream1);
            try (FileInputStream inputStream2 = new FileInputStream(tempFile);){
                this._store.addFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.getVersionLabel(), (InputStream)inputStream2);
            }
            this._registerCallback(dlStoreRequest);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new PrincipalException((Throwable)accessDeniedException);
        }
        catch (IOException ioException) {
            throw new SystemException("Unable to scan file " + dlStoreRequest.getFileName(), (Throwable)ioException);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    public void copyFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        InputStream inputStream = this._store.getFileAsStream(companyId, repositoryId, fileName, fromVersionLabel);
        if (inputStream == null) {
            inputStream = new UnsyncByteArrayInputStream(new byte[0]);
        }
        this._store.addFile(companyId, repositoryId, fileName, toVersionLabel, inputStream);
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) {
        this._store.deleteDirectory(companyId, repositoryId, dirName);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName) throws PortalException {
        this._validate(fileName, null, null, false, "");
        for (String versionLabel : this._store.getFileVersions(companyId, repositoryId, fileName)) {
            this._store.deleteFile(companyId, repositoryId, fileName, versionLabel);
        }
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this._validate(fileName, null, null, false, versionLabel);
        try {
            this._store.deleteFile(companyId, repositoryId, fileName, versionLabel);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new PrincipalException((Throwable)accessDeniedException);
        }
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this._validate(fileName, null, null, false, versionLabel);
        return this._store.getFileAsStream(companyId, repositoryId, fileName, versionLabel);
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws PortalException {
        if (!this._dlValidator.isValidName(dirName)) {
            throw new DirectoryNameException(dirName);
        }
        return this._store.getFileNames(companyId, repositoryId, dirName);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException {
        this._validate(fileName, null, null, false, null);
        return this._store.getFileSize(companyId, repositoryId, fileName, "");
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this._validate(fileName, null, null, false, versionLabel);
        return this._store.hasFile(companyId, repositoryId, fileName, versionLabel);
    }

    public void updateFile(DLStoreRequest dlStoreRequest, File file) throws PortalException {
        this._validate(dlStoreRequest.getFileName(), dlStoreRequest.getFileExtension(), dlStoreRequest.getSourceFileName(), dlStoreRequest.isValidateFileExtension(), dlStoreRequest.getVersionLabel());
        try (FileInputStream inputStream = new FileInputStream(file);){
            this._store.addFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.getVersionLabel(), (InputStream)inputStream);
            this._registerCallback(dlStoreRequest);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new PrincipalException((Throwable)accessDeniedException);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public void updateFile(DLStoreRequest dlStoreRequest, InputStream inputStream) throws PortalException {
        this._validate(dlStoreRequest.getFileName(), dlStoreRequest.getFileExtension(), dlStoreRequest.getSourceFileName(), dlStoreRequest.isValidateFileExtension(), dlStoreRequest.getVersionLabel());
        try {
            this._store.addFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.getVersionLabel(), inputStream);
            this._registerCallback(dlStoreRequest);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new PrincipalException((Throwable)accessDeniedException);
        }
    }

    public void updateFile(long companyId, long repositoryId, long newRepositoryId, String fileName) throws PortalException {
        for (String versionLabel : this._store.getFileVersions(companyId, repositoryId, fileName)) {
            this._store.addFile(companyId, newRepositoryId, fileName, versionLabel, this._store.getFileAsStream(companyId, repositoryId, fileName, versionLabel));
            this._store.deleteFile(companyId, repositoryId, fileName, versionLabel);
        }
    }

    public void updateFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        InputStream inputStream = this._store.getFileAsStream(companyId, repositoryId, fileName, fromVersionLabel);
        if (inputStream == null) {
            inputStream = new UnsyncByteArrayInputStream(new byte[0]);
        }
        this._store.addFile(companyId, repositoryId, fileName, toVersionLabel, inputStream);
        this._store.deleteFile(companyId, repositoryId, fileName, fromVersionLabel);
    }

    private void _registerCallback(DLStoreRequest dlStoreRequest) throws PortalException {
        Message message = new Message();
        message.put("className", (Object)dlStoreRequest.getClassName());
        message.put("classPK", (Object)dlStoreRequest.getClassPK());
        message.put("companyId", (Object)dlStoreRequest.getCompanyId());
        message.put("entryURL", (Object)dlStoreRequest.getEntryURL());
        message.put("fileExtension", (Object)dlStoreRequest.getFileExtension());
        message.put("fileName", (Object)dlStoreRequest.getFileName());
        message.put("jobName", (Object)AntivirusAsyncUtil.getJobName(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.getVersionLabel()));
        message.put("repositoryId", (Object)dlStoreRequest.getRepositoryId());
        message.put("size", (Object)dlStoreRequest.getSize());
        message.put("sourceFileName", (Object)dlStoreRequest.getSourceFileName());
        long userId = 0L;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null) {
            userId = permissionChecker.getUserId();
        }
        message.put("userId", (Object)userId);
        message.put("versionLabel", (Object)dlStoreRequest.getVersionLabel());
        this._antivirusAsyncEventListenerManager.onPrepare(message);
        TransactionCommitCallbackUtil.registerCallback(() -> {
            this._messageBus.sendMessage("liferay/antivirus", message);
            return null;
        });
    }

    private void _validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, String versionLabel) throws PortalException {
        this._dlValidator.validateFileName(fileName);
        if (validateFileExtension) {
            this._dlValidator.validateFileExtension(fileName);
        }
        this._dlValidator.validateSourceFileExtension(fileExtension, sourceFileName);
        this._dlValidator.validateVersionLabel(versionLabel);
    }
}

