/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.antivirus.async.store;

import com.liferay.antivirus.async.store.internal.event.AntivirusAsyncEventListenerManager;
import com.liferay.antivirus.async.store.util.AntivirusAsyncUtil;
import com.liferay.document.library.kernel.antivirus.AntivirusScanner;
import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.document.library.kernel.antivirus.AntivirusVirusFoundException;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import java.io.InputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.antivirus.async.store.configuration.AntivirusAsyncConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={AntivirusScannerHelper.class})
public class AntivirusScannerHelper {
    private static final Log _log = LogFactoryUtil.getLog(AntivirusScannerHelper.class);
    @Reference
    private AntivirusAsyncEventListenerManager _antivirusAsyncEventListenerManager;
    @Reference
    private AntivirusScanner _antivirusScanner;
    @Reference(target="(default=true)")
    private Store _store;

    public void processMessage(Message message) {
        block9: {
            try {
                long companyId = message.getLong("companyId");
                long repositoryId = message.getLong("repositoryId");
                String fileName = message.getString("fileName");
                String versionLabel = message.getString("versionLabel");
                boolean fileExists = this._store.hasFile(companyId, repositoryId, fileName, versionLabel);
                if (!fileExists) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)StringBundler.concat((Object[])new Object[]{AntivirusAsyncUtil.getFileIdentifier(message), " is no longer present: ", message.getValues()}));
                    }
                    this._antivirusAsyncEventListenerManager.onMissing(message);
                    return;
                }
                try {
                    InputStream inputStream = this._store.getFileAsStream(companyId, repositoryId, fileName, versionLabel);
                    this._antivirusScanner.scan(inputStream);
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)StringBundler.concat((Object[])new Object[]{AntivirusAsyncUtil.getFileIdentifier(message), " was scanned successfully: ", message.getValues()}));
                    }
                    this._antivirusAsyncEventListenerManager.onSuccess(message);
                }
                catch (AntivirusScannerException antivirusScannerException) {
                    int type = antivirusScannerException.getType();
                    if (antivirusScannerException instanceof AntivirusVirusFoundException) {
                        AntivirusVirusFoundException antivirusVirusFoundException = (AntivirusVirusFoundException)antivirusScannerException;
                        this._store.addFile(companyId, 999999999999999999L, fileName, versionLabel, this._store.getFileAsStream(companyId, repositoryId, fileName, versionLabel));
                        this._store.deleteFile(companyId, repositoryId, fileName, versionLabel);
                        this._antivirusAsyncEventListenerManager.onVirusFound(message, (Exception)antivirusVirusFoundException, antivirusVirusFoundException.getVirusName());
                        break block9;
                    }
                    if (type == 3) {
                        this._antivirusAsyncEventListenerManager.onSizeExceeded(message, (Exception)((Object)antivirusScannerException));
                        break block9;
                    }
                    throw antivirusScannerException;
                }
            }
            catch (Exception exception) {
                this._antivirusAsyncEventListenerManager.onProcessingError(message, exception);
            }
        }
    }
}

