/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public class TableNameOrderByComparator<T>
extends OrderByComparator<T> {
    private final OrderByComparator<T> _orderByComparator;
    private String _tableName;

    public TableNameOrderByComparator(OrderByComparator<T> orderByComparator, String tableName) {
        this._orderByComparator = orderByComparator;
        this.setTableName(tableName);
    }

    @Override
    public int compare(T obj1, T obj2) {
        return this._orderByComparator.compare(obj1, obj2);
    }

    @Override
    public String getOrderBy() {
        String orderBy = this._orderByComparator.getOrderBy();
        if (this._tableName == null) {
            return orderBy;
        }
        String[] columnNames = StringUtil.split(orderBy);
        StringBundler sb = new StringBundler(3 * columnNames.length - 1);
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            if (columnName.indexOf(46) != -1) {
                columnName = StringUtil.split(columnName, '.')[1];
            }
            sb.append(this._tableName);
            sb.append(StringUtil.trim(columnName));
            if (i >= columnNames.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public String[] getOrderByConditionFields() {
        return this._orderByComparator.getOrderByConditionFields();
    }

    @Override
    public Object[] getOrderByConditionValues(Object obj) {
        return this._orderByComparator.getOrderByConditionValues(obj);
    }

    @Override
    public String[] getOrderByFields() {
        return this._orderByComparator.getOrderByFields();
    }

    public OrderByComparator<T> getWrappedOrderByComparator() {
        return this._orderByComparator;
    }

    @Override
    public boolean isAscending() {
        return this._orderByComparator.isAscending();
    }

    @Override
    public boolean isAscending(String field) {
        return this._orderByComparator.isAscending(field);
    }

    public void setTableName(String tableName) {
        this._tableName = Validator.isNotNull(tableName) ? (tableName.endsWith(".") ? tableName : tableName + '.') : null;
    }

    @Override
    public String toString() {
        return this._orderByComparator.toString();
    }
}

