/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process;

import com.liferay.portal.kernel.concurrent.BaseFutureListener;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.process.CollectorOutputProcessor;
import com.liferay.portal.kernel.process.ConsumerOutputProcessor;
import com.liferay.portal.kernel.process.EchoOutputProcessor;
import com.liferay.portal.kernel.process.LoggingOutputProcessor;
import com.liferay.portal.kernel.process.OutputProcessor;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.TerminationProcessException;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicMarkableReference;

public class ProcessUtil {
    @Deprecated
    public static final CollectorOutputProcessor COLLECTOR_OUTPUT_PROCESSOR = new CollectorOutputProcessor();
    @Deprecated
    public static final ConsumerOutputProcessor CONSUMER_OUTPUT_PROCESSOR = new ConsumerOutputProcessor();
    @Deprecated
    public static final EchoOutputProcessor ECHO_OUTPUT_PROCESSOR = new EchoOutputProcessor();
    public static final LoggingOutputProcessor LOGGING_OUTPUT_PROCESSOR = new LoggingOutputProcessor();

    public static <O, E> NoticeableFuture<ObjectValuePair<O, E>> execute(OutputProcessor<O, E> outputProcessor, List<String> arguments) throws ProcessException {
        if (outputProcessor == null) {
            throw new NullPointerException("Output processor is null");
        }
        if (arguments == null) {
            throw new NullPointerException("Arguments is null");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
        String threadNamePrefix = ProcessUtil._buildThreadNamePrefix(arguments);
        try {
            Process process = processBuilder.start();
            NoticeableFuture stdOutNoticeableFuture = ProcessUtil._submit(threadNamePrefix.concat("StdOut"), new ProcessStdOutCallable(outputProcessor, process));
            NoticeableFuture stdErrNoticeableFuture = ProcessUtil._submit(threadNamePrefix.concat("StdErr"), new ProcessStdErrCallable(outputProcessor, process));
            return ProcessUtil._wrapNoticeableFuture(stdOutNoticeableFuture, stdErrNoticeableFuture, process);
        }
        catch (IOException ioe) {
            throw new ProcessException(ioe);
        }
    }

    public static <O, E> NoticeableFuture<ObjectValuePair<O, E>> execute(OutputProcessor<O, E> outputProcessor, String ... arguments) throws ProcessException {
        return ProcessUtil.execute(outputProcessor, Arrays.asList(arguments));
    }

    @Deprecated
    public void destroy() {
    }

    private static String _buildThreadNamePrefix(List<String> arguments) {
        StringBundler sb = new StringBundler(arguments.size() * 2 + 1);
        sb.append("[");
        for (String argument : arguments) {
            sb.append(argument);
            sb.append(" ");
        }
        sb.setStringAt("]", sb.index() - 1);
        sb.append("-");
        return sb.toString();
    }

    private static <T> NoticeableFuture<T> _submit(String threadName, Callable<T> callable) {
        DefaultNoticeableFuture<T> defaultNoticeableFuture = new DefaultNoticeableFuture<T>(callable);
        Thread thread = new Thread(defaultNoticeableFuture, threadName);
        thread.setDaemon(true);
        thread.start();
        return defaultNoticeableFuture;
    }

    private static <O, E> NoticeableFuture<ObjectValuePair<O, E>> _wrapNoticeableFuture(NoticeableFuture<O> stdOutNoticeableFuture, NoticeableFuture<E> stdErrNoticeableFuture, Process process) {
        final DefaultNoticeableFuture<ObjectValuePair<O, E>> defaultNoticeableFuture = new DefaultNoticeableFuture<ObjectValuePair<O, E>>();
        defaultNoticeableFuture.addFutureListener(future -> {
            if (!future.isCancelled()) {
                return;
            }
            stdOutNoticeableFuture.cancel(true);
            stdErrNoticeableFuture.cancel(true);
            process.destroy();
        });
        final AtomicMarkableReference<Object> stdOutReference = new AtomicMarkableReference<Object>(null, false);
        final AtomicMarkableReference<Object> stdErrReference = new AtomicMarkableReference<Object>(null, false);
        stdOutNoticeableFuture.addFutureListener(new BaseFutureListener<O>(){

            @Override
            public void completeWithCancel(Future<O> future) {
                defaultNoticeableFuture.cancel(true);
            }

            @Override
            public void completeWithException(Future<O> future, Throwable throwable) {
                defaultNoticeableFuture.setException(throwable);
            }

            @Override
            public void completeWithResult(Future<O> future, O stdOut) {
                stdOutReference.set(stdOut, true);
                boolean[] markHolder = new boolean[1];
                Object stdErr = stdErrReference.get(markHolder);
                if (markHolder[0]) {
                    defaultNoticeableFuture.set(new ObjectValuePair(stdOut, stdErr));
                }
            }
        });
        stdErrNoticeableFuture.addFutureListener(new BaseFutureListener<E>(){

            @Override
            public void completeWithCancel(Future<E> future) {
                defaultNoticeableFuture.cancel(true);
            }

            @Override
            public void completeWithException(Future<E> future, Throwable throwable) {
                defaultNoticeableFuture.setException(throwable);
            }

            @Override
            public void completeWithResult(Future<E> future, E stdErr) {
                stdErrReference.set(stdErr, true);
                boolean[] markHolder = new boolean[1];
                Object stdOut = stdOutReference.get(markHolder);
                if (markHolder[0]) {
                    defaultNoticeableFuture.set(new ObjectValuePair(stdOut, stdErr));
                }
            }
        });
        return defaultNoticeableFuture;
    }

    private static class ProcessStdOutCallable<T>
    implements Callable<T> {
        private final OutputProcessor<T, ?> _outputProcessor;
        private final Process _process;

        @Override
        public T call() throws Exception {
            try {
                T t = this._outputProcessor.processStdOut(this._process.getInputStream());
                return t;
            }
            finally {
                try {
                    int exitCode = this._process.waitFor();
                    if (exitCode != 0) {
                        throw new TerminationProcessException(exitCode);
                    }
                }
                catch (InterruptedException ie) {
                    this._process.destroy();
                    throw new ProcessException("Forcibly killed subprocess on interruption", ie);
                }
            }
        }

        private ProcessStdOutCallable(OutputProcessor<T, ?> outputProcessor, Process process) {
            this._outputProcessor = outputProcessor;
            this._process = process;
        }
    }

    private static class ProcessStdErrCallable<T>
    implements Callable<T> {
        private final OutputProcessor<?, T> _outputProcessor;
        private final Process _process;

        @Override
        public T call() throws Exception {
            return this._outputProcessor.processStdErr(this._process.getErrorStream());
        }

        private ProcessStdErrCallable(OutputProcessor<?, T> outputProcessor, Process process) {
            this._outputProcessor = outputProcessor;
            this._process = process;
        }
    }
}

