/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.unsync;

import com.liferay.portal.kernel.nio.charset.CharsetEncoderUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class UnsyncCharArrayWriter
extends Writer {
    protected char[] buffer;
    protected int index;

    public UnsyncCharArrayWriter() {
        this(32);
    }

    public UnsyncCharArrayWriter(int initialSize) {
        this.buffer = new char[initialSize];
    }

    @Override
    public Writer append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence) {
        String string = null;
        string = charSequence == null ? "null" : charSequence.toString();
        this.write(string, 0, string.length());
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int start, int end) {
        String string = null;
        string = charSequence == null ? "null" : charSequence.subSequence(start, end).toString();
        this.write(string, 0, string.length());
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    public void reset() {
        this.index = 0;
    }

    public int size() {
        return this.index;
    }

    public CharBuffer toCharBuffer() {
        return CharBuffer.wrap(this.buffer, 0, this.index);
    }

    public String toString() {
        return new String(this.buffer, 0, this.index);
    }

    @Override
    public void write(char[] chars) {
        this.write(chars, 0, chars.length);
    }

    @Override
    public void write(char[] chars, int offset, int length) {
        if (length <= 0) {
            return;
        }
        int newIndex = this.index + length;
        if (newIndex > this.buffer.length) {
            int newBufferSize = Math.max(this.buffer.length << 1, newIndex);
            char[] newBuffer = new char[newBufferSize];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.index);
            this.buffer = newBuffer;
        }
        System.arraycopy(chars, offset, this.buffer, this.index, length);
        this.index = newIndex;
    }

    @Override
    public void write(int c) {
        int newIndex = this.index + 1;
        if (newIndex > this.buffer.length) {
            int newBufferSize = Math.max(this.buffer.length << 1, newIndex);
            char[] newBuffer = new char[newBufferSize];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        this.buffer[this.index] = (char)c;
        this.index = newIndex;
    }

    @Override
    public void write(String string) {
        this.write(string, 0, string.length());
    }

    @Override
    public void write(String string, int offset, int length) {
        if (length <= 0) {
            return;
        }
        int newIndex = this.index + length;
        if (newIndex > this.buffer.length) {
            int newBufferSize = Math.max(this.buffer.length << 1, newIndex);
            char[] newBuffer = new char[newBufferSize];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.index);
            this.buffer = newBuffer;
        }
        string.getChars(offset, offset + length, this.buffer, this.index);
        this.index = newIndex;
    }

    public int writeTo(CharBuffer charBuffer) {
        int length = charBuffer.remaining();
        if (length > this.index) {
            length = this.index;
        }
        if (length == 0) {
            return 0;
        }
        charBuffer.put(this.buffer, 0, length);
        return length;
    }

    public int writeTo(OutputStream outputStream, String charsetName) throws IOException {
        ByteBuffer byteBuffer = CharsetEncoderUtil.encode((String)charsetName, (char[])this.buffer, (int)0, (int)this.index);
        int length = byteBuffer.limit();
        outputStream.write(byteBuffer.array(), 0, length);
        return length;
    }

    public int writeTo(Writer writer) throws IOException {
        writer.write(this.buffer, 0, this.index);
        return this.index;
    }
}

