/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import com.liferay.portal.kernel.concurrent.ConcurrentMapperHashMap;
import com.liferay.portal.kernel.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.portal.kernel.memory.FinalizeAction;
import com.liferay.portal.kernel.memory.FinalizeManager;
import java.lang.ref.Reference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentReferenceValueHashMap<K, V>
extends ConcurrentMapperHashMap<K, K, V, Reference<V>> {
    private final FinalizeManager.ReferenceFactory _referenceFactory;

    public ConcurrentReferenceValueHashMap(ConcurrentMap<K, Reference<V>> innerConcurrentMap, FinalizeManager.ReferenceFactory referenceFactory) {
        super(innerConcurrentMap);
        this._referenceFactory = referenceFactory;
    }

    public ConcurrentReferenceValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, FinalizeManager.ReferenceFactory referenceFactory) {
        this(new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel), referenceFactory);
    }

    public ConcurrentReferenceValueHashMap(int initialCapacity, FinalizeManager.ReferenceFactory referenceFactory) {
        this(new ConcurrentHashMap(initialCapacity), referenceFactory);
    }

    public ConcurrentReferenceValueHashMap(Map<? extends K, ? extends V> map, FinalizeManager.ReferenceFactory referenceFactory) {
        this(new ConcurrentHashMap(), referenceFactory);
        this.putAll(map);
    }

    public ConcurrentReferenceValueHashMap(FinalizeManager.ReferenceFactory referenceFactory) {
        this(new ConcurrentHashMap(), referenceFactory);
    }

    @Override
    protected K mapKey(K key) {
        return key;
    }

    @Override
    protected K mapKeyForQuery(K key) {
        return key;
    }

    @Override
    protected Reference<V> mapValue(K key, V value) {
        return FinalizeManager.register(value, (FinalizeAction)new RemoveEntryFinalizeAction(this, key), (FinalizeManager.ReferenceFactory)this._referenceFactory);
    }

    @Override
    protected Reference<V> mapValueForQuery(V value) {
        return this._referenceFactory.createReference(value, null);
    }

    @Override
    protected K unmapKey(K key) {
        return key;
    }

    @Override
    protected K unmapKeyForQuery(K key) {
        return key;
    }

    @Override
    protected V unmapValue(Reference<V> reference) {
        V value = reference.get();
        reference.clear();
        return value;
    }

    @Override
    protected V unmapValueForQuery(Reference<V> reference) {
        return reference.get();
    }
}

