/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.heap.dump;

import com.liferay.portal.kernel.process.EchoOutputProcessor;
import com.liferay.portal.kernel.util.HeapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.io.File;
import java.util.concurrent.Future;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class HeapDumpTask
extends Task {
    private File _file;
    private boolean _live;

    public void execute() throws BuildException {
        try {
            File dumpFile = this.getFile();
            Future<ObjectValuePair<Void, Void>> future = HeapUtil.heapDump(this._live, true, dumpFile.getCanonicalPath(), EchoOutputProcessor.INSTANCE);
            future.get();
            this.log("Successfully dumped heap at " + dumpFile.getCanonicalPath());
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public File getFile() {
        if (this._file == null) {
            return new File(System.getProperty("java.io.tmpdir"), "ant-process-" + HeapUtil.getProcessId() + "-heap-dump.bin");
        }
        return this._file;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public void setLive(boolean live) {
        this._live = live;
    }
}

