/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.bnd.social;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Packages;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.AnalyzerPlugin;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SocialAnalyzerPlugin
implements AnalyzerPlugin {
    private static final DocumentBuilderFactory _documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        Jar jar = analyzer.getJar();
        Resource resource = jar.getResource("META-INF/social/liferay-social.xml");
        if (resource == null) {
            return false;
        }
        Packages packages = analyzer.getReferred();
        Document document = this.readXMLResource(resource);
        NodeList nodeList = document.getElementsByTagName("activity-type");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String className = this.getActivityTypeClassName(node.getTextContent());
            if (className == null) continue;
            String packageName = this.getPackageName(className);
            Descriptors.PackageRef packageRef = analyzer.getPackageRef(packageName);
            packages.put(packageRef);
        }
        return false;
    }

    protected String getActivityTypeClassName(String activityType) {
        if (!activityType.startsWith("${")) {
            return null;
        }
        int index = activityType.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return activityType.substring(2, index);
    }

    protected String getPackageName(String className) {
        int index = className.lastIndexOf(46);
        return className.substring(0, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document readXMLResource(Resource resource) throws Exception {
        InputStream inputStream = resource.openInputStream();
        try {
            DocumentBuilder documentBuilder = _documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        finally {
            inputStream.close();
        }
    }
}

