/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.bnd.jsp;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Packages;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class JspAnalyzerPlugin
implements AnalyzerPlugin {
    private static final String[] _JSTL_CORE_URIS = new String[]{"http://java.sun.com/jsp/jstl/core", "http://java.sun.com/jsp/jstl/fmt", "http://java.sun.com/jsp/jstl/functions", "http://java.sun.com/jsp/jstl/sql", "http://java.sun.com/jsp/jstl/xml"};
    private static final String _LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String[] _REQUIRED_PACKAGE_NAMES = new String[]{"javax.servlet", "javax.servlet.http"};
    private static final Pattern _packagePattern = Pattern.compile("[_A-Za-z$][_A-Za-z0-9$]*(\\.[_A-Za-z$][_A-Za-z0-9$]*)*");
    private static final Pattern _tldPattern = Pattern.compile(".*\\.tld");
    private final SAXParserFactory _saxParserFactory = SAXParserFactory.newInstance();

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        this.addManifestPackageImports(analyzer);
        Parameters parameters = OSGiHeader.parseHeader((String)analyzer.getProperty("-jsp"));
        if (parameters.isEmpty()) {
            return false;
        }
        Instructions instructions = new Instructions(parameters);
        boolean matches = false;
        Jar jar = analyzer.getJar();
        Map resources = jar.getResources();
        HashSet keys = new HashSet(resources.keySet());
        block0: for (String key : keys) {
            for (Instruction instruction : instructions.keySet()) {
                if (!instruction.matches(key)) continue;
                if (instruction.isNegated()) continue block0;
                Resource resource = jar.getResource(key);
                String jsp = IO.collect((InputStream)resource.openInputStream(), (String)"UTF-8");
                this.addApiUses(analyzer, jsp);
                this.addTaglibRequirements(analyzer, jsp);
                matches = true;
            }
        }
        if (matches) {
            this.addRequiredPackageImports(analyzer, _REQUIRED_PACKAGE_NAMES);
        }
        return false;
    }

    protected void addApiUses(Analyzer analyzer, String content) {
        int contentX = -1;
        int contentY = content.length();
        while ((contentX = content.lastIndexOf("<%@", contentY)) != -1) {
            String contentFragment;
            int index;
            contentY = contentX;
            int importX = content.indexOf("import=\"", contentY);
            int importY = -1;
            if (importX != -1) {
                importY = content.indexOf("\"", importX += "import=\"".length());
            }
            if (importX != -1 && importY != -1 && (index = (contentFragment = content.substring(importX, importY)).lastIndexOf(46)) != -1) {
                Packages packages = analyzer.getReferred();
                String packageName = contentFragment.substring(0, index);
                Descriptors.PackageRef packageRef = analyzer.getPackageRef(packageName);
                packages.put(packageRef, new Attrs());
                this.addApiUses(analyzer, contentFragment, packageRef);
            }
            contentY -= 3;
        }
    }

    protected void addApiUses(Analyzer analyzer, String content, Descriptors.PackageRef packageRef) {
        for (Jar jar : analyzer.getClasspath()) {
            this.addJarApiUses(analyzer, content, packageRef, jar);
        }
    }

    protected void addJarApiUses(Analyzer analyzer, String content, Descriptors.PackageRef packageRef, Jar jar) {
        Map resourceMaps = jar.getDirectories();
        Map resourceMap = (Map)resourceMaps.get(packageRef.getPath());
        if (resourceMap == null || resourceMap.isEmpty()) {
            return;
        }
        if (content.endsWith("*")) {
            for (Map.Entry entry : resourceMap.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.endsWith(".class")) continue;
                this.addResourceApiUses(analyzer, key, (Resource)entry.getValue());
            }
        } else {
            String fqnToPath = Descriptors.fqnToPath((String)content);
            if (resourceMap.containsKey(fqnToPath)) {
                Resource resource = (Resource)resourceMap.get(fqnToPath);
                this.addResourceApiUses(analyzer, content, resource);
            }
        }
    }

    protected void addManifestPackageImports(Analyzer analyzer) {
        Packages packages = analyzer.getClasspathExports();
        for (Jar jar : analyzer.getClasspath()) {
            try {
                Manifest manifest = jar.getManifest();
                if (manifest == null) continue;
                Domain domain = Domain.domain((Manifest)manifest);
                Parameters parameters = domain.getExportPackage();
                for (Map.Entry entry : parameters.entrySet()) {
                    Descriptors.PackageRef packageRef = analyzer.getPackageRef((String)entry.getKey());
                    Attrs attrs = packages.get(packageRef);
                    if (!attrs.isEmpty()) continue;
                    packages.put(packageRef, (Attrs)entry.getValue());
                }
            }
            catch (Exception e) {
            }
        }
    }

    protected void addRequiredPackageImports(Analyzer analyzer, String[] packageNames) {
        Packages packages = analyzer.getReferred();
        for (String packageName : packageNames) {
            Descriptors.PackageRef packageRef = analyzer.getPackageRef(packageName);
            Matcher matcher = _packagePattern.matcher(packageRef.getFQN());
            if (!matcher.matches() || packages.containsKey(packageRef)) continue;
            packages.put(packageRef, new Attrs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResourceApiUses(Analyzer analyzer, String fqnToPath, Resource resource) {
        Clazz clazz = null;
        try {
            InputStream inputStream = resource.openInputStream();
            clazz = new Clazz(analyzer, fqnToPath, resource);
            try {
                clazz.parseClassFile();
            }
            finally {
                inputStream.close();
            }
        }
        catch (Throwable e) {
            return;
        }
        Set packageRefs = clazz.getAPIUses();
        for (Descriptors.PackageRef packageRef : packageRefs) {
            Packages packages = analyzer.getReferred();
            packages.put(packageRef, new Attrs());
        }
    }

    protected void addTaglibRequirement(Set<String> taglibRequirements, String uri) {
        Parameters parameters = new Parameters();
        Attrs attrs = new Attrs();
        attrs.put("filter:", "\"(&(osgi.extender=jsp.taglib)(uri=" + uri + "))\"");
        parameters.put("osgi.extender", attrs);
        taglibRequirements.add(parameters.toString());
    }

    protected void addTaglibRequirements(Analyzer analyzer, String content) {
        TreeSet<String> taglibRequirements = new TreeSet<String>();
        for (String uri : this.getTaglibURIs(content)) {
            if (this.containsTLD(analyzer, analyzer.getJar(), "META-INF", uri) || this.containsTLD(analyzer, analyzer.getJar(), "WEB-INF/tld", uri) || this.containsTLDInBundleClassPath(analyzer, "META-INF", uri) || Arrays.binarySearch(_JSTL_CORE_URIS, uri) >= 0) continue;
            this.addTaglibRequirement(taglibRequirements, uri);
        }
        if (taglibRequirements.isEmpty()) {
            return;
        }
        String value = analyzer.getProperty("Require-Capability");
        if (value != null) {
            Parameters parameters = OSGiHeader.parseHeader((String)value);
            for (Map.Entry entry : parameters.entrySet()) {
                StringBuilder sb = new StringBuilder((String)entry.getKey());
                Attrs attrs = (Attrs)entry.getValue();
                if (attrs != null) {
                    sb.append(";");
                    attrs.append(sb);
                }
                taglibRequirements.add(sb.toString());
            }
        }
        analyzer.setProperty("Require-Capability", Strings.join(taglibRequirements));
    }

    protected Set<String> getTaglibURIs(String originalContent) {
        String content = originalContent.replaceAll("<%--[\\s\\S]*?--%>", "");
        int contentX = -1;
        int contentY = content.length();
        HashSet<String> taglibURis = new HashSet<String>();
        while ((contentX = content.lastIndexOf("<%@", contentY)) != -1) {
            contentY = contentX;
            int importX = content.indexOf("uri=\"", contentY);
            int importY = -1;
            if (importX != -1) {
                importY = content.indexOf("\"", importX += "uri=\"".length());
            }
            if (importX != -1 && importY != -1) {
                String s = content.substring(importX, importY);
                taglibURis.add(s);
            }
            contentY -= 3;
        }
        return taglibURis;
    }

    protected boolean containsTLD(Analyzer analyzer, Jar jar, String root, String uri) {
        Map resourceMaps = jar.getDirectories();
        Map resourceMap = (Map)resourceMaps.get(root);
        if (resourceMap == null || resourceMap.isEmpty()) {
            Resource resource = jar.getResource(root);
            return resource != null && this.matchesURI(analyzer, root, resource, uri);
        }
        for (Map.Entry entry : resourceMap.entrySet()) {
            String path = (String)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            Matcher matcher = _tldPattern.matcher(path);
            if (!matcher.matches() || !this.matchesURI(analyzer, path, resource, uri)) continue;
            return true;
        }
        return false;
    }

    protected boolean containsTLDInBundleClassPath(Analyzer analyzer, String root, String uri) {
        Parameters parameters = new Parameters(analyzer.getProperty("Bundle-ClassPath"));
        if (parameters.isEmpty()) {
            return false;
        }
        Jar jar = analyzer.getJar();
        for (String entry : parameters.keySet()) {
            Resource resource;
            String entryLowerCase = entry.toLowerCase();
            if (!entryLowerCase.endsWith(".jar") && !entryLowerCase.endsWith(".zip") || (resource = jar.getResource(entry)) == null) continue;
            try {
                Jar classPathJar = new Jar(entry, resource.openInputStream());
                if (!this.containsTLD(analyzer, classPathJar, root, uri)) continue;
                return true;
            }
            catch (Exception e) {
            }
        }
        return false;
    }

    protected boolean matchesURI(Analyzer analyzer, String path, Resource resource, String uri) {
        try {
            URIFinder uriFinder = new URIFinder(uri);
            SAXParser saxParser = this._saxParserFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(uriFinder);
            xmlReader.setFeature(_LOAD_EXTERNAL_DTD, false);
            xmlReader.setEntityResolver(new NullEntityResolver());
            xmlReader.parse(new InputSource(resource.openInputStream()));
            return uriFinder.hasURI();
        }
        catch (Exception e) {
            analyzer.error("Unexpected exception in processing TLD " + path + ": " + e, new Object[0]);
            return false;
        }
    }

    private class URIFinder
    extends DefaultHandler {
        private boolean _hasURI;
        private boolean _inURI;
        private String _uri;

        public URIFinder(String uri) {
            this._uri = uri;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("uri")) {
                this._inURI = true;
            }
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            if (!this._inURI) {
                return;
            }
            String value = new String(chars, start, length);
            this._hasURI = this._uri.equals(value.replaceAll("^\\s*(.*)\\s*$", "$1"));
            this._inURI = false;
        }

        public boolean hasURI() {
            return this._hasURI;
        }
    }

    private class NullEntityResolver
    implements EntityResolver {
        private NullEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource();
        }
    }
}

