/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.bnd;

import aQute.bnd.differ.Baseline;
import aQute.bnd.differ.DiffPluginImpl;
import aQute.bnd.osgi.Jar;
import aQute.bnd.service.diff.Delta;
import aQute.bnd.service.diff.Diff;
import aQute.bnd.service.diff.Differ;
import aQute.bnd.version.Version;
import aQute.service.reporter.Reporter;
import com.liferay.ant.bnd.BaselineProcessor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.Set;

public abstract class Baseline {
    private boolean _forcePackageInfo;
    private boolean _headerPrinted;
    private File _logFile;
    private File _newJarFile;
    private File _oldJarFile;
    private PrintWriter _printWriter;
    private final Properties _properties = new Properties();
    private boolean _reportDiff;
    private boolean _reportOnlyDirtyPackages;
    private File _sourceDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws Exception {
        boolean match = true;
        this._headerPrinted = false;
        this._printWriter = null;
        if (this._logFile.exists()) {
            this._logFile.delete();
        }
        File logDir = this._logFile.getParentFile();
        logDir.mkdirs();
        BaselineProcessor baselineProcessor = new BaselineProcessor();
        baselineProcessor.setProperties(this._properties);
        Jar newJar = new Jar(this._newJarFile);
        Jar oldJar = null;
        if (this._oldJarFile != null) {
            if (!this._oldJarFile.exists() || this._oldJarFile.isDirectory() || !this._oldJarFile.canRead()) {
                baselineProcessor.warning("Baseline file %s is invalid. Check if it exists, is readable, and is not a directory.", new Object[]{this._oldJarFile});
            } else {
                oldJar = new Jar(this._oldJarFile);
            }
        } else {
            oldJar = baselineProcessor.getBaselineJar();
        }
        try {
            if (oldJar == null) {
                boolean bl = match;
                return bl;
            }
            aQute.bnd.differ.Baseline baseline = new aQute.bnd.differ.Baseline((Reporter)baselineProcessor, (Differ)new DiffPluginImpl());
            Set infos = baseline.baseline(newJar, oldJar, null);
            if (infos.isEmpty()) {
                boolean bl = match;
                return bl;
            }
            Baseline.BundleInfo bundleInfo = baseline.getBundleInfo();
            if (bundleInfo.mismatch) {
                match = false;
            }
            Baseline.Info[] infosArray = infos.toArray(new Baseline.Info[infos.size()]);
            Arrays.sort(infosArray, new Comparator<Baseline.Info>(){

                @Override
                public int compare(Baseline.Info info1, Baseline.Info info2) {
                    return info1.packageName.compareTo(info2.packageName);
                }
            });
            this.doHeader(bundleInfo);
            for (Baseline.Info info : infosArray) {
                Diff packageDiff;
                Delta delta;
                if (info.mismatch) {
                    match = false;
                }
                String warnings = "-";
                Version newerVersion = info.newerVersion;
                Version suggestedVersion = info.suggestedVersion;
                if (suggestedVersion != null) {
                    if (newerVersion.compareTo(suggestedVersion) > 0) {
                        warnings = "EXCESSIVE VERSION INCREASE";
                    } else if (newerVersion.compareTo(suggestedVersion) < 0) {
                        warnings = "VERSION INCREASE REQUIRED";
                    }
                }
                if ((delta = (packageDiff = info.packageDiff).getDelta()) == Delta.REMOVED) {
                    warnings = "PACKAGE REMOVED";
                } else if (delta == Delta.UNCHANGED) {
                    boolean newVersionSuggested = false;
                    if (suggestedVersion.compareTo(newerVersion) > 0) {
                        warnings = "VERSION INCREASE SUGGESTED";
                        newVersionSuggested = true;
                    } else if (suggestedVersion.compareTo(newerVersion) < 0) {
                        warnings = "EXCESSIVE VERSION INCREASE";
                        newVersionSuggested = true;
                    }
                    if (!newVersionSuggested && !info.mismatch) continue;
                }
                this.generatePackageInfo(info, delta, warnings);
                if ((!this._reportDiff || this._reportOnlyDirtyPackages) && warnings.equals("-") || this._reportOnlyDirtyPackages && delta == Delta.REMOVED) continue;
                this.doInfo(bundleInfo, info, warnings);
                if (!this._reportDiff || delta == Delta.REMOVED) continue;
                this.doPackageDiff(packageDiff);
            }
        }
        finally {
            this.log((Reporter)baselineProcessor);
            baselineProcessor.close();
            newJar.close();
            if (oldJar != null) {
                oldJar.close();
            }
            if (this._printWriter != null) {
                this._printWriter.close();
            }
        }
        return match;
    }

    public Properties getProperties() {
        return this._properties;
    }

    public void setForcePackageInfo(boolean forcePackageInfo) {
        this._forcePackageInfo = forcePackageInfo;
    }

    public void setLogFile(File logFile) {
        this._logFile = logFile;
    }

    public void setNewJarFile(File newJarFile) {
        this._newJarFile = newJarFile;
    }

    public void setOldJarFile(File oldJarFile) {
        this._oldJarFile = oldJarFile;
    }

    public void setReportDiff(boolean reportDiff) {
        this._reportDiff = reportDiff;
    }

    public void setReportOnlyDirtyPackages(boolean reportOnlyDirtyPackages) {
        this._reportOnlyDirtyPackages = reportOnlyDirtyPackages;
    }

    public void setSourceDir(File sourceDir) {
        this._sourceDir = sourceDir;
    }

    protected void doDiff(Diff diff, StringBuilder sb) {
        String type = String.valueOf(diff.getType());
        String output = String.format("%s%-3s %-10s %s", sb, this.getShortDelta(diff.getDelta()), type.toLowerCase(), diff.getName());
        this.log(output);
        if (this._printWriter != null) {
            this._printWriter.println(output);
        }
        sb.append("\t");
        for (Diff curDiff : diff.getChildren()) {
            if (curDiff.getDelta() == Delta.UNCHANGED) continue;
            this.doDiff(curDiff, sb);
        }
        sb.deleteCharAt(sb.length() - 1);
    }

    protected void doHeader(Baseline.BundleInfo bundleInfo) throws IOException {
        if (!bundleInfo.mismatch) {
            return;
        }
        String output = "[Baseline Report] Mode: ";
        output = this._reportDiff ? output + "diff" : output + "standard";
        if (this._logFile != null) {
            output = output + " (persisted)";
        }
        this.log(output);
        output = "[Baseline Warning] Bundle Version Change Recommended: " + bundleInfo.suggestedVersion;
        this.log(output);
        this.persistLog(output);
    }

    protected void doInfo(Baseline.BundleInfo bundleInfo, Baseline.Info info, String warnings) throws IOException {
        this.doPackagesHeader(bundleInfo);
        this.reportLog(String.valueOf(info.mismatch ? (char)'*' : ' '), info.packageName, String.valueOf(info.packageDiff.getDelta()), String.valueOf(info.newerVersion), String.valueOf(info.olderVersion), String.valueOf(info.suggestedVersion == null ? "-" : info.suggestedVersion), warnings, String.valueOf(info.attributes));
    }

    protected void doPackageDiff(Diff diff) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t");
        for (Diff curDiff : diff.getChildren()) {
            if (curDiff.getDelta() == Delta.UNCHANGED) continue;
            this.doDiff(curDiff, sb);
        }
    }

    protected void doPackagesHeader(Baseline.BundleInfo bundleInfo) throws IOException {
        if (this._headerPrinted) {
            return;
        }
        this._headerPrinted = true;
        this.reportLog(" ", "PACKAGE_NAME", "DELTA", "CUR_VER", "BASE_VER", "REC_VER", "WARNINGS", "ATTRIBUTES");
        this.reportLog("=", "==================================================", "==========", "==========", "==========", "==========", "==========", "==========");
    }

    protected void generatePackageInfo(Baseline.Info info, Delta delta, String warnings) throws Exception {
        File packageDir = new File(this._sourceDir, info.packageName.replace('.', File.separatorChar));
        if (!this._forcePackageInfo && !packageDir.exists()) {
            return;
        }
        packageDir.mkdirs();
        File packageInfoFile = new File(packageDir, "packageinfo");
        if (delta == Delta.REMOVED) {
            if (packageInfoFile.exists()) {
                packageInfoFile.delete();
            }
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(packageInfoFile);
        String content = "version " + info.suggestedVersion;
        fileOutputStream.write(content.getBytes());
        fileOutputStream.close();
    }

    protected String getShortDelta(Delta delta) {
        if (delta == Delta.ADDED) {
            return "+";
        }
        if (delta == Delta.CHANGED) {
            return "~";
        }
        if (delta == Delta.MAJOR) {
            return ">";
        }
        if (delta == Delta.MICRO) {
            return "0xB5";
        }
        if (delta == Delta.MINOR) {
            return "<";
        }
        if (delta == Delta.REMOVED) {
            return "-";
        }
        String deltaString = delta.toString();
        return String.valueOf(deltaString.charAt(0));
    }

    protected abstract void log(Reporter var1);

    protected abstract void log(String var1);

    protected void persistLog(String output) throws IOException {
        if (this._logFile == null) {
            return;
        }
        if (this._printWriter == null) {
            this._logFile.createNewFile();
            this._printWriter = new PrintWriter(this._logFile);
        }
        this._printWriter.println(output);
    }

    protected void reportLog(String string1, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws IOException {
        String output = String.format("%s %-50s %-10s %-10s %-10s %-10s %-10s", string1, string2, string3, string4, string5, string6, string7);
        this.log(output);
        this.persistLog(output);
    }
}

