/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.client.pagination;

import com.liferay.analytics.settings.rest.internal.client.pagination.Pagination;
import java.util.ArrayList;
import java.util.Collection;

public class Page<T> {
    private final Collection<T> _items;
    private final long _page;
    private final long _pageSize;
    private final long _totalCount;

    public static <T> Page<T> of(Collection<T> items) {
        return new Page<T>(items);
    }

    public static <T> Page<T> of(Collection<T> items, Pagination pagination, long totalCount) {
        return new Page<T>(items, pagination, totalCount);
    }

    public Collection<T> getItems() {
        return new ArrayList<T>(this._items);
    }

    public long getLastPage() {
        if (this._pageSize == 0L || this._totalCount == 0L) {
            return 1L;
        }
        return -Math.floorDiv(-this._totalCount, this._pageSize);
    }

    public long getPage() {
        return this._page;
    }

    public long getPageSize() {
        return this._pageSize;
    }

    public long getTotalCount() {
        return this._totalCount;
    }

    public boolean hasNext() {
        return this.getLastPage() > this._page;
    }

    public boolean hasPrevious() {
        return this._page > 1L;
    }

    private Page(Collection<T> items) {
        this._items = items;
        this._page = 1L;
        this._pageSize = items.size();
        this._totalCount = items.size();
    }

    private Page(Collection<T> items, Pagination pagination, long totalCount) {
        this._items = items;
        if (pagination == null) {
            this._page = 0L;
            this._pageSize = 0L;
        } else {
            this._page = pagination.getPage();
            this._pageSize = pagination.getPageSize();
        }
        this._totalCount = totalCount;
    }
}

