/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.reports.blogs.internal.info.item;

import com.liferay.analytics.reports.info.item.AnalyticsReportsInfoItem;
import com.liferay.analytics.reports.layout.display.page.info.item.LayoutDisplayPageObjectProviderAnalyticsReportsInfoItem;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.type.WebImage;
import com.liferay.layout.display.page.LayoutDisplayPageObjectProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProviderTracker;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserModel;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AnalyticsReportsInfoItem.class})
public class BlogsEntryAnalyticsReportsInfoItem
implements AnalyticsReportsInfoItem<BlogsEntry> {
    @Reference
    private BlogsEntryLocalService _blogsEntryLocalService;
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    @Reference
    private LayoutDisplayPageObjectProviderAnalyticsReportsInfoItem _layoutDisplayPageObjectProviderAnalyticsReportsInfoItem;
    @Reference
    private LayoutDisplayPageProviderTracker _layoutDisplayPageProviderTracker;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public String getAuthorName(BlogsEntry blogsEntry) {
        return Optional.ofNullable(this._userLocalService.fetchUser(blogsEntry.getUserId())).map(User::getFullName).orElse("");
    }

    public long getAuthorUserId(BlogsEntry blogsEntry) {
        return Optional.ofNullable(this._userLocalService.fetchUser(blogsEntry.getUserId())).map(UserModel::getUserId).orElse(0L);
    }

    public WebImage getAuthorWebImage(BlogsEntry blogsEntry, Locale locale) {
        InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemFieldValuesProvider.class, BlogsEntry.class.getName());
        InfoItemFieldValues infoItemFieldValues = infoItemFieldValuesProvider.getInfoItemFieldValues((Object)blogsEntry);
        InfoFieldValue authorProfileImageInfoFieldValue = infoItemFieldValues.getInfoFieldValue("authorProfileImage");
        return (WebImage)authorProfileImageInfoFieldValue.getValue(locale);
    }

    public List<Locale> getAvailableLocales(BlogsEntry blogsEntry) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.getAvailableLocales(this._getLayoutDisplayPageObjectProvider(blogsEntry));
    }

    public String getCanonicalURL(BlogsEntry blogsEntry, Locale locale) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.getCanonicalURL(this._getLayoutDisplayPageObjectProvider(blogsEntry), locale);
    }

    public Locale getDefaultLocale(BlogsEntry blogsEntry) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.getDefaultLocale(this._getLayoutDisplayPageObjectProvider(blogsEntry));
    }

    public Date getPublishDate(BlogsEntry blogsEntry) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.getPublishDate(this._getLayoutDisplayPageObjectProvider(blogsEntry));
    }

    public String getTitle(BlogsEntry blogsEntry, Locale locale) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.getTitle(this._getLayoutDisplayPageObjectProvider(blogsEntry), locale);
    }

    public boolean isShow(BlogsEntry blogsEntry) {
        return this._layoutDisplayPageObjectProviderAnalyticsReportsInfoItem.isShow(this._getLayoutDisplayPageObjectProvider(blogsEntry));
    }

    private LayoutDisplayPageObjectProvider<BlogsEntry> _getLayoutDisplayPageObjectProvider(BlogsEntry blogsEntry) {
        LayoutDisplayPageProvider layoutDisplayPageProvider = this._layoutDisplayPageProviderTracker.getLayoutDisplayPageProviderByClassName(BlogsEntry.class.getName());
        if (layoutDisplayPageProvider == null) {
            return null;
        }
        return layoutDisplayPageProvider.getLayoutDisplayPageObjectProvider(new InfoItemReference(BlogsEntry.class.getName(), blogsEntry.getEntryId()));
    }
}

