/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.message.storage.service.persistence.impl;

import com.liferay.analytics.message.storage.exception.NoSuchMessageException;
import com.liferay.analytics.message.storage.model.AnalyticsMessage;
import com.liferay.analytics.message.storage.model.AnalyticsMessageTable;
import com.liferay.analytics.message.storage.model.impl.AnalyticsMessageImpl;
import com.liferay.analytics.message.storage.model.impl.AnalyticsMessageModelImpl;
import com.liferay.analytics.message.storage.service.persistence.AnalyticsMessagePersistence;
import com.liferay.analytics.message.storage.service.persistence.AnalyticsMessageUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={AnalyticsMessagePersistence.class})
public class AnalyticsMessagePersistenceImpl
extends BasePersistenceImpl<AnalyticsMessage>
implements AnalyticsMessagePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AnalyticsMessageImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "analyticsMessage.companyId = ?";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_ANALYTICSMESSAGE = "SELECT analyticsMessage FROM AnalyticsMessage analyticsMessage";
    private static final String _SQL_SELECT_ANALYTICSMESSAGE_WHERE = "SELECT analyticsMessage FROM AnalyticsMessage analyticsMessage WHERE ";
    private static final String _SQL_COUNT_ANALYTICSMESSAGE = "SELECT COUNT(analyticsMessage) FROM AnalyticsMessage analyticsMessage";
    private static final String _SQL_COUNT_ANALYTICSMESSAGE_WHERE = "SELECT COUNT(analyticsMessage) FROM AnalyticsMessage analyticsMessage WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "analyticsMessage.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No AnalyticsMessage exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No AnalyticsMessage exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(AnalyticsMessagePersistenceImpl.class);

    public List<AnalyticsMessage> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<AnalyticsMessage> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<AnalyticsMessage> findByCompanyId(long companyId, int start, int end, OrderByComparator<AnalyticsMessage> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<AnalyticsMessage> findByCompanyId(long companyId, int start, int end, OrderByComparator<AnalyticsMessage> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (AnalyticsMessage analyticsMessage : list) {
                if (companyId == analyticsMessage.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_ANALYTICSMESSAGE_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY analyticsMessage.analyticsMessageId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public AnalyticsMessage findByCompanyId_First(long companyId, OrderByComparator<AnalyticsMessage> orderByComparator) throws NoSuchMessageException {
        AnalyticsMessage analyticsMessage = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (analyticsMessage != null) {
            return analyticsMessage;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchMessageException(sb.toString());
    }

    public AnalyticsMessage fetchByCompanyId_First(long companyId, OrderByComparator<AnalyticsMessage> orderByComparator) {
        List<AnalyticsMessage> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AnalyticsMessage findByCompanyId_Last(long companyId, OrderByComparator<AnalyticsMessage> orderByComparator) throws NoSuchMessageException {
        AnalyticsMessage analyticsMessage = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (analyticsMessage != null) {
            return analyticsMessage;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchMessageException(sb.toString());
    }

    public AnalyticsMessage fetchByCompanyId_Last(long companyId, OrderByComparator<AnalyticsMessage> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<AnalyticsMessage> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AnalyticsMessage[] findByCompanyId_PrevAndNext(long analyticsMessageId, long companyId, OrderByComparator<AnalyticsMessage> orderByComparator) throws NoSuchMessageException {
        AnalyticsMessage analyticsMessage = this.findByPrimaryKey(analyticsMessageId);
        Session session = null;
        try {
            session = this.openSession();
            AnalyticsMessage[] array = new AnalyticsMessageImpl[]{this.getByCompanyId_PrevAndNext(session, analyticsMessage, companyId, orderByComparator, true), analyticsMessage, this.getByCompanyId_PrevAndNext(session, analyticsMessage, companyId, orderByComparator, false)};
            AnalyticsMessage[] analyticsMessageArray = array;
            return analyticsMessageArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AnalyticsMessage getByCompanyId_PrevAndNext(Session session, AnalyticsMessage analyticsMessage, long companyId, OrderByComparator<AnalyticsMessage> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_ANALYTICSMESSAGE_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY analyticsMessage.analyticsMessageId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)analyticsMessage)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (AnalyticsMessage)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (AnalyticsMessage analyticsMessage : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)analyticsMessage);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_ANALYTICSMESSAGE_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public AnalyticsMessagePersistenceImpl() {
        this.setModelClass(AnalyticsMessage.class);
        this.setModelImplClass(AnalyticsMessageImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)AnalyticsMessageTable.INSTANCE);
    }

    public void cacheResult(AnalyticsMessage analyticsMessage) {
        this.entityCache.putResult(AnalyticsMessageImpl.class, (Serializable)Long.valueOf(analyticsMessage.getPrimaryKey()), (Serializable)analyticsMessage);
    }

    public void cacheResult(List<AnalyticsMessage> analyticsMessages) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && analyticsMessages.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (AnalyticsMessage analyticsMessage : analyticsMessages) {
            if (this.entityCache.getResult(AnalyticsMessageImpl.class, (Serializable)Long.valueOf(analyticsMessage.getPrimaryKey())) != null) continue;
            this.cacheResult(analyticsMessage);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(AnalyticsMessageImpl.class);
        this.finderCache.clearCache(AnalyticsMessageImpl.class);
    }

    public void clearCache(AnalyticsMessage analyticsMessage) {
        this.entityCache.removeResult(AnalyticsMessageImpl.class, (BaseModel)analyticsMessage);
    }

    public void clearCache(List<AnalyticsMessage> analyticsMessages) {
        for (AnalyticsMessage analyticsMessage : analyticsMessages) {
            this.entityCache.removeResult(AnalyticsMessageImpl.class, (BaseModel)analyticsMessage);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(AnalyticsMessageImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(AnalyticsMessageImpl.class, primaryKey);
        }
    }

    public AnalyticsMessage create(long analyticsMessageId) {
        AnalyticsMessageImpl analyticsMessage = new AnalyticsMessageImpl();
        analyticsMessage.setNew(true);
        analyticsMessage.setPrimaryKey(analyticsMessageId);
        analyticsMessage.setCompanyId(CompanyThreadLocal.getCompanyId());
        return analyticsMessage;
    }

    public AnalyticsMessage remove(long analyticsMessageId) throws NoSuchMessageException {
        return this.remove(Long.valueOf(analyticsMessageId));
    }

    public AnalyticsMessage remove(Serializable primaryKey) throws NoSuchMessageException {
        Session session = null;
        try {
            session = this.openSession();
            AnalyticsMessage analyticsMessage = (AnalyticsMessage)session.get(AnalyticsMessageImpl.class, primaryKey);
            if (analyticsMessage == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchMessageException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            AnalyticsMessage analyticsMessage2 = (AnalyticsMessage)this.remove((BaseModel)analyticsMessage);
            return analyticsMessage2;
        }
        catch (NoSuchMessageException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AnalyticsMessage removeImpl(AnalyticsMessage analyticsMessage) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)analyticsMessage)) {
                analyticsMessage = (AnalyticsMessage)session.get(AnalyticsMessageImpl.class, analyticsMessage.getPrimaryKeyObj());
            }
            if (analyticsMessage != null) {
                session.delete((Object)analyticsMessage);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (analyticsMessage != null) {
            this.clearCache(analyticsMessage);
        }
        return analyticsMessage;
    }

    public AnalyticsMessage updateImpl(AnalyticsMessage analyticsMessage) {
        boolean isNew = analyticsMessage.isNew();
        if (!(analyticsMessage instanceof AnalyticsMessageModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(analyticsMessage.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)analyticsMessage);
                throw new IllegalArgumentException("Implement ModelWrapper in analyticsMessage proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom AnalyticsMessage implementation " + analyticsMessage.getClass());
        }
        AnalyticsMessageModelImpl analyticsMessageModelImpl = (AnalyticsMessageModelImpl)analyticsMessage;
        if (isNew && analyticsMessage.getCreateDate() == null) {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            Date date = new Date();
            if (serviceContext == null) {
                analyticsMessage.setCreateDate(date);
            } else {
                analyticsMessage.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)analyticsMessage);
            } else {
                session.evict(AnalyticsMessageImpl.class, analyticsMessage.getPrimaryKeyObj());
                session.saveOrUpdate((Object)analyticsMessage);
            }
            session.flush();
            session.clear();
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(AnalyticsMessageImpl.class, (BaseModel)analyticsMessageModelImpl, false, true);
        if (isNew) {
            analyticsMessage.setNew(false);
        }
        analyticsMessage.resetOriginalValues();
        return analyticsMessage;
    }

    public AnalyticsMessage findByPrimaryKey(Serializable primaryKey) throws NoSuchMessageException {
        AnalyticsMessage analyticsMessage = (AnalyticsMessage)this.fetchByPrimaryKey(primaryKey);
        if (analyticsMessage == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchMessageException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return analyticsMessage;
    }

    public AnalyticsMessage findByPrimaryKey(long analyticsMessageId) throws NoSuchMessageException {
        return this.findByPrimaryKey(Long.valueOf(analyticsMessageId));
    }

    public AnalyticsMessage fetchByPrimaryKey(long analyticsMessageId) {
        return (AnalyticsMessage)this.fetchByPrimaryKey(Long.valueOf(analyticsMessageId));
    }

    public List<AnalyticsMessage> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<AnalyticsMessage> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<AnalyticsMessage> findAll(int start, int end, OrderByComparator<AnalyticsMessage> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<AnalyticsMessage> findAll(int start, int end, OrderByComparator<AnalyticsMessage> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_ANALYTICSMESSAGE);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_ANALYTICSMESSAGE;
                sql = sql.concat(" ORDER BY analyticsMessage.analyticsMessageId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (AnalyticsMessage analyticsMessage : this.findAll()) {
            this.remove((BaseModel)analyticsMessage);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_ANALYTICSMESSAGE);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "analyticsMessageId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_ANALYTICSMESSAGE;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return AnalyticsMessageModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._setAnalyticsMessageUtilPersistence(this);
    }

    @Deactivate
    public void deactivate() {
        this._setAnalyticsMessageUtilPersistence(null);
        this.entityCache.removeCache(AnalyticsMessageImpl.class.getName());
    }

    private void _setAnalyticsMessageUtilPersistence(AnalyticsMessagePersistence analyticsMessagePersistence) {
        try {
            Field field = AnalyticsMessageUtil.class.getDeclaredField("_persistence");
            field.setAccessible(true);
            field.set(null, analyticsMessagePersistence);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.analytics.message.storage.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.analytics.message.storage.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.analytics.message.storage.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

