/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.message.storage.service.persistence.impl;

import com.liferay.analytics.message.storage.exception.NoSuchAssociationException;
import com.liferay.analytics.message.storage.model.AnalyticsAssociation;
import com.liferay.analytics.message.storage.model.AnalyticsAssociationTable;
import com.liferay.analytics.message.storage.model.impl.AnalyticsAssociationImpl;
import com.liferay.analytics.message.storage.model.impl.AnalyticsAssociationModelImpl;
import com.liferay.analytics.message.storage.service.persistence.AnalyticsAssociationPersistence;
import com.liferay.analytics.message.storage.service.persistence.AnalyticsAssociationUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={AnalyticsAssociationPersistence.class})
public class AnalyticsAssociationPersistenceImpl
extends BasePersistenceImpl<AnalyticsAssociation>
implements AnalyticsAssociationPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AnalyticsAssociationImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByC_A;
    private FinderPath _finderPathWithoutPaginationFindByC_A;
    private FinderPath _finderPathCountByC_A;
    private static final String _FINDER_COLUMN_C_A_COMPANYID_2 = "analyticsAssociation.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_A_ASSOCIATIONCLASSNAME_2 = "analyticsAssociation.associationClassName = ?";
    private static final String _FINDER_COLUMN_C_A_ASSOCIATIONCLASSNAME_3 = "(analyticsAssociation.associationClassName IS NULL OR analyticsAssociation.associationClassName = '')";
    private FinderPath _finderPathWithPaginationFindByC_GtM_A;
    private FinderPath _finderPathWithPaginationCountByC_GtM_A;
    private static final String _FINDER_COLUMN_C_GTM_A_COMPANYID_2 = "analyticsAssociation.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_GTM_A_MODIFIEDDATE_1 = "analyticsAssociation.modifiedDate IS NULL AND ";
    private static final String _FINDER_COLUMN_C_GTM_A_MODIFIEDDATE_2 = "analyticsAssociation.modifiedDate > ? AND ";
    private static final String _FINDER_COLUMN_C_GTM_A_ASSOCIATIONCLASSNAME_2 = "analyticsAssociation.associationClassName = ?";
    private static final String _FINDER_COLUMN_C_GTM_A_ASSOCIATIONCLASSNAME_3 = "(analyticsAssociation.associationClassName IS NULL OR analyticsAssociation.associationClassName = '')";
    private FinderPath _finderPathWithPaginationFindByC_A_A;
    private FinderPath _finderPathWithoutPaginationFindByC_A_A;
    private FinderPath _finderPathCountByC_A_A;
    private static final String _FINDER_COLUMN_C_A_A_COMPANYID_2 = "analyticsAssociation.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_A_A_ASSOCIATIONCLASSNAME_2 = "analyticsAssociation.associationClassName = ? AND ";
    private static final String _FINDER_COLUMN_C_A_A_ASSOCIATIONCLASSNAME_3 = "(analyticsAssociation.associationClassName IS NULL OR analyticsAssociation.associationClassName = '') AND ";
    private static final String _FINDER_COLUMN_C_A_A_ASSOCIATIONCLASSPK_2 = "analyticsAssociation.associationClassPK = ?";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_ANALYTICSASSOCIATION = "SELECT analyticsAssociation FROM AnalyticsAssociation analyticsAssociation";
    private static final String _SQL_SELECT_ANALYTICSASSOCIATION_WHERE = "SELECT analyticsAssociation FROM AnalyticsAssociation analyticsAssociation WHERE ";
    private static final String _SQL_COUNT_ANALYTICSASSOCIATION = "SELECT COUNT(analyticsAssociation) FROM AnalyticsAssociation analyticsAssociation";
    private static final String _SQL_COUNT_ANALYTICSASSOCIATION_WHERE = "SELECT COUNT(analyticsAssociation) FROM AnalyticsAssociation analyticsAssociation WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "analyticsAssociation.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No AnalyticsAssociation exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No AnalyticsAssociation exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(AnalyticsAssociationPersistenceImpl.class);

    public List<AnalyticsAssociation> findByC_A(long companyId, String associationClassName) {
        return this.findByC_A(companyId, associationClassName, -1, -1, null);
    }

    public List<AnalyticsAssociation> findByC_A(long companyId, String associationClassName, int start, int end) {
        return this.findByC_A(companyId, associationClassName, start, end, null);
    }

    public List<AnalyticsAssociation> findByC_A(long companyId, String associationClassName, int start, int end, OrderByComparator<AnalyticsAssociation> orderByComparator) {
        return this.findByC_A(companyId, associationClassName, start, end, orderByComparator, true);
    }

    public List<AnalyticsAssociation> findByC_A(long companyId, String associationClassName, int start, int end, OrderByComparator<AnalyticsAssociation> orderByComparator, boolean useFinderCache) {
        associationClassName = Objects.toString(associationClassName, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_A;
                finderArgs = new Object[]{companyId, associationClassName};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_A;
            finderArgs = new Object[]{companyId, associationClassName, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (AnalyticsAssociation analyticsAssociation : list) {
                if (companyId == analyticsAssociation.getCompanyId() && associationClassName.equals(analyticsAssociation.getAssociationClassName())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_ANALYTICSASSOCIATION_WHERE);
            sb.append("analyticsAssociation.companyId = ? AND ");
            boolean bindAssociationClassName = false;
            if (associationClassName.isEmpty()) {
                sb.append("(analyticsAssociation.associationClassName IS NULL OR analyticsAssociation.associationClassName = '')");
            } else {
                bindAssociationClassName = true;
                sb.append("analyticsAssociation.associationClassName = ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY analyticsAssociation.analyticsAssociationId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindAssociationClassName) {
                    queryPos.add(associationClassName);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public AnalyticsAssociation findByC_A_First(long companyId, String associationClassName, OrderByComparator<AnalyticsAssociation> orderByComparator) throws NoSuchAssociationException {
        AnalyticsAssociation analyticsAssociation = this.fetchByC_A_First(companyId, associationClassName, orderByComparator);
        if (analyticsAssociation != null) {
            return analyticsAssociation;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", associationClassName=");
        sb.append(associationClassName);
        sb.append("}");
        throw new NoSuchAssociationException(sb.toString());
    }

    public AnalyticsAssociation fetchByC_A_First(long companyId, String associationClassName, OrderByComparator<AnalyticsAssociation> orderByComparator) {
        List<AnalyticsAssociation> list = this.findByC_A(companyId, associationClassName, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AnalyticsAssociation findByC_A_Last(long companyId, String associationClassName, OrderByComparator<AnalyticsAssociation> orderByComparator) throws NoSuchAssociationException {
        AnalyticsAssociation analyticsAssociation = this.fetchByC_A_Last(companyId, associationClassName, orderByComparator);
        if (analyticsAssociation != null) {
            return analyticsAssociation;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", associationClassName=");
        sb.append(associationClassName);
        sb.append("}");
        throw new NoSuchAssociationException(sb.toString());
    }

    public AnalyticsAssociation fetchByC_A_Last(long companyId, String associationClassName, OrderByComparator<AnalyticsAssociation> orderByComparator) {
        int count = this.countByC_A(companyId, associationClassName);
        if (count == 0) {
            return null;
        }
        List<AnalyticsAssociation> list = this.findByC_A(companyId, associationClassName, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AnalyticsAssociation[] findByC_A_PrevAndNext(long analyticsAssociationId, long companyId, String associationClassName, OrderByComparator<AnalyticsAssociation> orderByComparator) throws NoSuchAssociationException {
        associationClassName = Objects.toString(associationClassName, "");
        AnalyticsAssociation analyticsAssociation = this.findByPrimaryKey(analyticsAssociationId);
        Session session = null;
        try {
            session = this.openSession();
            AnalyticsAssociation[] array = new AnalyticsAssociationImpl[]{this.getByC_A_PrevAndNext(session, analyticsAssociation, companyId, associationClassName, orderByComparator, true), analyticsAssociation, this.getByC_A_PrevAndNext(session, analyticsAssociation, companyId, associationClassName, orderByComparator, false)};
            AnalyticsAssociation[] analyticsAssociationArray = array;
            return analyticsAssociationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AnalyticsAssociation getByC_A_PrevAndNext(Session session, AnalyticsAssociation analyticsAssociation, long companyId, String associationClassName, OrderByComparator<AnalyticsAssociation> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_ANALYTICSASSOCIATION_WHERE);
        sb.append("analyticsAssociation.companyId = ? AND ");
        boolean bindAssociationClassName = false;
        if (associationClassName.isEmpty()) {
            sb.append("(analyticsAssociation.associationClassName IS NULL OR analyticsAssociation.associationClassName = '')");
        } else {
            bindAssociationClassName = true;
            sb.append("analyticsAssociation.associationClassName = ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY analyticsAssociation.analyticsAssociationId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (bindAssociationClassName) {
            queryPos.add(associationClassName);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)analyticsAssociation)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (AnalyticsAssociation)list.get(1);
        }
        return null;
    }

    public void removeByC_A(long companyId, String associationClassName) {
        for (AnalyticsAssociation analyticsAssociation : this.findByC_A(companyId, associationClassName, -1, -1, null)) {
            this.remove((BaseModel)analyticsAssociation);
        }
    }

    public int countByC_A(long companyId, String associationClassName) {
        associationClassName = Objects.toString(associationClassName, "");
        FinderPath finderPath = this._finderPathCountByC_A;
        Object[] finderArgs = new Object[]{companyId, associationClassName};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_ANALYTICSASSOCIATION_WHERE);
            sb.append("analyticsAssociation.companyId = ? AND ");
            boolean bindAssociationClassName = false;
            if (associationClassName.isEmpty()) {
                sb.append("(analyticsAssociation.associationClassName IS NULL OR analyticsAssociation.associationClassName = '')");
            } else {
                bindAssociationClassName = true;
                sb.append("analyticsAssociation.associationClassName = ?");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindAssociationClassName) {
                    queryPos.add(associationClassName);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<AnalyticsAssociation> findByC_GtM_A(long companyId, Date modifiedDate, String associationClassName) {
        return this.findByC_GtM_A(companyId, modifiedDate, associationClassName, -1, -1, null);
    }

    public List<AnalyticsAssociation> findByC_GtM_A(long companyId, Date modifiedDate, String associationClassName, int start, int end) {
        return this.findByC_GtM_A(companyId, modifiedDate, associationClassName, start, end, null);
    }

    public List<AnalyticsAssociation> findByC_GtM_A(long companyId, Date modifiedDate, String associationClassName, int start, int end, OrderByComparator<AnalyticsAssociation> orderByComparator) {
        return this.findByC_GtM_A(companyId, modifiedDate, associationClassName, start, end, orderByComparator, true);
    }

    public List<AnalyticsAssociation> findByC_GtM_A(long companyId, Date modifiedDate, String associationClassName, int start, int end, OrderByComparator<AnalyticsAssociation> orderByComparator, boolean useFinderCache) {
        associationClassName = Objects.toString(associationClassName, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByC_GtM_A;
        finderArgs = new Object[]{companyId, AnalyticsAssociationPersistenceImpl._getTime(modifiedDate), associationClassName, start, end, orderByComparator};
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (AnalyticsAssociation analyticsAssociation : list) {
                if (companyId == analyticsAssociation.getCompanyId() && modifiedDate.getTime() < analyticsAssociation.getModifiedDate().getTime() && associationClassName.equals(analyticsAssociation.getAssociationClassName())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            sb.append(_SQL_SELECT_ANALYTICSASSOCIATION_WHERE);
            sb.append("analyticsAssociation.companyId = ? AND ");
            boolean bindModifiedDate = false;
            if (modifiedDate == null) {
                sb.append(_FINDER_COLUMN_C_GTM_A_MODIFIEDDATE_1);
            } else {
                bindModifiedDate = true;
                sb.append(_FINDER_COLUMN_C_GTM_A_MODIFIEDDATE_2);
            }
            boolean bindAssociationClassName = false;
            if (associationClassName.isEmpty()) {
                sb.append("(analyticsAssociation.associationClassName IS NULL OR analyticsAssociation.associationClassName = '')");
            } else {
                bindAssociationClassName = true;
                sb.append("analyticsAssociation.associationClassName = ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY analyticsAssociation.analyticsAssociationId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindModifiedDate) {
                    queryPos.add(new Timestamp(modifiedDate.getTime()));
                }
                if (bindAssociationClassName) {
                    queryPos.add(associationClassName);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public AnalyticsAssociation findByC_GtM_A_First(long companyId, Date modifiedDate, String associationClassName, OrderByComparator<AnalyticsAssociation> orderByComparator) throws NoSuchAssociationException {
        AnalyticsAssociation analyticsAssociation = this.fetchByC_GtM_A_First(companyId, modifiedDate, associationClassName, orderByComparator);
        if (analyticsAssociation != null) {
            return analyticsAssociation;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", modifiedDate>");
        sb.append((Object)modifiedDate);
        sb.append(", associationClassName=");
        sb.append(associationClassName);
        sb.append("}");
        throw new NoSuchAssociationException(sb.toString());
    }

    public AnalyticsAssociation fetchByC_GtM_A_First(long companyId, Date modifiedDate, String associationClassName, OrderByComparator<AnalyticsAssociation> orderByComparator) {
        List<AnalyticsAssociation> list = this.findByC_GtM_A(companyId, modifiedDate, associationClassName, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AnalyticsAssociation findByC_GtM_A_Last(long companyId, Date modifiedDate, String associationClassName, OrderByComparator<AnalyticsAssociation> orderByComparator) throws NoSuchAssociationException {
        AnalyticsAssociation analyticsAssociation = this.fetchByC_GtM_A_Last(companyId, modifiedDate, associationClassName, orderByComparator);
        if (analyticsAssociation != null) {
            return analyticsAssociation;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", modifiedDate>");
        sb.append((Object)modifiedDate);
        sb.append(", associationClassName=");
        sb.append(associationClassName);
        sb.append("}");
        throw new NoSuchAssociationException(sb.toString());
    }

    public AnalyticsAssociation fetchByC_GtM_A_Last(long companyId, Date modifiedDate, String associationClassName, OrderByComparator<AnalyticsAssociation> orderByComparator) {
        int count = this.countByC_GtM_A(companyId, modifiedDate, associationClassName);
        if (count == 0) {
            return null;
        }
        List<AnalyticsAssociation> list = this.findByC_GtM_A(companyId, modifiedDate, associationClassName, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AnalyticsAssociation[] findByC_GtM_A_PrevAndNext(long analyticsAssociationId, long companyId, Date modifiedDate, String associationClassName, OrderByComparator<AnalyticsAssociation> orderByComparator) throws NoSuchAssociationException {
        associationClassName = Objects.toString(associationClassName, "");
        AnalyticsAssociation analyticsAssociation = this.findByPrimaryKey(analyticsAssociationId);
        Session session = null;
        try {
            session = this.openSession();
            AnalyticsAssociation[] array = new AnalyticsAssociationImpl[]{this.getByC_GtM_A_PrevAndNext(session, analyticsAssociation, companyId, modifiedDate, associationClassName, orderByComparator, true), analyticsAssociation, this.getByC_GtM_A_PrevAndNext(session, analyticsAssociation, companyId, modifiedDate, associationClassName, orderByComparator, false)};
            AnalyticsAssociation[] analyticsAssociationArray = array;
            return analyticsAssociationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AnalyticsAssociation getByC_GtM_A_PrevAndNext(Session session, AnalyticsAssociation analyticsAssociation, long companyId, Date modifiedDate, String associationClassName, OrderByComparator<AnalyticsAssociation> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        sb.append(_SQL_SELECT_ANALYTICSASSOCIATION_WHERE);
        sb.append("analyticsAssociation.companyId = ? AND ");
        boolean bindModifiedDate = false;
        if (modifiedDate == null) {
            sb.append(_FINDER_COLUMN_C_GTM_A_MODIFIEDDATE_1);
        } else {
            bindModifiedDate = true;
            sb.append(_FINDER_COLUMN_C_GTM_A_MODIFIEDDATE_2);
        }
        boolean bindAssociationClassName = false;
        if (associationClassName.isEmpty()) {
            sb.append("(analyticsAssociation.associationClassName IS NULL OR analyticsAssociation.associationClassName = '')");
        } else {
            bindAssociationClassName = true;
            sb.append("analyticsAssociation.associationClassName = ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY analyticsAssociation.analyticsAssociationId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (bindModifiedDate) {
            queryPos.add(new Timestamp(modifiedDate.getTime()));
        }
        if (bindAssociationClassName) {
            queryPos.add(associationClassName);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)analyticsAssociation)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (AnalyticsAssociation)list.get(1);
        }
        return null;
    }

    public void removeByC_GtM_A(long companyId, Date modifiedDate, String associationClassName) {
        for (AnalyticsAssociation analyticsAssociation : this.findByC_GtM_A(companyId, modifiedDate, associationClassName, -1, -1, null)) {
            this.remove((BaseModel)analyticsAssociation);
        }
    }

    public int countByC_GtM_A(long companyId, Date modifiedDate, String associationClassName) {
        associationClassName = Objects.toString(associationClassName, "");
        FinderPath finderPath = this._finderPathWithPaginationCountByC_GtM_A;
        Object[] finderArgs = new Object[]{companyId, AnalyticsAssociationPersistenceImpl._getTime(modifiedDate), associationClassName};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_ANALYTICSASSOCIATION_WHERE);
            sb.append("analyticsAssociation.companyId = ? AND ");
            boolean bindModifiedDate = false;
            if (modifiedDate == null) {
                sb.append(_FINDER_COLUMN_C_GTM_A_MODIFIEDDATE_1);
            } else {
                bindModifiedDate = true;
                sb.append(_FINDER_COLUMN_C_GTM_A_MODIFIEDDATE_2);
            }
            boolean bindAssociationClassName = false;
            if (associationClassName.isEmpty()) {
                sb.append("(analyticsAssociation.associationClassName IS NULL OR analyticsAssociation.associationClassName = '')");
            } else {
                bindAssociationClassName = true;
                sb.append("analyticsAssociation.associationClassName = ?");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindModifiedDate) {
                    queryPos.add(new Timestamp(modifiedDate.getTime()));
                }
                if (bindAssociationClassName) {
                    queryPos.add(associationClassName);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<AnalyticsAssociation> findByC_A_A(long companyId, String associationClassName, long associationClassPK) {
        return this.findByC_A_A(companyId, associationClassName, associationClassPK, -1, -1, null);
    }

    public List<AnalyticsAssociation> findByC_A_A(long companyId, String associationClassName, long associationClassPK, int start, int end) {
        return this.findByC_A_A(companyId, associationClassName, associationClassPK, start, end, null);
    }

    public List<AnalyticsAssociation> findByC_A_A(long companyId, String associationClassName, long associationClassPK, int start, int end, OrderByComparator<AnalyticsAssociation> orderByComparator) {
        return this.findByC_A_A(companyId, associationClassName, associationClassPK, start, end, orderByComparator, true);
    }

    public List<AnalyticsAssociation> findByC_A_A(long companyId, String associationClassName, long associationClassPK, int start, int end, OrderByComparator<AnalyticsAssociation> orderByComparator, boolean useFinderCache) {
        associationClassName = Objects.toString(associationClassName, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_A_A;
                finderArgs = new Object[]{companyId, associationClassName, associationClassPK};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_A_A;
            finderArgs = new Object[]{companyId, associationClassName, associationClassPK, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (AnalyticsAssociation analyticsAssociation : list) {
                if (companyId == analyticsAssociation.getCompanyId() && associationClassName.equals(analyticsAssociation.getAssociationClassName()) && associationClassPK == analyticsAssociation.getAssociationClassPK()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            sb.append(_SQL_SELECT_ANALYTICSASSOCIATION_WHERE);
            sb.append("analyticsAssociation.companyId = ? AND ");
            boolean bindAssociationClassName = false;
            if (associationClassName.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_A_A_ASSOCIATIONCLASSNAME_3);
            } else {
                bindAssociationClassName = true;
                sb.append(_FINDER_COLUMN_C_A_A_ASSOCIATIONCLASSNAME_2);
            }
            sb.append(_FINDER_COLUMN_C_A_A_ASSOCIATIONCLASSPK_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY analyticsAssociation.analyticsAssociationId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindAssociationClassName) {
                    queryPos.add(associationClassName);
                }
                queryPos.add(associationClassPK);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public AnalyticsAssociation findByC_A_A_First(long companyId, String associationClassName, long associationClassPK, OrderByComparator<AnalyticsAssociation> orderByComparator) throws NoSuchAssociationException {
        AnalyticsAssociation analyticsAssociation = this.fetchByC_A_A_First(companyId, associationClassName, associationClassPK, orderByComparator);
        if (analyticsAssociation != null) {
            return analyticsAssociation;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", associationClassName=");
        sb.append(associationClassName);
        sb.append(", associationClassPK=");
        sb.append(associationClassPK);
        sb.append("}");
        throw new NoSuchAssociationException(sb.toString());
    }

    public AnalyticsAssociation fetchByC_A_A_First(long companyId, String associationClassName, long associationClassPK, OrderByComparator<AnalyticsAssociation> orderByComparator) {
        List<AnalyticsAssociation> list = this.findByC_A_A(companyId, associationClassName, associationClassPK, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AnalyticsAssociation findByC_A_A_Last(long companyId, String associationClassName, long associationClassPK, OrderByComparator<AnalyticsAssociation> orderByComparator) throws NoSuchAssociationException {
        AnalyticsAssociation analyticsAssociation = this.fetchByC_A_A_Last(companyId, associationClassName, associationClassPK, orderByComparator);
        if (analyticsAssociation != null) {
            return analyticsAssociation;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", associationClassName=");
        sb.append(associationClassName);
        sb.append(", associationClassPK=");
        sb.append(associationClassPK);
        sb.append("}");
        throw new NoSuchAssociationException(sb.toString());
    }

    public AnalyticsAssociation fetchByC_A_A_Last(long companyId, String associationClassName, long associationClassPK, OrderByComparator<AnalyticsAssociation> orderByComparator) {
        int count = this.countByC_A_A(companyId, associationClassName, associationClassPK);
        if (count == 0) {
            return null;
        }
        List<AnalyticsAssociation> list = this.findByC_A_A(companyId, associationClassName, associationClassPK, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AnalyticsAssociation[] findByC_A_A_PrevAndNext(long analyticsAssociationId, long companyId, String associationClassName, long associationClassPK, OrderByComparator<AnalyticsAssociation> orderByComparator) throws NoSuchAssociationException {
        associationClassName = Objects.toString(associationClassName, "");
        AnalyticsAssociation analyticsAssociation = this.findByPrimaryKey(analyticsAssociationId);
        Session session = null;
        try {
            session = this.openSession();
            AnalyticsAssociation[] array = new AnalyticsAssociationImpl[]{this.getByC_A_A_PrevAndNext(session, analyticsAssociation, companyId, associationClassName, associationClassPK, orderByComparator, true), analyticsAssociation, this.getByC_A_A_PrevAndNext(session, analyticsAssociation, companyId, associationClassName, associationClassPK, orderByComparator, false)};
            AnalyticsAssociation[] analyticsAssociationArray = array;
            return analyticsAssociationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AnalyticsAssociation getByC_A_A_PrevAndNext(Session session, AnalyticsAssociation analyticsAssociation, long companyId, String associationClassName, long associationClassPK, OrderByComparator<AnalyticsAssociation> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        sb.append(_SQL_SELECT_ANALYTICSASSOCIATION_WHERE);
        sb.append("analyticsAssociation.companyId = ? AND ");
        boolean bindAssociationClassName = false;
        if (associationClassName.isEmpty()) {
            sb.append(_FINDER_COLUMN_C_A_A_ASSOCIATIONCLASSNAME_3);
        } else {
            bindAssociationClassName = true;
            sb.append(_FINDER_COLUMN_C_A_A_ASSOCIATIONCLASSNAME_2);
        }
        sb.append(_FINDER_COLUMN_C_A_A_ASSOCIATIONCLASSPK_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY analyticsAssociation.analyticsAssociationId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (bindAssociationClassName) {
            queryPos.add(associationClassName);
        }
        queryPos.add(associationClassPK);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)analyticsAssociation)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (AnalyticsAssociation)list.get(1);
        }
        return null;
    }

    public void removeByC_A_A(long companyId, String associationClassName, long associationClassPK) {
        for (AnalyticsAssociation analyticsAssociation : this.findByC_A_A(companyId, associationClassName, associationClassPK, -1, -1, null)) {
            this.remove((BaseModel)analyticsAssociation);
        }
    }

    public int countByC_A_A(long companyId, String associationClassName, long associationClassPK) {
        associationClassName = Objects.toString(associationClassName, "");
        FinderPath finderPath = this._finderPathCountByC_A_A;
        Object[] finderArgs = new Object[]{companyId, associationClassName, associationClassPK};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_ANALYTICSASSOCIATION_WHERE);
            sb.append("analyticsAssociation.companyId = ? AND ");
            boolean bindAssociationClassName = false;
            if (associationClassName.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_A_A_ASSOCIATIONCLASSNAME_3);
            } else {
                bindAssociationClassName = true;
                sb.append(_FINDER_COLUMN_C_A_A_ASSOCIATIONCLASSNAME_2);
            }
            sb.append(_FINDER_COLUMN_C_A_A_ASSOCIATIONCLASSPK_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindAssociationClassName) {
                    queryPos.add(associationClassName);
                }
                queryPos.add(associationClassPK);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public AnalyticsAssociationPersistenceImpl() {
        this.setModelClass(AnalyticsAssociation.class);
        this.setModelImplClass(AnalyticsAssociationImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)AnalyticsAssociationTable.INSTANCE);
    }

    public void cacheResult(AnalyticsAssociation analyticsAssociation) {
        this.entityCache.putResult(AnalyticsAssociationImpl.class, (Serializable)Long.valueOf(analyticsAssociation.getPrimaryKey()), (Serializable)analyticsAssociation);
    }

    public void cacheResult(List<AnalyticsAssociation> analyticsAssociations) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && analyticsAssociations.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (AnalyticsAssociation analyticsAssociation : analyticsAssociations) {
            if (this.entityCache.getResult(AnalyticsAssociationImpl.class, (Serializable)Long.valueOf(analyticsAssociation.getPrimaryKey())) != null) continue;
            this.cacheResult(analyticsAssociation);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(AnalyticsAssociationImpl.class);
        this.finderCache.clearCache(AnalyticsAssociationImpl.class);
    }

    public void clearCache(AnalyticsAssociation analyticsAssociation) {
        this.entityCache.removeResult(AnalyticsAssociationImpl.class, (BaseModel)analyticsAssociation);
    }

    public void clearCache(List<AnalyticsAssociation> analyticsAssociations) {
        for (AnalyticsAssociation analyticsAssociation : analyticsAssociations) {
            this.entityCache.removeResult(AnalyticsAssociationImpl.class, (BaseModel)analyticsAssociation);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(AnalyticsAssociationImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(AnalyticsAssociationImpl.class, primaryKey);
        }
    }

    public AnalyticsAssociation create(long analyticsAssociationId) {
        AnalyticsAssociationImpl analyticsAssociation = new AnalyticsAssociationImpl();
        analyticsAssociation.setNew(true);
        analyticsAssociation.setPrimaryKey(analyticsAssociationId);
        analyticsAssociation.setCompanyId(CompanyThreadLocal.getCompanyId());
        return analyticsAssociation;
    }

    public AnalyticsAssociation remove(long analyticsAssociationId) throws NoSuchAssociationException {
        return this.remove(Long.valueOf(analyticsAssociationId));
    }

    public AnalyticsAssociation remove(Serializable primaryKey) throws NoSuchAssociationException {
        Session session = null;
        try {
            session = this.openSession();
            AnalyticsAssociation analyticsAssociation = (AnalyticsAssociation)session.get(AnalyticsAssociationImpl.class, primaryKey);
            if (analyticsAssociation == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchAssociationException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            AnalyticsAssociation analyticsAssociation2 = (AnalyticsAssociation)this.remove((BaseModel)analyticsAssociation);
            return analyticsAssociation2;
        }
        catch (NoSuchAssociationException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AnalyticsAssociation removeImpl(AnalyticsAssociation analyticsAssociation) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)analyticsAssociation)) {
                analyticsAssociation = (AnalyticsAssociation)session.get(AnalyticsAssociationImpl.class, analyticsAssociation.getPrimaryKeyObj());
            }
            if (analyticsAssociation != null) {
                session.delete((Object)analyticsAssociation);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (analyticsAssociation != null) {
            this.clearCache(analyticsAssociation);
        }
        return analyticsAssociation;
    }

    public AnalyticsAssociation updateImpl(AnalyticsAssociation analyticsAssociation) {
        boolean isNew = analyticsAssociation.isNew();
        if (!(analyticsAssociation instanceof AnalyticsAssociationModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(analyticsAssociation.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)analyticsAssociation);
                throw new IllegalArgumentException("Implement ModelWrapper in analyticsAssociation proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom AnalyticsAssociation implementation " + analyticsAssociation.getClass());
        }
        AnalyticsAssociationModelImpl analyticsAssociationModelImpl = (AnalyticsAssociationModelImpl)analyticsAssociation;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && analyticsAssociation.getCreateDate() == null) {
            if (serviceContext == null) {
                analyticsAssociation.setCreateDate(date);
            } else {
                analyticsAssociation.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!analyticsAssociationModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                analyticsAssociation.setModifiedDate(date);
            } else {
                analyticsAssociation.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)analyticsAssociation);
            } else {
                analyticsAssociation = (AnalyticsAssociation)session.merge((Object)analyticsAssociation);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(AnalyticsAssociationImpl.class, (BaseModel)analyticsAssociationModelImpl, false, true);
        if (isNew) {
            analyticsAssociation.setNew(false);
        }
        analyticsAssociation.resetOriginalValues();
        return analyticsAssociation;
    }

    public AnalyticsAssociation findByPrimaryKey(Serializable primaryKey) throws NoSuchAssociationException {
        AnalyticsAssociation analyticsAssociation = (AnalyticsAssociation)this.fetchByPrimaryKey(primaryKey);
        if (analyticsAssociation == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchAssociationException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return analyticsAssociation;
    }

    public AnalyticsAssociation findByPrimaryKey(long analyticsAssociationId) throws NoSuchAssociationException {
        return this.findByPrimaryKey(Long.valueOf(analyticsAssociationId));
    }

    public AnalyticsAssociation fetchByPrimaryKey(long analyticsAssociationId) {
        return (AnalyticsAssociation)this.fetchByPrimaryKey(Long.valueOf(analyticsAssociationId));
    }

    public List<AnalyticsAssociation> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<AnalyticsAssociation> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<AnalyticsAssociation> findAll(int start, int end, OrderByComparator<AnalyticsAssociation> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<AnalyticsAssociation> findAll(int start, int end, OrderByComparator<AnalyticsAssociation> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_ANALYTICSASSOCIATION);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_ANALYTICSASSOCIATION;
                sql = sql.concat(" ORDER BY analyticsAssociation.analyticsAssociationId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (AnalyticsAssociation analyticsAssociation : this.findAll()) {
            this.remove((BaseModel)analyticsAssociation);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_ANALYTICSASSOCIATION);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "analyticsAssociationId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_ANALYTICSASSOCIATION;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return AnalyticsAssociationModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByC_A = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_A", new String[]{Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "associationClassName"}, true);
        this._finderPathWithoutPaginationFindByC_A = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_A", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "associationClassName"}, true);
        this._finderPathCountByC_A = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_A", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "associationClassName"}, false);
        this._finderPathWithPaginationFindByC_GtM_A = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_GtM_A", new String[]{Long.class.getName(), Date.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "modifiedDate", "associationClassName"}, true);
        this._finderPathWithPaginationCountByC_GtM_A = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByC_GtM_A", new String[]{Long.class.getName(), Date.class.getName(), String.class.getName()}, new String[]{"companyId", "modifiedDate", "associationClassName"}, false);
        this._finderPathWithPaginationFindByC_A_A = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_A_A", new String[]{Long.class.getName(), String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "associationClassName", "associationClassPK"}, true);
        this._finderPathWithoutPaginationFindByC_A_A = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_A_A", new String[]{Long.class.getName(), String.class.getName(), Long.class.getName()}, new String[]{"companyId", "associationClassName", "associationClassPK"}, true);
        this._finderPathCountByC_A_A = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_A_A", new String[]{Long.class.getName(), String.class.getName(), Long.class.getName()}, new String[]{"companyId", "associationClassName", "associationClassPK"}, false);
        this._setAnalyticsAssociationUtilPersistence(this);
    }

    @Deactivate
    public void deactivate() {
        this._setAnalyticsAssociationUtilPersistence(null);
        this.entityCache.removeCache(AnalyticsAssociationImpl.class.getName());
    }

    private void _setAnalyticsAssociationUtilPersistence(AnalyticsAssociationPersistence analyticsAssociationPersistence) {
        try {
            Field field = AnalyticsAssociationUtil.class.getDeclaredField("_persistence");
            field.setAccessible(true);
            field.set(null, analyticsAssociationPersistence);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.analytics.message.storage.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.analytics.message.storage.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.analytics.message.storage.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    private static Long _getTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

