/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.message.storage.service.base;

import com.liferay.analytics.message.storage.model.AnalyticsMessage;
import com.liferay.analytics.message.storage.model.AnalyticsMessageBodyBlobModel;
import com.liferay.analytics.message.storage.service.AnalyticsMessageLocalService;
import com.liferay.analytics.message.storage.service.AnalyticsMessageLocalServiceUtil;
import com.liferay.analytics.message.storage.service.persistence.AnalyticsMessagePersistence;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.io.AutoDeleteFileInputStream;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Blob;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class AnalyticsMessageLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AnalyticsMessageLocalService,
AopService,
IdentifiableOSGiService {
    protected AnalyticsMessageLocalService analyticsMessageLocalService;
    @Reference
    protected AnalyticsMessagePersistence analyticsMessagePersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(AnalyticsMessageLocalServiceBaseImpl.class);
    @Reference
    protected File _file;
    private static final InputStream _EMPTY_INPUT_STREAM = new UnsyncByteArrayInputStream(new byte[0]);
    private boolean _useTempFile;

    @Indexable(type=IndexableType.REINDEX)
    public AnalyticsMessage addAnalyticsMessage(AnalyticsMessage analyticsMessage) {
        analyticsMessage.setNew(true);
        return (AnalyticsMessage)this.analyticsMessagePersistence.update((BaseModel)analyticsMessage);
    }

    @Transactional(enabled=false)
    public AnalyticsMessage createAnalyticsMessage(long analyticsMessageId) {
        return this.analyticsMessagePersistence.create(analyticsMessageId);
    }

    @Indexable(type=IndexableType.DELETE)
    public AnalyticsMessage deleteAnalyticsMessage(long analyticsMessageId) throws PortalException {
        return this.analyticsMessagePersistence.remove(analyticsMessageId);
    }

    @Indexable(type=IndexableType.DELETE)
    public AnalyticsMessage deleteAnalyticsMessage(AnalyticsMessage analyticsMessage) {
        return (AnalyticsMessage)this.analyticsMessagePersistence.remove((BaseModel)analyticsMessage);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.analyticsMessagePersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(AnalyticsMessage.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.analyticsMessagePersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.analyticsMessagePersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.analyticsMessagePersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.analyticsMessagePersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.analyticsMessagePersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public AnalyticsMessage fetchAnalyticsMessage(long analyticsMessageId) {
        return this.analyticsMessagePersistence.fetchByPrimaryKey(analyticsMessageId);
    }

    public AnalyticsMessage getAnalyticsMessage(long analyticsMessageId) throws PortalException {
        return this.analyticsMessagePersistence.findByPrimaryKey(analyticsMessageId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.analyticsMessageLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(AnalyticsMessage.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("analyticsMessageId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.analyticsMessageLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(AnalyticsMessage.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("analyticsMessageId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.analyticsMessageLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(AnalyticsMessage.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("analyticsMessageId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.analyticsMessagePersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement AnalyticsMessageLocalServiceImpl#deleteAnalyticsMessage(AnalyticsMessage) to avoid orphaned data");
        }
        return this.analyticsMessageLocalService.deleteAnalyticsMessage((AnalyticsMessage)persistedModel);
    }

    public BasePersistence<AnalyticsMessage> getBasePersistence() {
        return this.analyticsMessagePersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.analyticsMessagePersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<AnalyticsMessage> getAnalyticsMessages(int start, int end) {
        return this.analyticsMessagePersistence.findAll(start, end);
    }

    public int getAnalyticsMessagesCount() {
        return this.analyticsMessagePersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public AnalyticsMessage updateAnalyticsMessage(AnalyticsMessage analyticsMessage) {
        return (AnalyticsMessage)this.analyticsMessagePersistence.update((BaseModel)analyticsMessage);
    }

    public AnalyticsMessageBodyBlobModel getBodyBlobModel(Serializable primaryKey) {
        Session session = null;
        try {
            session = this.analyticsMessagePersistence.openSession();
            AnalyticsMessageBodyBlobModel analyticsMessageBodyBlobModel = (AnalyticsMessageBodyBlobModel)session.get(AnalyticsMessageBodyBlobModel.class, primaryKey);
            return analyticsMessageBodyBlobModel;
        }
        catch (Exception exception) {
            throw this.analyticsMessagePersistence.processException(exception);
        }
        finally {
            this.analyticsMessagePersistence.closeSession(session);
        }
    }

    @Transactional(readOnly=true)
    public InputStream openBodyInputStream(long analyticsMessageId) {
        try {
            AnalyticsMessageBodyBlobModel AnalyticsMessageBodyBlobModel2 = this.getBodyBlobModel(Long.valueOf(analyticsMessageId));
            Blob blob = AnalyticsMessageBodyBlobModel2.getBodyBlob();
            if (blob == null) {
                return _EMPTY_INPUT_STREAM;
            }
            InputStream inputStream = blob.getBinaryStream();
            if (this._useTempFile) {
                inputStream = new AutoDeleteFileInputStream(this._file.createTempFile(inputStream));
            }
            return inputStream;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    @Activate
    protected void activate() {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() != DBType.DB2 && db.getDBType() != DBType.MYSQL && db.getDBType() != DBType.MARIADB && db.getDBType() != DBType.SYBASE) {
            this._useTempFile = true;
        }
    }

    @Deactivate
    protected void deactivate() {
        this._setLocalServiceUtilService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{AnalyticsMessageLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.analyticsMessageLocalService = (AnalyticsMessageLocalService)aopProxy;
        this._setLocalServiceUtilService(this.analyticsMessageLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return AnalyticsMessageLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return AnalyticsMessage.class;
    }

    protected String getModelClassName() {
        return AnalyticsMessage.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.analyticsMessagePersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _setLocalServiceUtilService(AnalyticsMessageLocalService analyticsMessageLocalService) {
        try {
            Field field = AnalyticsMessageLocalServiceUtil.class.getDeclaredField("_service");
            field.setAccessible(true);
            field.set(null, analyticsMessageLocalService);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

