/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.message.storage.service.impl;

import com.liferay.analytics.message.storage.model.AnalyticsMessage;
import com.liferay.analytics.message.storage.service.base.AnalyticsMessageLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.jdbc.OutputBlob;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import java.io.InputStream;
import java.sql.Blob;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.analytics.message.storage.model.AnalyticsMessage"}, service={AopService.class})
public class AnalyticsMessageLocalServiceImpl
extends AnalyticsMessageLocalServiceBaseImpl {
    public AnalyticsMessage addAnalyticsMessage(long companyId, long userId, byte[] body) throws PortalException {
        AnalyticsMessage analyticsMessage = this.analyticsMessagePersistence.create(this.counterLocalService.increment());
        analyticsMessage.setCompanyId(companyId);
        analyticsMessage.setUserId(userId);
        User user = this.userLocalService.getUser(userId);
        analyticsMessage.setUserName(user.getFullName());
        analyticsMessage.setCreateDate(new Date());
        analyticsMessage.setBody((Blob)new OutputBlob((InputStream)new UnsyncByteArrayInputStream(body), (long)body.length));
        return (AnalyticsMessage)this.analyticsMessagePersistence.update((BaseModel)analyticsMessage);
    }

    public void deleteAnalyticsMessages(List<AnalyticsMessage> analyticsMessages) {
        for (AnalyticsMessage analyticsMessage : analyticsMessages) {
            this.analyticsMessagePersistence.remove((BaseModel)analyticsMessage);
        }
    }

    public void deleteAnalyticsMessages(long companyId) {
        this.analyticsMessagePersistence.removeByCompanyId(companyId);
    }

    public List<AnalyticsMessage> getAnalyticsMessages(long companyId, int start, int end) {
        return this.analyticsMessagePersistence.findByCompanyId(companyId, start, end);
    }

    public List<Long> getCompanyIds() {
        DynamicQuery dynamicQuery = this.dynamicQuery();
        dynamicQuery.setProjection(ProjectionFactoryUtil.distinct((Projection)ProjectionFactoryUtil.property((String)"companyId")));
        return this.analyticsMessagePersistence.findWithDynamicQuery(dynamicQuery);
    }
}

