/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.message.sender.internal.model.listener;

import com.liferay.analytics.message.sender.model.listener.BaseEntityModelListener;
import com.liferay.analytics.message.sender.model.listener.EntityModelListener;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupModel;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={EntityModelListener.class, ModelListener.class})
public class GroupModelListener
extends BaseEntityModelListener<Group> {
    private static final List<String> _attributeNames = Collections.singletonList("name");
    @Reference
    private GroupLocalService _groupLocalService;

    public List<String> getAttributeNames(long companyId) {
        return _attributeNames;
    }

    public long[] getMembershipIds(User user) throws Exception {
        List groups = user.getSiteGroups();
        Stream stream = groups.stream();
        return stream.mapToLong(GroupModel::getGroupId).toArray();
    }

    public String getModelClassName() {
        return Group.class.getName();
    }

    public void onAfterRemove(Group group) throws ModelListenerException {
        if (!this.analyticsConfigurationRegistry.isActive() || this.isExcluded(group)) {
            return;
        }
        this.updateConfigurationProperties(group.getCompanyId(), "syncedGroupIds", String.valueOf(group.getGroupId()), "liferayAnalyticsGroupIds");
    }

    protected ActionableDynamicQuery getActionableDynamicQuery() {
        ActionableDynamicQuery actionableDynamicQuery = this._groupLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property property = PropertyFactoryUtil.forName((String)"site");
            dynamicQuery.add(property.eq((Object)true));
        });
        return actionableDynamicQuery;
    }

    protected Group getModel(long id) throws Exception {
        return this._groupLocalService.getGroup(id);
    }

    protected String getPrimaryKeyName() {
        return "groupId";
    }

    protected boolean isExcluded(Group group) {
        return !group.isSite();
    }
}

