/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.message.sender.internal.model.listener;

import com.liferay.analytics.message.sender.model.listener.BaseEntityModelListener;
import com.liferay.analytics.message.sender.model.listener.EntityModelListener;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoColumnConstants;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={EntityModelListener.class, ModelListener.class})
public class ExpandoColumnModelListener
extends BaseEntityModelListener<ExpandoColumn> {
    private static final List<String> _attributeNames = Arrays.asList("className", "companyId", "dataType", "displayType", "name", "typeLabel");
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;

    public List<String> getAttributeNames(long companyId) {
        return _attributeNames;
    }

    public void onBeforeUpdate(ExpandoColumn originalExpandoColumn, ExpandoColumn expandoColumn) throws ModelListenerException {
        if (!this.analyticsConfigurationRegistry.isActive()) {
            return;
        }
        ExpandoColumn oldExpandoColumn = this._expandoColumnLocalService.fetchExpandoColumn(expandoColumn.getColumnId());
        if (Objects.equals(oldExpandoColumn.getName(), expandoColumn.getName()) && Objects.equals(oldExpandoColumn.getType(), expandoColumn.getType())) {
            return;
        }
        this.addAnalyticsMessage("update", this.getAttributeNames(expandoColumn.getCompanyId()), (BaseModel)expandoColumn);
    }

    protected ActionableDynamicQuery getActionableDynamicQuery() {
        ActionableDynamicQuery actionableDynamicQuery = this._expandoColumnLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property tableIdProperty = PropertyFactoryUtil.forName((String)"tableId");
            dynamicQuery.add(tableIdProperty.in(this._getTableDynamicQuery(this.classNameLocalService.getClassNameId(Organization.class.getName()), "CUSTOM_FIELDS")));
        });
        return actionableDynamicQuery;
    }

    protected ExpandoColumn getModel(long id) throws Exception {
        return this._expandoColumnLocalService.getColumn(id);
    }

    protected String getPrimaryKeyName() {
        return "name";
    }

    protected boolean isExcluded(ExpandoColumn expandoColumn) {
        if (this.isCustomField(Organization.class.getName(), expandoColumn.getTableId())) {
            return false;
        }
        if (this.isCustomField(User.class.getName(), expandoColumn.getTableId())) {
            AnalyticsConfiguration analyticsConfiguration = this.analyticsConfigurationRegistry.getAnalyticsConfiguration(expandoColumn.getCompanyId());
            if (ArrayUtil.isEmpty((Object[])analyticsConfiguration.syncedUserFieldNames())) {
                return true;
            }
            for (String syncedUserFieldName : analyticsConfiguration.syncedUserFieldNames()) {
                if (!Objects.equals(expandoColumn.getName(), syncedUserFieldName)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    protected JSONObject serialize(BaseModel<?> baseModel, List<String> includeAttributeNames) {
        String dataType;
        ExpandoColumn expandoColumn = (ExpandoColumn)baseModel;
        String className = User.class.getName();
        if (this.isCustomField(Organization.class.getName(), expandoColumn.getTableId())) {
            className = Organization.class.getName();
        }
        if (Validator.isBlank((String)(dataType = ExpandoColumnConstants.getDataType((int)expandoColumn.getType())))) {
            dataType = "Text";
        }
        return JSONUtil.put((String)"className", (Object)className).put("companyId", expandoColumn.getCompanyId()).put("dataType", dataType).put("displayType", ExpandoColumnConstants.getDefaultDisplayTypeProperty((int)expandoColumn.getType(), (UnicodeProperties)expandoColumn.getTypeSettingsProperties())).put("name", expandoColumn.getName() + "-" + dataType).put("typeLabel", ExpandoColumnConstants.getTypeLabel((int)expandoColumn.getType()));
    }

    private DynamicQuery _getTableDynamicQuery(long organizationClassNameId, String name) {
        DynamicQuery dynamicQuery = this.expandoTableLocalService.dynamicQuery();
        Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
        dynamicQuery.add(classNameIdProperty.eq((Object)organizationClassNameId));
        Property nameProperty = PropertyFactoryUtil.forName((String)"name");
        dynamicQuery.add(nameProperty.eq((Object)name));
        dynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"tableId"));
        return dynamicQuery;
    }
}

