/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.message.sender.internal.messaging;

import com.liferay.analytics.message.sender.internal.messaging.AnalyticsMessagesHelper;
import com.liferay.analytics.settings.configuration.AnalyticsConfigurationRegistry;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={})
public class SendAnalyticsMessagesSchedulerEventMessageListener
extends BaseMessageListener {
    @Reference
    private AnalyticsConfigurationRegistry _analyticsConfigurationRegistry;
    @Reference
    private AnalyticsMessagesHelper _analyticsMessagesHelper;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    @Activate
    protected void activate() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String className = clazz.getName();
        Trigger trigger = this._triggerFactory.createTrigger(className, className, null, null, 1, TimeUnit.HOUR);
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(className, trigger);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)schedulerEntry, "liferay/scheduler_dispatch");
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws Exception {
        if (this._isDisabled()) {
            return;
        }
        this._companyLocalService.forEachCompanyId(companyId -> this._analyticsMessagesHelper.send((long)companyId));
    }

    protected void doReceive(Message message, long companyId) throws Exception {
        if (this._isDisabled()) {
            return;
        }
        this._analyticsMessagesHelper.send(companyId);
    }

    private boolean _isDisabled() {
        return GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LRAC-10632")) || !this._analyticsConfigurationRegistry.isActive();
    }
}

