/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.message.sender.internal.messaging;

import com.liferay.analytics.message.sender.constants.AnalyticsMessagesProcessorCommand;
import com.liferay.analytics.message.sender.internal.messaging.AnalyticsMessagesHelper;
import com.liferay.analytics.settings.configuration.AnalyticsConfigurationRegistry;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/analytics_messages_processor"}, service={MessageListener.class})
public class SendAnalyticsMessagesMessageListener
extends BaseMessageListener {
    @Reference
    private AnalyticsConfigurationRegistry _analyticsConfigurationRegistry;
    @Reference
    private AnalyticsMessagesHelper _analyticsMessagesHelper;
    @Reference
    private CompanyLocalService _companyLocalService;

    protected void doReceive(Message message) throws Exception {
        if (this._skipProcess(message)) {
            return;
        }
        this._companyLocalService.forEachCompanyId(companyId -> this._analyticsMessagesHelper.send((long)companyId));
    }

    protected void doReceive(Message message, long companyId) throws Exception {
        if (this._skipProcess(message)) {
            return;
        }
        this._analyticsMessagesHelper.send(companyId);
    }

    private boolean _skipProcess(Message message) {
        if (GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LRAC-10632")) || !this._analyticsConfigurationRegistry.isActive()) {
            return true;
        }
        AnalyticsMessagesProcessorCommand analyticsMessagesProcessorCommand = (AnalyticsMessagesProcessorCommand)message.get("command");
        return analyticsMessagesProcessorCommand != null && analyticsMessagesProcessorCommand != AnalyticsMessagesProcessorCommand.SEND;
    }
}

