/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.message.sender.internal;

import com.liferay.analytics.message.storage.service.AnalyticsMessageLocalService;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.configuration.AnalyticsConfigurationRegistry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseAnalyticsClientImpl {
    @Reference
    protected AnalyticsConfigurationRegistry analyticsConfigurationRegistry;
    @Reference
    protected AnalyticsMessageLocalService analyticsMessageLocalService;
    @Reference
    protected CompanyLocalService companyLocalService;
    @Reference
    protected ConfigurationProvider configurationProvider;
    @Reference
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BaseAnalyticsClientImpl.class);

    protected CloseableHttpClient getCloseableHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.useSystemProperties();
        return httpClientBuilder.build();
    }

    protected boolean isEnabled(long companyId) {
        if (!this.analyticsConfigurationRegistry.isActive()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Analytics configuration tracker not active");
            }
            return false;
        }
        AnalyticsConfiguration analyticsConfiguration = this.analyticsConfigurationRegistry.getAnalyticsConfiguration(companyId);
        if (analyticsConfiguration.liferayAnalyticsEndpointURL() == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Analytics endpoint URL null");
            }
            return false;
        }
        return true;
    }

    protected void processInvalidTokenMessage(long companyId, boolean disconnected, String message) {
        if (message.equals("INVALID_TOKEN") || disconnected) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Disconnecting data source for company ", companyId, " because of an invalid token"}));
            }
            this._disconnectDataSource(companyId);
            this.analyticsMessageLocalService.deleteAnalyticsMessages(companyId);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Deleted all analytics messages for company " + companyId));
            }
        }
    }

    private void _disconnectDataSource(long companyId) {
        block5: {
            block4: {
                try {
                    this.companyLocalService.updatePreferences(companyId, UnicodePropertiesBuilder.create((boolean)true).put("liferayAnalyticsConnectionType", "").put("liferayAnalyticsDataSourceId", "").put("liferayAnalyticsEndpointURL", "").put("liferayAnalyticsFaroBackendSecuritySignature", "").put("liferayAnalyticsFaroBackendURL", "").put("liferayAnalyticsGroupIds", "").put("liferayAnalyticsProjectId", "").put("liferayAnalyticsURL", "").build());
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)("Unable to remove analytics preferences for company " + companyId), (Throwable)exception);
                }
            }
            try {
                this.configurationProvider.deleteCompanyConfiguration(AnalyticsConfiguration.class, companyId);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)("Unable to remove analytics configuration for company " + companyId), (Throwable)exception);
            }
        }
    }
}

