/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.message.sender.internal;

import aQute.bnd.annotation.metatype.Meta;
import com.liferay.analytics.message.sender.client.AnalyticsMessageSenderClient;
import com.liferay.analytics.message.sender.internal.BaseAnalyticsClientImpl;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsDescriptor;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AnalyticsMessageSenderClient.class})
public class AnalyticsMessageSenderClientImpl
extends BaseAnalyticsClientImpl
implements AnalyticsMessageSenderClient {
    private static final Log _log = LogFactoryUtil.getLog(AnalyticsMessageSenderClientImpl.class);
    @Reference
    private JSONFactory _jsonFactory;
    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.analytics.settings.web)(release.schema.version>=1.0.1))")
    private Release _release;
    @Reference
    private SettingsFactory _settingsFactory;

    public Object send(String body, long companyId) throws Exception {
        if (!this.isEnabled(companyId)) {
            return null;
        }
        AnalyticsConfiguration analyticsConfiguration = this.analyticsConfigurationRegistry.getAnalyticsConfiguration(companyId);
        HttpUriRequest httpUriRequest = this._buildHttpUriRequest(body, analyticsConfiguration.liferayAnalyticsDataSourceId(), analyticsConfiguration.liferayAnalyticsFaroBackendSecuritySignature(), "POST", analyticsConfiguration.liferayAnalyticsProjectId(), analyticsConfiguration.liferayAnalyticsEndpointURL() + "/dxp-entities");
        return this._execute(analyticsConfiguration, companyId, httpUriRequest);
    }

    public void validateConnection(long companyId) throws Exception {
        if (!this.isEnabled(companyId)) {
            return;
        }
        AnalyticsConfiguration analyticsConfiguration = this.analyticsConfigurationRegistry.getAnalyticsConfiguration(companyId);
        this._checkEndpoints(analyticsConfiguration, companyId);
        HttpUriRequest httpUriRequest = this._buildHttpUriRequest(null, analyticsConfiguration.liferayAnalyticsDataSourceId(), analyticsConfiguration.liferayAnalyticsFaroBackendSecuritySignature(), "GET", analyticsConfiguration.liferayAnalyticsProjectId(), analyticsConfiguration.liferayAnalyticsFaroBackendURL() + "/api/1.0/data-sources/" + analyticsConfiguration.liferayAnalyticsDataSourceId());
        this._execute(analyticsConfiguration, companyId, httpUriRequest);
    }

    private HttpUriRequest _buildHttpUriRequest(String body, String dataSourceId, String faroBackendSecuritySignature, String method, String projectId, String url) throws Exception {
        HttpGet httpUriRequest = null;
        if (method.equals("GET")) {
            httpUriRequest = new HttpGet(url);
        } else if (method.equals("POST")) {
            HttpPost httpPost = new HttpPost(url);
            if (Validator.isNotNull((String)body)) {
                httpPost.setEntity((HttpEntity)new StringEntity(body, StandardCharsets.UTF_8));
            }
            httpUriRequest = httpPost;
        }
        if (httpUriRequest != null) {
            httpUriRequest.setHeader("Content-Type", "application/json");
            httpUriRequest.setHeader("OSB-Asah-Data-Source-ID", dataSourceId);
            httpUriRequest.setHeader("OSB-Asah-Faro-Backend-Security-Signature", faroBackendSecuritySignature);
            httpUriRequest.setHeader("OSB-Asah-Project-ID", projectId);
        }
        return httpUriRequest;
    }

    private void _checkEndpoints(AnalyticsConfiguration analyticsConfiguration, long companyId) throws Exception {
        HttpGet httpGet = new HttpGet(analyticsConfiguration.liferayAnalyticsURL() + "/endpoints/" + analyticsConfiguration.liferayAnalyticsProjectId());
        try (CloseableHttpClient closeableHttpClient = this.getCloseableHttpClient();){
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
            JSONObject responseJSONObject = null;
            try {
                responseJSONObject = this._jsonFactory.createJSONObject(EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (Charset)Charset.defaultCharset()));
            }
            catch (Exception exception) {
                _log.error((Object)"Unable to check Analytics Cloud endpoints", (Throwable)exception);
                if (closeableHttpClient != null) {
                    if (var6_5 != null) {
                        try {
                            closeableHttpClient.close();
                        }
                        catch (Throwable throwable) {
                            var6_5.addSuppressed(throwable);
                        }
                    } else {
                        closeableHttpClient.close();
                    }
                }
                return;
            }
            String liferayAnalyticsEndpointURL = responseJSONObject.getString("liferayAnalyticsEndpointURL");
            String liferayAnalyticsFaroBackendURL = responseJSONObject.getString("liferayAnalyticsFaroBackendURL");
            if (liferayAnalyticsEndpointURL.equals(PrefsPropsUtil.getString((long)companyId, (String)"liferayAnalyticsEndpointURL")) && liferayAnalyticsFaroBackendURL.equals(PrefsPropsUtil.getString((long)companyId, (String)"liferayAnalyticsFaroBackendURL"))) {
                return;
            }
            this.companyLocalService.updatePreferences(companyId, UnicodePropertiesBuilder.create((boolean)true).put("liferayAnalyticsEndpointURL", liferayAnalyticsEndpointURL).put("liferayAnalyticsFaroBackendURL", liferayAnalyticsFaroBackendURL).build());
            Dictionary<String, Object> configurationProperties = this._getConfigurationProperties(companyId);
            configurationProperties.put("liferayAnalyticsEndpointURL", liferayAnalyticsEndpointURL);
            this.configurationProvider.saveCompanyConfiguration(AnalyticsConfiguration.class, companyId, configurationProperties);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CloseableHttpResponse _execute(AnalyticsConfiguration analyticsConfiguration, long companyId, HttpUriRequest httpUriRequest) throws Exception {
        try (CloseableHttpClient closeableHttpClient = this.getCloseableHttpClient();){
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute(httpUriRequest);
            StatusLine statusLine = closeableHttpResponse.getStatusLine();
            JSONObject responseJSONObject = this._jsonFactory.createJSONObject(EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (Charset)Charset.defaultCharset()));
            boolean disconnected = StringUtil.equals((String)GetterUtil.getString((String)responseJSONObject.getString("state")), (String)"DISCONNECTED");
            if (statusLine.getStatusCode() != 403 && !disconnected) {
                CloseableHttpResponse closeableHttpResponse2 = closeableHttpResponse;
                return closeableHttpResponse2;
            }
            this.processInvalidTokenMessage(companyId, disconnected, responseJSONObject.getString("message"));
            CloseableHttpResponse closeableHttpResponse3 = closeableHttpResponse;
            return closeableHttpResponse3;
        }
        catch (UnknownHostException unknownHostException) {
            this._checkEndpoints(analyticsConfiguration, companyId);
            throw unknownHostException;
        }
    }

    private Dictionary<String, Object> _getConfigurationProperties(long companyId) throws Exception {
        Hashtable<String, Object> configurationProperties = new Hashtable<String, Object>();
        Class<AnalyticsConfiguration> clazz = AnalyticsConfiguration.class;
        Meta.OCD ocd = clazz.getAnnotation(Meta.OCD.class);
        Settings settings = this._settingsFactory.getSettings((SettingsLocator)new CompanyServiceSettingsLocator(companyId, ocd.id()));
        SettingsDescriptor settingsDescriptor = this._settingsFactory.getSettingsDescriptor(ocd.id());
        if (settingsDescriptor == null) {
            return configurationProperties;
        }
        Set multiValuedKeys = settingsDescriptor.getMultiValuedKeys();
        for (String multiValuedKey : multiValuedKeys) {
            ((Dictionary)configurationProperties).put(multiValuedKey, settings.getValues(multiValuedKey, new String[0]));
        }
        Set keys = settingsDescriptor.getAllKeys();
        keys.removeAll(multiValuedKeys);
        for (String key : keys) {
            ((Dictionary)configurationProperties).put(key, settings.getValue(key, ""));
        }
        return configurationProperties;
    }
}

