/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.message.sender.internal.model.listener;

import com.liferay.analytics.message.sender.model.listener.BaseEntityModelListener;
import com.liferay.analytics.message.sender.model.listener.EntityModelListener;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={EntityModelListener.class, ModelListener.class})
public class OrganizationModelListener
extends BaseEntityModelListener<Organization> {
    @Reference
    private OrganizationLocalService _organizationLocalService;

    public List<String> getAttributeNames(long companyId) {
        return this.getOrganizationAttributeNames();
    }

    public long[] getMembershipIds(User user) throws Exception {
        return user.getOrganizationIds();
    }

    public String getModelClassName() {
        return Organization.class.getName();
    }

    public void onAfterRemove(Organization organization) throws ModelListenerException {
        if (!this.analyticsConfigurationTracker.isActive()) {
            return;
        }
        if (this.isExcluded((BaseModel)organization)) {
            return;
        }
        this.updateConfigurationProperties(organization.getCompanyId(), "syncedOrganizationIds", String.valueOf(organization.getOrganizationId()), null);
    }

    protected ActionableDynamicQuery getActionableDynamicQuery() {
        return this._organizationLocalService.getActionableDynamicQuery();
    }

    protected Organization getModel(long id) throws Exception {
        return this._organizationLocalService.getOrganization(id);
    }

    protected String getPrimaryKeyName() {
        return "organizationId";
    }
}

