/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.demo.data.creator.internal;

import com.liferay.analytics.demo.data.creator.AnalyticsDemoDataCreator;
import com.liferay.analytics.demo.data.creator.configuration.AnalyticsDemoDataCreatorConfiguration;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.DuplicateGroupException;
import com.liferay.portal.kernel.exception.DuplicateOrganizationException;
import com.liferay.portal.kernel.exception.DuplicateRoleException;
import com.liferay.portal.kernel.exception.DuplicateTeamException;
import com.liferay.portal.kernel.exception.DuplicateUserGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.TeamLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.FriendlyURLNormalizer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.analytics.demo.data.creator.configuration.AnalyticsDemoDataCreatorConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={AnalyticsDemoDataCreator.class})
public class AnalyticsDemoDataCreatorImpl
implements AnalyticsDemoDataCreator {
    private static final Log _log = LogFactoryUtil.getLog(AnalyticsDemoDataCreatorImpl.class);
    private volatile AnalyticsDemoDataCreatorConfiguration _analyticsDemoDataCreatorConfiguration;
    private long _companyId;
    @Reference
    private CompanyLocalService _companyLocalService;
    private long _defaultGroupId;
    private long _defaultUserId;
    @Reference
    private FriendlyURLNormalizer _friendlyURLNormalizer;
    @Reference
    private GroupLocalService _groupLocalService;
    private final HashMap<String, Group> _groups = new HashMap();
    @Reference
    private OrganizationLocalService _organizationLocalService;
    private final HashMap<String, Organization> _organizations = new HashMap();
    @Reference
    private RoleLocalService _roleLocalService;
    private final HashMap<String, Role> _roles = new HashMap();
    @Reference
    private TeamLocalService _teamLocalService;
    private final HashMap<String, Team> _teams = new HashMap();
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    private final HashMap<String, UserGroup> _userGroups = new HashMap();
    @Reference
    private UserLocalService _userLocalService;
    private final HashMap<String, User> _users = new HashMap();

    public void create() throws Exception {
        File file = new File(this._analyticsDemoDataCreatorConfiguration.pathToUsersCSV());
        for (CSVRecord csvRecord : this._getCSVParser(file)) {
            String emailAddress = csvRecord.get("emailAddress");
            if (this._users.containsKey(emailAddress)) continue;
            try {
                this._users.put(emailAddress, this._addUser(csvRecord));
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)("Created user " + emailAddress));
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Finished adding analytics demo data");
        }
    }

    public void delete() throws PortalException {
        for (Map.Entry<String, User> entry : this._users.entrySet()) {
            this._userLocalService.deleteUser(entry.getValue());
        }
        for (Map.Entry<String, User> entry : this._groups.entrySet()) {
            this._groupLocalService.deleteGroup((Group)entry.getValue());
        }
        for (Map.Entry<String, User> entry : this._organizations.entrySet()) {
            this._organizationLocalService.deleteOrganization((Organization)entry.getValue());
        }
        for (Map.Entry<String, User> entry : this._roles.entrySet()) {
            this._roleLocalService.deleteRole((Role)entry.getValue());
        }
        for (Map.Entry<String, User> entry : this._teams.entrySet()) {
            this._teamLocalService.deleteTeam((Team)entry.getValue());
        }
        for (Map.Entry<String, User> entry : this._userGroups.entrySet()) {
            this._userGroupLocalService.deleteUserGroup((UserGroup)entry.getValue());
        }
        this._groups.clear();
        this._organizations.clear();
        this._roles.clear();
        this._teams.clear();
        this._userGroups.clear();
        this._users.clear();
    }

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        this._analyticsDemoDataCreatorConfiguration = (AnalyticsDemoDataCreatorConfiguration)ConfigurableUtil.createConfigurable(AnalyticsDemoDataCreatorConfiguration.class, properties);
        Company company = this._companyLocalService.getCompanyByVirtualHost(this._analyticsDemoDataCreatorConfiguration.virtualHostname());
        this._companyId = company.getCompanyId();
        this._defaultUserId = this._userLocalService.getDefaultUserId(this._companyId);
        Group group = this._groupLocalService.getGroup(company.getCompanyId(), "Guest");
        this._defaultGroupId = group.getGroupId();
        this.create();
    }

    @Deactivate
    protected void deactivate() {
        try {
            this.delete();
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    private long[] _addEntries(CSVRecord csvRecord, String header) throws PortalException {
        String cell = csvRecord.get(header);
        if (cell == null) {
            return null;
        }
        long[] ids = new long[]{};
        String[] values = cell.split(",");
        if (StringUtil.equalsIgnoreCase((String)header, (String)"organizations")) {
            ids = this._addOrganizations(values);
        } else if (StringUtil.equalsIgnoreCase((String)header, (String)"roles")) {
            ids = this._addRoles(values);
        } else if (StringUtil.equalsIgnoreCase((String)header, (String)"sites")) {
            ids = this._addSites(values);
        } else if (StringUtil.equalsIgnoreCase((String)header, (String)"teams")) {
            ids = this._addTeams(values);
        } else if (StringUtil.equalsIgnoreCase((String)header, (String)"userGroups")) {
            ids = this._addUserGroups(values);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Added ", header, " with ids: ", Arrays.toString(ids)}));
        }
        return ids;
    }

    private long[] _addOrganizations(String[] values) throws PortalException {
        long[] ids = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            String name = values[i].trim();
            Organization organization = null;
            try {
                organization = this._organizationLocalService.addOrganization(this._defaultUserId, 0L, name, false);
            }
            catch (DuplicateOrganizationException duplicateOrganizationException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)duplicateOrganizationException);
                }
                organization = this._organizationLocalService.getOrganization(this._companyId, name);
            }
            this._organizations.put(name, organization);
            ids[i] = organization.getPrimaryKey();
        }
        return ids;
    }

    private long[] _addRoles(String[] values) throws PortalException {
        long[] ids = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            String name = values[i].trim();
            Role role = null;
            try {
                role = this._roleLocalService.addRole(this._defaultUserId, null, 0L, name, null, null, 1, null, null);
            }
            catch (DuplicateRoleException duplicateRoleException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)duplicateRoleException);
                }
                role = this._roleLocalService.getRole(this._companyId, name);
            }
            this._roles.put(name, role);
            ids[i] = role.getPrimaryKey();
        }
        return ids;
    }

    private long[] _addSites(String[] values) throws PortalException {
        long[] ids = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            String name = values[i].trim();
            HashMap nameMap = HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)name).build();
            Group group = null;
            try {
                group = this._groupLocalService.addGroup(this._defaultUserId, 0L, null, 0L, 0L, (Map)nameMap, new HashMap(), 1, true, 0, "/" + this._friendlyURLNormalizer.normalize(name), true, true, null);
            }
            catch (DuplicateGroupException duplicateGroupException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)duplicateGroupException);
                }
                group = this._groupLocalService.getGroup(this._companyId, name);
            }
            this._groups.put(name, group);
            ids[i] = group.getPrimaryKey();
        }
        return ids;
    }

    private long[] _addTeams(String[] values) throws PortalException {
        long[] ids = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            String name = values[i].trim();
            Team team = null;
            try {
                team = this._teamLocalService.addTeam(this._defaultUserId, this._defaultGroupId, name, null, new ServiceContext());
            }
            catch (DuplicateTeamException duplicateTeamException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)duplicateTeamException);
                }
                team = this._teamLocalService.getTeam(this._defaultGroupId, name);
            }
            this._teams.put(name, team);
            ids[i] = team.getPrimaryKey();
        }
        return ids;
    }

    private User _addUser(CSVRecord csvRecord) throws PortalException {
        long[] teamIds;
        String gender = csvRecord.get("gender");
        boolean male = StringUtil.equalsIgnoreCase((String)gender, (String)"male");
        User user = this._userLocalService.addUser(this._defaultUserId, this._companyId, false, csvRecord.get("password"), csvRecord.get("password"), false, csvRecord.get("screenName"), csvRecord.get("emailAddress"), LocaleUtil.getDefault(), csvRecord.get("firstName"), csvRecord.get("middleName"), csvRecord.get("lastName"), 0L, 0L, male, GetterUtil.getInteger((String)csvRecord.get("birthdayMonth")) - 1, GetterUtil.getInteger((String)csvRecord.get("birthdayDay")), GetterUtil.getInteger((String)csvRecord.get("birthdayYear")), csvRecord.get("jobTitle"), null, this._addEntries(csvRecord, "organizations"), this._addEntries(csvRecord, "roles"), this._addEntries(csvRecord, "userGroups"), false, new ServiceContext());
        long[] siteIds = this._addEntries(csvRecord, "sites");
        if (siteIds != null) {
            this._groupLocalService.addUserGroups(user.getPrimaryKey(), siteIds);
        }
        if ((teamIds = this._addEntries(csvRecord, "teams")) != null) {
            this._teamLocalService.addUserTeams(user.getPrimaryKey(), teamIds);
        }
        return user;
    }

    private long[] _addUserGroups(String[] values) throws PortalException {
        long[] ids = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            String name = values[i].trim();
            UserGroup userGroup = null;
            try {
                userGroup = this._userGroupLocalService.addUserGroup(this._defaultUserId, this._companyId, name, null, null);
            }
            catch (DuplicateUserGroupException duplicateUserGroupException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)duplicateUserGroupException);
                }
                userGroup = this._userGroupLocalService.getUserGroup(this._companyId, name);
            }
            this._userGroups.put(name, userGroup);
            ids[i] = userGroup.getPrimaryKey();
        }
        return ids;
    }

    private CSVParser _getCSVParser(File csvFile) throws Exception {
        CSVFormat csvFormat = CSVFormat.DEFAULT;
        csvFormat = csvFormat.withFirstRecordAsHeader();
        csvFormat = csvFormat.withIgnoreSurroundingSpaces();
        csvFormat = csvFormat.withNullString("");
        try {
            return CSVParser.parse((File)csvFile, (Charset)Charset.defaultCharset(), (CSVFormat)csvFormat);
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
            throw ioException;
        }
    }
}

