/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.data.binding.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import com.liferay.analytics.data.binding.JSONObjectMapper;
import com.liferay.analytics.model.AnalyticsEventsMessage;
import java.io.IOException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"model=com.liferay.analytics.model.AnalyticsEventsMessage"}, service={JSONObjectMapper.class})
public class AnalyticsEventsMessageJSONObjectMapper
implements JSONObjectMapper<AnalyticsEventsMessage> {
    private final ObjectMapper _objectMapper = new ObjectMapper();

    public AnalyticsEventsMessageJSONObjectMapper() {
        this._objectMapper.addMixIn(AnalyticsEventsMessage.class, AnalyticsEventsMessageMixIn.class);
        this._objectMapper.addMixIn(AnalyticsEventsMessage.Event.class, EventMixIn.class);
        this._objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this._objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this._objectMapper.setDateFormat((DateFormat)((Object)new ISO8601MillisDateFormat()));
    }

    public String map(AnalyticsEventsMessage analyticsEventsMessage) throws IOException {
        return this._objectMapper.writeValueAsString((Object)analyticsEventsMessage);
    }

    public AnalyticsEventsMessage map(String jsonString) throws IOException {
        return (AnalyticsEventsMessage)this._objectMapper.readValue(jsonString, AnalyticsEventsMessage.class);
    }

    private final class ISO8601MillisDateFormat
    extends ISO8601DateFormat {
        private ISO8601MillisDateFormat() {
        }

        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            String value = ISO8601Utils.format((Date)date, (boolean)true);
            toAppendTo.append(value);
            return toAppendTo;
        }
    }

    private static final class EventMixIn {
        @JsonProperty(value="applicationId")
        private String _applicationId;
        @JsonProperty(value="eventDate")
        private Date _eventDate;
        @JsonProperty(value="eventId")
        private String _eventId;
        @JsonProperty(value="properties")
        private Map<String, String> _properties;

        private EventMixIn() {
        }
    }

    private static final class AnalyticsEventsMessageMixIn {
        @JsonProperty(value="context")
        private Map<String, String> _context;
        @JsonProperty(value="dataSourceId")
        private String _dataSourceId;
        @JsonProperty(value="events")
        private List<?> _events;
        @JsonProperty(value="protocolVersion")
        private String _protocolVersion;
        @JsonProperty(value="userId")
        private String _userId;

        private AnalyticsEventsMessageMixIn() {
        }
    }
}

