/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.batch.exportimport.model.listener;

import com.liferay.analytics.message.storage.service.AnalyticsAssociationLocalService;
import com.liferay.analytics.message.storage.service.AnalyticsDeleteMessageLocalService;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.configuration.AnalyticsConfigurationTracker;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.CompanyService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.Dictionary;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseAnalyticsDXPEntityModelListener<T extends BaseModel<T>>
extends BaseModelListener<T> {
    @Reference
    protected AnalyticsAssociationLocalService analyticsAssociationLocalService;
    @Reference
    protected AnalyticsConfigurationTracker analyticsConfigurationTracker;
    @Reference
    protected AnalyticsDeleteMessageLocalService analyticsDeleteMessageLocalService;
    @Reference
    protected CompanyService companyService;
    @Reference
    protected ConfigurationProvider configurationProvider;
    @Reference
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BaseAnalyticsDXPEntityModelListener.class);

    public void onAfterAddAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        this._addAnalyticsAssociation(associationClassName, associationClassPK, classPK);
    }

    public void onAfterRemove(T model) throws ModelListenerException {
        ShardedModel shardedModel = (ShardedModel)model;
        this.analyticsAssociationLocalService.deleteAnalyticsAssociations(shardedModel.getCompanyId(), model.getModelClassName(), ((Long)model.getPrimaryKeyObj()).longValue());
    }

    public void onAfterRemoveAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        this._addAnalyticsAssociation(associationClassName, associationClassPK, classPK);
    }

    public void onBeforeRemove(T model) throws ModelListenerException {
        block3: {
            if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LRAC-10632")) || !this.isTracked(model)) {
                return;
            }
            ShardedModel shardedModel = (ShardedModel)model;
            long companyId = shardedModel.getCompanyId();
            try {
                this.analyticsDeleteMessageLocalService.addAnalyticsDeleteMessage(companyId, new Date(), model.getModelClassName(), ((Long)model.getPrimaryKeyObj()).longValue(), this.userLocalService.getDefaultUserId(companyId));
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to add analytics delete message for model " + model), (Throwable)exception);
            }
        }
    }

    protected T getModel(Object classPK) {
        return null;
    }

    protected boolean isTracked(T model) {
        return true;
    }

    protected void updateConfigurationProperties(long companyId, String configurationPropertyName, String modelId, String preferencePropertyName) {
        block8: {
            Object[] modelIds;
            Dictionary configurationProperties;
            block7: {
                configurationProperties = this.analyticsConfigurationTracker.getAnalyticsConfigurationProperties(companyId);
                if (configurationProperties == null) {
                    return;
                }
                modelIds = (String[])configurationProperties.get(configurationPropertyName);
                if (!ArrayUtil.contains((Object[])modelIds, (Object)modelId)) {
                    return;
                }
                modelIds = ArrayUtil.remove((String[])modelIds, (String)modelId);
                if (Validator.isNotNull((String)preferencePropertyName)) {
                    try {
                        this.companyService.updatePreferences(companyId, UnicodePropertiesBuilder.create((boolean)true).put(preferencePropertyName, StringUtil.merge((Object[])modelIds, (String)",")).build());
                    }
                    catch (Exception exception) {
                        if (!_log.isWarnEnabled()) break block7;
                        _log.warn((Object)("Unable to update preferences for company " + companyId), (Throwable)exception);
                    }
                }
            }
            configurationProperties.put(configurationPropertyName, modelIds);
            try {
                this.configurationProvider.saveCompanyConfiguration(AnalyticsConfiguration.class, companyId, configurationProperties);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)("Unable to update configuration for company " + companyId), (Throwable)exception);
            }
        }
    }

    private void _addAnalyticsAssociation(String associationClassName, Object associationClassPK, Object classPK) {
        block4: {
            if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LRAC-10632")) || !this.analyticsConfigurationTracker.isActive()) {
                return;
            }
            T model = this.getModel(classPK);
            if (model == null) {
                return;
            }
            try {
                ShardedModel shardedModel = (ShardedModel)model;
                long companyId = shardedModel.getCompanyId();
                Class modelClass = this.getModelClass();
                this.analyticsAssociationLocalService.addAnalyticsAssociation(companyId, new Date(), this.userLocalService.getDefaultUserId(companyId), associationClassName, ((Long)associationClassPK).longValue(), modelClass.getName(), ((Long)classPK).longValue());
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to add analytics association for model " + model), (Throwable)exception);
            }
        }
    }
}

