/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.alloy.mvc.internal.json.web.service;

import com.liferay.alloy.mvc.AlloyController;
import com.liferay.alloy.mvc.AlloyPortlet;
import com.liferay.alloy.mvc.json.web.service.AlloyControllerInvoker;
import com.liferay.alloy.mvc.json.web.service.BaseAlloyControllerInvokerImpl;
import com.liferay.alloy.mvc.json.web.service.JSONWebServiceMethod;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONSerializable;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.portlet.PortletContext;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class AlloyControllerInvokerManager {
    private static final String _BASE_CLASS_NAME = "AlloyControllerInvokerImpl";
    private static final Log _log = LogFactoryUtil.getLog(AlloyControllerInvokerManager.class);
    private final Map<String, AlloyControllerInvoker> _alloyControllerInvokers = new ConcurrentHashMap<String, AlloyControllerInvoker>();
    private final String _contextName;
    private final String _contextPath;
    private final AtomicInteger _counter = new AtomicInteger(0);
    private boolean _locked;

    public AlloyControllerInvokerManager(LiferayPortletConfig liferayPortletConfig) {
        PortletContext portletContext = liferayPortletConfig.getPortletContext();
        this._contextName = portletContext.getPortletContextName();
        this._contextPath = "/" + portletContext.getPortletContextName();
    }

    public JSONSerializable invokeAlloyController(String controller, String lifecycle, String action, Object[] parameters) throws Exception {
        AlloyControllerInvoker alloyControllerInvoker = this._alloyControllerInvokers.get(controller);
        parameters = ArrayUtil.append((Object[])parameters, (Object[])new Object[]{"controller", controller, "action", action, "format", "json"});
        return alloyControllerInvoker.invokeAlloyController(lifecycle, parameters);
    }

    public void registerController(ThemeDisplay themeDisplay, AlloyPortlet alloyPortlet, Portlet portlet, String controller, Class<? extends AlloyController> controllerClass) {
        if (this._locked) {
            return;
        }
        if (this._alloyControllerInvokers.containsKey(controller)) {
            AlloyControllerInvoker alloyControllerInvoker = this._alloyControllerInvokers.get(controller);
            JSONWebServiceActionsManagerUtil.unregisterJSONWebServiceActions((Object)alloyControllerInvoker);
        }
        Class<? extends AlloyControllerInvoker> alloyControllerInvokerClass = null;
        AlloyControllerInvoker alloyControllerInvoker = null;
        try {
            alloyControllerInvokerClass = this._createAlloyControllerInvokerClass(controllerClass);
            Constructor<? extends AlloyControllerInvoker> constructor = alloyControllerInvokerClass.getConstructor(new Class[0]);
            alloyControllerInvoker = constructor.newInstance(new Object[0]);
            alloyControllerInvoker.setProperties(themeDisplay, alloyPortlet, portlet, controller, controllerClass);
            this._alloyControllerInvokers.put(controller, alloyControllerInvoker);
        }
        catch (NoClassNecessaryException noClassNecessaryException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noClassNecessaryException);
            }
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        for (Method method : alloyControllerInvokerClass.getDeclaredMethods()) {
            JSONWebServiceActionsManagerUtil.registerJSONWebServiceAction((String)this._contextName, (String)this._contextPath, (Object)alloyControllerInvoker, alloyControllerInvokerClass, (Method)method, (String)this._getAPIPath(controller, method), (String)"GET");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterControllers() {
        this._locked = true;
        for (Map.Entry<String, AlloyControllerInvoker> entry : this._alloyControllerInvokers.entrySet()) {
            String controller = entry.getKey();
            String string = controller.intern();
            synchronized (string) {
                AlloyControllerInvoker alloyControllerInvoker = entry.getValue();
                JSONWebServiceActionsManagerUtil.unregisterJSONWebServiceActions((Object)alloyControllerInvoker);
            }
        }
        this._alloyControllerInvokers.clear();
    }

    private Class<? extends AlloyControllerInvoker> _createAlloyControllerInvokerClass(Class<? extends AlloyController> controllerClass) throws NoClassNecessaryException {
        ClassLoader classLoader = controllerClass.getClassLoader();
        String alloyControllerInvokerClassName = this._getAlloyControllerInvokerClassName(controllerClass);
        ClassLoader classLoader2 = classLoader;
        synchronized (classLoader2) {
            try {
                Method defineClassMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, (String)"defineClass", (Class[])new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});
                final byte[] classData = this._generateAlloyControllerInvokerClassData(controllerClass, alloyControllerInvokerClassName);
                final String fileName = StringBundler.concat((String[])new String[]{PropsUtil.get((String)"liferay.home"), "/data/alloy/", this._getClassBinaryName(alloyControllerInvokerClassName), ".class"});
                ClassLoader customClassLoader = new ClassLoader(classLoader){

                    @Override
                    public URL getResource(String name) {
                        if (fileName.contains(name)) {
                            File file = new File(fileName);
                            try {
                                FileUtil.write((File)file, (byte[])classData);
                                URI uri = file.toURI();
                                return uri.toURL();
                            }
                            catch (Exception exception) {
                                throw new RuntimeException(exception);
                            }
                        }
                        return super.getResource(name);
                    }
                };
                return (Class)defineClassMethod.invoke((Object)customClassLoader, alloyControllerInvokerClassName, classData, 0, classData.length);
            }
            catch (NoClassNecessaryException noClassNecessaryException) {
                throw noClassNecessaryException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private byte[] _generateAlloyControllerInvokerClassData(Class<?> controllerClass, String alloyControllerInvokerClassName) throws NoClassNecessaryException {
        Method[] methods;
        boolean jsonWebServiceMethodsPresent = false;
        ClassWriter classWriter = new ClassWriter(2);
        String alloyControllerInvokerClassBinaryName = this._getClassBinaryName(alloyControllerInvokerClassName);
        String baseAlloyControllerInvokerClassBinaryName = this._getClassBinaryName(BaseAlloyControllerInvokerImpl.class.getName());
        classWriter.visit(49, 33, alloyControllerInvokerClassBinaryName, null, baseAlloyControllerInvokerClassBinaryName, null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, baseAlloyControllerInvokerClassBinaryName, "<init>", "()V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        for (Method method : methods = controllerClass.getDeclaredMethods()) {
            int i;
            JSONWebServiceMethod jsonWebServiceMethod;
            if (!Modifier.isPublic(method.getModifiers()) || (jsonWebServiceMethod = method.getAnnotation(JSONWebServiceMethod.class)) == null) continue;
            jsonWebServiceMethodsPresent = true;
            String methodName = jsonWebServiceMethod.methodName();
            if (Validator.isNull((String)methodName)) {
                methodName = method.getName();
            }
            Class<?>[] parameterTypes = jsonWebServiceMethod.parameterTypes();
            StringBundler sb = new StringBundler(parameterTypes.length + 3);
            sb.append("(");
            for (Class<?> parameterType : parameterTypes) {
                sb.append(Type.getDescriptor(parameterType));
            }
            sb.append(")");
            sb.append(Type.getDescriptor(JSONSerializable.class));
            String methodDescriptor = sb.toString();
            methodVisitor = classWriter.visitMethod(1, methodName, methodDescriptor, null, new String[]{this._getClassBinaryName(Exception.class.getName())});
            methodVisitor.visitCode();
            for (i = 0; i < parameterTypes.length; ++i) {
                Class<?> parameterType;
                String parameterName = jsonWebServiceMethod.parameterNames()[i];
                parameterType = parameterTypes[i];
                methodVisitor.visitLocalVariable(parameterName, Type.getDescriptor(parameterType), null, new Label(), new Label(), i + 1);
            }
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitLdcInsn((Object)jsonWebServiceMethod.lifecycle());
            methodVisitor.visitIntInsn(16, parameterTypes.length * 2 + 2);
            methodVisitor.visitTypeInsn(189, this._getClassBinaryName(Object.class.getName()));
            methodVisitor.visitInsn(89);
            methodVisitor.visitInsn(3);
            methodVisitor.visitLdcInsn((Object)"action");
            methodVisitor.visitInsn(83);
            methodVisitor.visitInsn(89);
            methodVisitor.visitInsn(4);
            methodVisitor.visitLdcInsn((Object)method.getName());
            methodVisitor.visitInsn(83);
            for (i = 0; i < parameterTypes.length; ++i) {
                String parameterName = jsonWebServiceMethod.parameterNames()[i];
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, (i + 1) * 2);
                methodVisitor.visitLdcInsn((Object)parameterName);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, (i + 1) * 2 + 1);
                methodVisitor.visitVarInsn(25, i + 1);
                methodVisitor.visitInsn(83);
            }
            methodVisitor.visitMethodInsn(182, alloyControllerInvokerClassBinaryName, "invokeAlloyController", StringBundler.concat((String[])new String[]{"(", Type.getDescriptor(String.class), Type.getDescriptor(Object[].class), ")", Type.getDescriptor(JSONSerializable.class)}));
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(-1, -1);
            methodVisitor.visitEnd();
        }
        classWriter.visitEnd();
        if (!jsonWebServiceMethodsPresent) {
            throw new NoClassNecessaryException();
        }
        return classWriter.toByteArray();
    }

    private String _getAlloyControllerInvokerClassName(Class<? extends AlloyController> controllerClass) {
        String prefix = "";
        String simpleName = "";
        Class<?> enclosingClass = controllerClass.getEnclosingClass();
        if (enclosingClass != null) {
            String[] wordElements;
            prefix = enclosingClass.getName();
            String name = StringUtil.removeSubstring((String)enclosingClass.getSimpleName(), (String)"005f");
            int trimIndex = name.indexOf("_controller");
            for (String wordElement : wordElements = StringUtil.split((String)name.substring(0, trimIndex), (char)'_')) {
                simpleName = simpleName.concat(StringUtil.upperCaseFirstLetter((String)wordElement));
            }
            simpleName = simpleName.concat(_BASE_CLASS_NAME);
        } else if (StringUtil.endsWith((String)controllerClass.getName(), (String)"Controller")) {
            Package pkg = controllerClass.getPackage();
            prefix = pkg.getName();
            simpleName = controllerClass.getSimpleName();
            simpleName = simpleName.substring(0, simpleName.indexOf("Controller")) + _BASE_CLASS_NAME;
        } else {
            prefix = controllerClass.getName();
            simpleName = _BASE_CLASS_NAME + this._counter.getAndIncrement();
        }
        return prefix + "." + simpleName;
    }

    private String _getAPIPath(String controller, Method method) {
        return StringBundler.concat((String[])new String[]{"/", controller, "/", method.getName()});
    }

    private String _getClassBinaryName(String className) {
        return StringUtil.replace((String)className, (char)'.', (char)'/');
    }

    protected class NoClassNecessaryException
    extends Exception {
        public NoClassNecessaryException() {
        }

        public NoClassNecessaryException(String message) {
            super(message);
        }
    }
}

