/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.alloy.mvc;

import com.liferay.alloy.mvc.AlloyServiceInvoker;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseAlloyIndexer
extends BaseIndexer<BaseModel<?>> {
    protected AlloyServiceInvoker alloyServiceInvoker;
    protected String className;

    public AlloyServiceInvoker getAlloyServiceInvoker() {
        return this.alloyServiceInvoker;
    }

    public String getClassName() {
        return this.className;
    }

    public void postProcessContextBooleanFilter(BooleanFilter booleanFilter, SearchContext searchContext) throws Exception {
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)-1);
        if (status != -1) {
            booleanFilter.addRequiredTerm("status", status);
        }
    }

    protected void doDelete(BaseModel<?> baseModel) throws Exception {
        AuditedModel auditedModel = (AuditedModel)baseModel;
        this.deleteDocument(auditedModel.getCompanyId(), String.valueOf(auditedModel.getPrimaryKeyObj()));
    }

    protected void doReindex(BaseModel<?> baseModel) throws Exception {
        Document document = this.getDocument(baseModel);
        AuditedModel auditedModel = (AuditedModel)baseModel;
        IndexWriterHelperUtil.updateDocument((long)auditedModel.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        BaseModel<?> baseModel = this.alloyServiceInvoker.fetchModel(classPK);
        if (baseModel != null) {
            this.doReindex(baseModel);
        }
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexModels(companyId);
    }

    protected Document getBaseModelDocument(String portletId, BaseModel<?> baseModel) {
        Document document = super.getBaseModelDocument(portletId, baseModel);
        document.remove("userId");
        document.remove("userName");
        return document;
    }

    protected void reindexModels(long companyId) throws Exception {
        int count = (int)this.alloyServiceInvoker.executeDynamicQueryCount(new Object[]{"companyId", companyId});
        int pages = count / 10000;
        for (int i = 0; i <= pages; ++i) {
            int start = i * 10000;
            int end = start + 10000;
            this.reindexModels(companyId, start, end);
        }
    }

    protected void reindexModels(long companyId, int start, int end) throws Exception {
        List baseModels = this.alloyServiceInvoker.executeDynamicQuery(new Object[]{"companyId", companyId}, start, end);
        if (baseModels.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>(baseModels.size());
        for (BaseModel baseModel : baseModels) {
            documents.add(this.getDocument(baseModel));
        }
        IndexWriterHelperUtil.updateDocuments((long)companyId, documents, (boolean)this.isCommitImmediately());
    }

    protected void setAlloyServiceInvoker(AlloyServiceInvoker alloyServiceInvoker) {
        this.alloyServiceInvoker = alloyServiceInvoker;
    }

    protected void setClassName(String className) {
        if (this.className == null) {
            this.className = className;
        }
    }
}

