/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.alloy.mvc;

import com.liferay.alloy.mvc.AlloyController;
import com.liferay.alloy.mvc.BaseAlloyControllerImpl;
import com.liferay.alloy.mvc.internal.json.web.service.AlloyControllerInvokerManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.Router;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

public abstract class AlloyPortlet
extends GenericPortlet {
    protected FriendlyURLMapper friendlyURLMapper;
    private static final Log _log = LogFactoryUtil.getLog(AlloyPortlet.class);
    private AlloyControllerInvokerManager _alloyControllerInvokerManager;
    private final Map<String, BaseAlloyControllerImpl> _alloyControllers = new ConcurrentHashMap<String, BaseAlloyControllerImpl>();
    private final Map<String, String> _defaultRouteParameters = new HashMap<String, String>();

    public void destroy() {
        for (BaseAlloyControllerImpl baseAlloyControllerImpl : this._alloyControllers.values()) {
            MessageListener schedulerMessageListener;
            MessageListener controllerMessageListener;
            Indexer<BaseModel<?>> indexer = baseAlloyControllerImpl.indexer;
            if (indexer != null) {
                IndexerRegistryUtil.unregister(indexer);
            }
            if ((controllerMessageListener = baseAlloyControllerImpl.controllerMessageListener) != null) {
                MessageBusUtil.removeDestination((String)baseAlloyControllerImpl.getControllerDestinationName());
            }
            if ((schedulerMessageListener = baseAlloyControllerImpl.schedulerMessageListener) == null) continue;
            try {
                SchedulerEngineHelperUtil.unschedule((String)baseAlloyControllerImpl.getSchedulerJobName(), (String)baseAlloyControllerImpl.getMessageListenerGroupName(), (StorageType)StorageType.MEMORY_CLUSTERED);
                MessageBusUtil.removeDestination((String)baseAlloyControllerImpl.getSchedulerDestinationName());
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        this._alloyControllerInvokerManager.unregisterControllers();
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        Router router = this.friendlyURLMapper.getRouter();
        router.urlToParameters("GET", this._defaultRouteParameters);
        this._alloyControllerInvokerManager = new AlloyControllerInvokerManager((LiferayPortletConfig)portletConfig);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        String path = this.getPath((PortletRequest)actionRequest);
        this.include(path, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String path = this.getPath((PortletRequest)renderRequest);
        this.include(path, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        String path = this.getPath((PortletRequest)resourceRequest);
        this.include(path, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected AlloyControllerInvokerManager getAlloyInvokerManager() {
        return this._alloyControllerInvokerManager;
    }

    protected String getControllerPath(PortletRequest portletRequest) {
        String controllerPath = ParamUtil.getString((PortletRequest)portletRequest, (String)"controller");
        if (Validator.isNull((String)controllerPath)) {
            Map<String, String> defaultRouteParameters = this.getDefaultRouteParameters();
            controllerPath = defaultRouteParameters.get("controller");
        }
        return controllerPath;
    }

    protected Map<String, String> getDefaultRouteParameters() {
        return this._defaultRouteParameters;
    }

    protected String getPath(PortletRequest portletRequest) {
        StringBundler sb = new StringBundler(5);
        sb.append("/alloy_mvc/jsp/");
        sb.append(this.friendlyURLMapper.getMapping());
        sb.append("/controllers/");
        sb.append(this.getControllerPath(portletRequest));
        sb.append("_controller.jsp");
        return sb.toString();
    }

    protected void include(String path, PortletRequest portletRequest, PortletResponse portletResponse) throws IOException, PortletException {
        PortletContext portletContext = this.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher(path);
        if (portletRequestDispatcher == null) {
            _log.error((Object)(path + " is not a valid include"));
        } else {
            portletRequestDispatcher.include(portletRequest, portletResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerAlloyController(AlloyController alloyController) {
        BaseAlloyControllerImpl newBaseAlloyControllerImpl = (BaseAlloyControllerImpl)alloyController;
        String controller = newBaseAlloyControllerImpl.controllerPath;
        BaseAlloyControllerImpl oldBaseAlloyControllerImpl = this._alloyControllers.get(controller);
        if (oldBaseAlloyControllerImpl == null || newBaseAlloyControllerImpl.getClass() != oldBaseAlloyControllerImpl.getClass()) {
            String string = controller.intern();
            synchronized (string) {
                oldBaseAlloyControllerImpl = this._alloyControllers.get(controller);
                if (oldBaseAlloyControllerImpl == null || newBaseAlloyControllerImpl.getClass() != oldBaseAlloyControllerImpl.getClass()) {
                    this._alloyControllers.put(controller, newBaseAlloyControllerImpl);
                    this._alloyControllerInvokerManager.registerController(newBaseAlloyControllerImpl.getThemeDisplay(), this, newBaseAlloyControllerImpl.portlet, controller, newBaseAlloyControllerImpl.getClass());
                }
            }
        }
    }

    protected abstract void setFriendlyURLMapper(FriendlyURLMapper var1);
}

