/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.alloy.mvc;

import com.liferay.alloy.mvc.AlloyController;
import com.liferay.alloy.mvc.AlloyException;
import com.liferay.alloy.mvc.AlloyNotificationEventHelper;
import com.liferay.alloy.mvc.AlloyPermission;
import com.liferay.alloy.mvc.AlloyPortlet;
import com.liferay.alloy.mvc.AlloySearchResult;
import com.liferay.alloy.mvc.AlloyServiceInvoker;
import com.liferay.alloy.mvc.BaseAlloyIndexer;
import com.liferay.alloy.mvc.internal.json.web.service.AlloyControllerInvokerManager;
import com.liferay.alloy.mvc.internal.json.web.service.AlloyMockUtil;
import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.bean.ConstantsBeanFactoryUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONSerializable;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.InvokerMessageListener;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.SerialDestination;
import com.liferay.portal.kernel.model.AttachedModel;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiServiceUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ServiceBeanMethodInvocationFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

public abstract class BaseAlloyControllerImpl
implements AlloyController {
    public static final String TOUCH = BaseAlloyControllerImpl.class.getName() + "#TOUCH#";
    public static final String VIEW_PATH = BaseAlloyControllerImpl.class.getName() + "#VIEW_PATH";
    protected static final String CALLED_PROCESS_ACTION = BaseAlloyControllerImpl.class.getName() + "#CALLED_PROCESS_ACTION";
    protected static final String VIEW_PATH_ERROR = "VIEW_PATH_ERROR";
    protected static final Log log = LogFactoryUtil.getLog(BaseAlloyControllerImpl.class);
    protected String actionPath;
    protected ActionRequest actionRequest;
    protected ActionResponse actionResponse;
    protected AlloyNotificationEventHelper alloyNotificationEventHelper;
    protected JSONObject alloyNotificationEventHelperPayloadJSONObject;
    protected AlloyPortlet alloyPortlet;
    protected AlloyServiceInvoker alloyServiceInvoker;
    protected ClassLoader classLoader;
    protected Class<?> clazz;
    protected Company company;
    protected MessageListener controllerMessageListener;
    protected String controllerPath;
    protected EventRequest eventRequest;
    protected EventResponse eventResponse;
    protected String format;
    protected Indexer<BaseModel<?>> indexer;
    protected String indexerClassName;
    protected String lifecycle;
    protected LiferayPortletConfig liferayPortletConfig;
    protected LiferayPortletResponse liferayPortletResponse;
    protected Locale locale;
    protected Map<String, Method> methodsMap;
    protected MimeResponse mimeResponse;
    protected PageContext pageContext;
    protected boolean permissioned;
    protected Portlet portlet;
    protected PortletContext portletContext;
    protected PortletRequest portletRequest;
    protected PortletResponse portletResponse;
    protected PortletURL portletURL;
    protected String redirect;
    protected RenderRequest renderRequest;
    protected RenderResponse renderResponse;
    protected HttpServletRequest request;
    protected ResourceRequest resourceRequest;
    protected ResourceResponse resourceResponse;
    protected HttpServletResponse response;
    protected String responseContent = "";
    protected MessageListener schedulerMessageListener;
    protected ServletConfig servletConfig;
    protected ServletContext servletContext;
    protected ThemeDisplay themeDisplay;
    protected User user;
    protected String viewPath;

    public static void setAuditedModel(BaseModel<?> baseModel, Company company, User user) throws Exception {
        if (!(baseModel instanceof AuditedModel) || company == null || user == null) {
            return;
        }
        AuditedModel auditedModel = (AuditedModel)baseModel;
        if (baseModel.isNew()) {
            auditedModel.setCompanyId(company.getCompanyId());
            auditedModel.setUserId(user.getUserId());
            auditedModel.setUserName(user.getFullName());
            auditedModel.setCreateDate(new Date());
            auditedModel.setModifiedDate(auditedModel.getCreateDate());
        } else {
            auditedModel.setModifiedDate(new Date());
        }
    }

    public static void setAuditedModel(BaseModel<?> baseModel, HttpServletRequest request) throws Exception {
        if (!(baseModel instanceof AuditedModel) || request == null) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        BaseAlloyControllerImpl.setAuditedModel(baseModel, themeDisplay.getCompany(), themeDisplay.getUser());
    }

    public static void setAuditedModel(BaseModel<?> baseModel, User user) throws Exception {
        if (!(baseModel instanceof AuditedModel) || user == null) {
            return;
        }
        long companyId = CompanyLocalServiceUtil.getCompanyIdByUserId((long)user.getUserId());
        BaseAlloyControllerImpl.setAuditedModel(baseModel, CompanyLocalServiceUtil.getCompany((long)companyId), user);
    }

    public static void setLocalizedProperties(BaseModel<?> baseModel, HttpServletRequest request, Locale locale) throws Exception {
        Map modelAttributes = baseModel.getModelAttributes();
        for (String propertyName : modelAttributes.keySet()) {
            boolean localized = ModelHintsUtil.isLocalized((String)baseModel.getModelClassName(), (String)propertyName);
            if (!localized) continue;
            Class baseModelClass = baseModel.getModelClass();
            String setMethodName = "set" + TextFormatter.format((String)propertyName, (int)6);
            Method setMethod = baseModelClass.getMethod(setMethodName, String.class, Locale.class);
            String value = ParamUtil.getString((HttpServletRequest)request, (String)propertyName);
            setMethod.invoke(baseModel, value, locale);
        }
    }

    @Override
    public void afterPropertiesSet() {
        this.initClass();
        this.initServletVariables();
        this.initPortletVariables();
        this.initThemeDisplayVariables();
        this.initMethods();
        this.initPaths();
        this.initIndexer();
        this.initMessageListeners();
        this.registerAlloyController();
    }

    @Override
    public void execute() throws Exception {
        Method method = this.getMethod(this.actionPath, new Class[0]);
        if (method == null && log.isDebugEnabled()) {
            log.debug((Object)("No method found for action " + this.actionPath));
        }
        if (!this.hasPermission()) {
            this.renderError("you-do-not-have-permission-to-access-the-requested-resource", new Object[0]);
            method = null;
        }
        if (this.lifecycle.equals("ACTION_PHASE")) {
            this.executeAction(method);
        } else if (this.lifecycle.equals("RENDER_PHASE")) {
            this.executeRender(method);
        } else if (this.lifecycle.equals("RESOURCE_PHASE")) {
            this.executeResource(method);
        }
        if (this.alloyNotificationEventHelper != null && !this.viewPath.equals(VIEW_PATH_ERROR)) {
            this.alloyNotificationEventHelper.addUserNotificationEvents(this.request, this.controllerPath, this.actionPath, this.alloyNotificationEventHelperPayloadJSONObject);
        }
    }

    public BaseModel<?> fetchBaseModel(String className, long classPK) throws Exception {
        AlloyServiceInvoker alloyServiceInvoker = new AlloyServiceInvoker(className);
        return alloyServiceInvoker.fetchModel(classPK);
    }

    @Override
    public Portlet getPortlet() {
        return this.portlet;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public String getResponseContent() {
        return this.responseContent;
    }

    @Override
    public ThemeDisplay getThemeDisplay() {
        return this.themeDisplay;
    }

    @Override
    public long increment() throws Exception {
        return CounterLocalServiceUtil.increment();
    }

    @Override
    public void indexModel(BaseModel<?> baseModel) throws Exception {
        if (this.indexer != null && this.indexerClassName.equals(baseModel.getModelClassName())) {
            this.indexer.reindex(baseModel);
        } else {
            Indexer baseModelIndexer = IndexerRegistryUtil.getIndexer((Class)baseModel.getModelClass());
            if (baseModelIndexer != null) {
                baseModelIndexer.reindex(baseModel);
            }
        }
    }

    @Transactional(isolation=Isolation.PORTAL, propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void invoke(Method method) throws Exception {
        method.invoke((Object)this, new Object[0]);
    }

    @Override
    public void persistModel(BaseModel<?> baseModel) throws Exception {
        if (!(baseModel instanceof PersistedModel)) {
            return;
        }
        PersistedModel persistedModel = (PersistedModel)baseModel;
        persistedModel.persist();
    }

    @Override
    public void setModel(BaseModel<?> baseModel, Object ... properties) throws Exception {
        if (baseModel.isNew()) {
            baseModel.setPrimaryKeyObj((Serializable)Long.valueOf(this.increment()));
        }
        this.setAuditedModel(baseModel);
        this.setGroupedModel(baseModel);
        this.setAttachedModel(baseModel);
        if (properties.length % 2 != 0) {
            throw new IllegalArgumentException("Properties length is not an even number");
        }
        for (int i = 0; i < properties.length; i += 2) {
            String propertyName = String.valueOf(properties[i]);
            Object propertyValue = properties[i + 1];
            BeanPropertiesUtil.setProperty(baseModel, (String)propertyName, (Object)propertyValue);
        }
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public String translate(String pattern, Object ... arguments) {
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)this.portlet, (ServletContext)this.servletContext);
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(this.locale);
        return LanguageUtil.format((ResourceBundle)resourceBundle, (String)pattern, (Object[])arguments);
    }

    @Override
    public void updateModel(BaseModel<?> baseModel, Object ... properties) throws Exception {
        BeanPropertiesUtil.setProperties(baseModel, (HttpServletRequest)this.request);
        this.setLocalizedProperties(baseModel);
        this.updateModelIgnoreRequest(baseModel, properties);
    }

    @Override
    public void updateModelIgnoreRequest(BaseModel<?> baseModel, Object ... properties) throws Exception {
        this.setModel(baseModel, properties);
        this.persistModel(baseModel);
    }

    protected void addOpenerSuccessMessage() {
        Map data = (Map)SessionMessages.get((HttpServletRequest)this.request, (String)(this.portlet.getPortletId() + ".refreshPortletData"));
        if (data == null || !GetterUtil.getBoolean((String)((String)data.get("addSuccessMessage")))) {
            return;
        }
        this.addSuccessMessage();
        data.put("addSuccessMessage", "false");
        SessionMessages.add((HttpServletRequest)this.request, (String)(this.portlet.getPortletId() + ".refreshPortletData"), (Object)data);
    }

    protected void addSuccessMessage() {
        String successMessage = ParamUtil.getString((PortletRequest)this.portletRequest, (String)"successMessage");
        SessionMessages.add((PortletRequest)this.portletRequest, (String)"requestProcessed", (Object)successMessage);
    }

    protected MessageListener buildControllerMessageListener() {
        return null;
    }

    protected String buildIncludePath(String viewPath) {
        StringBundler sb = new StringBundler(5);
        sb.append("/alloy_mvc/jsp/");
        sb.append(this.portlet.getFriendlyURLMapping());
        sb.append("/views/");
        if (viewPath.equals(VIEW_PATH_ERROR)) {
            sb.append("error.jsp");
            return sb.toString();
        }
        sb.append(viewPath);
        sb.append(".jsp");
        return sb.toString();
    }

    protected Indexer<BaseModel<?>> buildIndexer() {
        return null;
    }

    protected String buildResponseContent(Object data, String message, int status) throws Exception {
        String responseContent = "";
        if (this.isRespondingTo("json")) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            if (data instanceof Exception) {
                String stackTrace = this.getStackTrace((Exception)data);
                jsonObject.put("data", stackTrace);
            } else if (data instanceof JSONArray) {
                jsonObject.put("data", (JSONArray)data);
            } else if (data instanceof JSONObject) {
                jsonObject.put("data", (JSONObject)data);
            } else if (data != null) {
                jsonObject.put("data", JSONFactoryUtil.createJSONObject((String)String.valueOf(data)));
            }
            jsonObject.put("message", message);
            jsonObject.put("status", status);
            responseContent = jsonObject.toString();
        }
        return responseContent;
    }

    protected MessageListener buildSchedulerMessageListener() {
        return null;
    }

    protected void executeAction(Method method) throws Exception {
        this.executeResource(method);
        this.actionRequest.setAttribute(CALLED_PROCESS_ACTION, (Object)Boolean.TRUE.toString());
        if (Validator.isNotNull((String)this.viewPath)) {
            this.actionRequest.setAttribute(VIEW_PATH, (Object)this.viewPath);
            PortalUtil.copyRequestParameters((ActionRequest)this.actionRequest, (ActionResponse)this.actionResponse);
        } else if (Validator.isNotNull((String)this.redirect)) {
            this.actionResponse.sendRedirect(this.redirect);
        }
    }

    protected void executeRender(Method method) throws Exception {
        boolean calledProcessAction = GetterUtil.getBoolean((String)((String)this.request.getAttribute(CALLED_PROCESS_ACTION)));
        if (!calledProcessAction) {
            this.executeResource(method);
            this.addOpenerSuccessMessage();
        }
        if (Validator.isNull((String)this.responseContent)) {
            if (Validator.isNull((String)this.viewPath)) {
                this.viewPath = this.controllerPath + "/" + this.actionPath;
            }
            String includePath = this.buildIncludePath(this.viewPath);
            this.include(includePath);
        }
        this.touch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeResource(Method method) throws Exception {
        try {
            if (method != null) {
                Method invokeMethod = this.clazz.getMethod("invoke", Method.class);
                ServiceBeanMethodInvocationFactoryUtil.proceed((Object)this, this.clazz, (Method)invokeMethod, (Object[])new Object[]{method}, (String[])new String[]{"transactionAdvice"});
            }
        }
        catch (Exception e) {
            Object[] arguments = null;
            String message = "an-unexpected-system-error-occurred";
            Throwable rootCause = this.getRootCause(e);
            if (rootCause instanceof AlloyException) {
                AlloyException ae = (AlloyException)rootCause;
                if (ae.log) {
                    log.error((Object)rootCause, rootCause);
                }
                if (ArrayUtil.isNotEmpty((Object[])ae.arguments)) {
                    arguments = ae.arguments;
                }
                message = rootCause.getMessage();
            } else {
                log.error((Object)e, (Throwable)e);
            }
            this.renderError(400, e, message, arguments);
        }
        finally {
            if (this.isRespondingTo()) {
                String contentType = this.response.getContentType();
                if (this.isRespondingTo("json")) {
                    contentType = "application/json";
                }
                this.writeResponse(this.responseContent, contentType);
            }
        }
    }

    protected Object getConstantsBean(Class<?> clazz) {
        return ConstantsBeanFactoryUtil.getConstantsBean(clazz);
    }

    protected String getControllerDestinationName() {
        return "liferay/alloy/controller/".concat(this.getMessageListenerGroupName());
    }

    protected String getMessageListenerGroupName() {
        String rootPortletId = this.portlet.getRootPortletId();
        return rootPortletId.concat("/").concat(this.controllerPath);
    }

    protected Method getMethod(String methodName, Class<?> ... parameterTypes) {
        String methodKey = this.getMethodKey(methodName, parameterTypes);
        return this.methodsMap.get(methodKey);
    }

    protected String getMethodKey(String methodName, Class<?> ... parameterTypes) {
        StringBundler sb = new StringBundler(parameterTypes.length * 2 + 2);
        sb.append(methodName);
        sb.append("#");
        for (Class<?> parameterType : parameterTypes) {
            sb.append(parameterType.getName());
            sb.append("#");
        }
        return sb.toString();
    }

    protected PortletURL getPortletURL(String controller, String action, PortletMode portletMode, String lifecycle) throws Exception {
        return this.getPortletURL(controller, action, portletMode, lifecycle, this.portletRequest.getWindowState(), (Object[])null);
    }

    protected PortletURL getPortletURL(String controller, String action, PortletMode portletMode, String lifecycle, Object ... parameters) throws Exception {
        return this.getPortletURL(controller, action, portletMode, lifecycle, this.portletRequest.getWindowState(), parameters);
    }

    protected PortletURL getPortletURL(String controller, String action, PortletMode portletMode, String lifecycle, WindowState windowState) throws Exception {
        return this.getPortletURL(controller, action, portletMode, lifecycle, windowState, (Object[])null);
    }

    protected PortletURL getPortletURL(String controller, String action, PortletMode portletMode, String lifecycle, WindowState windowState, Object ... parameters) throws Exception {
        Layout layout = this.themeDisplay.getLayout();
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)this.request, (Portlet)this.portlet, (Layout)layout, (String)lifecycle);
        portletURL.setParameter("action", action);
        portletURL.setParameter("controller", controller);
        portletURL.setPortletMode(portletMode);
        portletURL.setWindowState(windowState);
        if (parameters == null) {
            return portletURL;
        }
        if (parameters.length % 2 != 0) {
            throw new IllegalArgumentException("Parameters length is not an even number");
        }
        for (int i = 0; i < parameters.length; i += 2) {
            String parameterName = String.valueOf(parameters[i]);
            String parameterValue = String.valueOf(parameters[i + 1]);
            portletURL.setParameter(parameterName, parameterValue);
        }
        return portletURL;
    }

    protected Throwable getRootCause(Throwable throwable) {
        if (throwable.getCause() == null) {
            return throwable;
        }
        return this.getRootCause(throwable.getCause());
    }

    protected String getSchedulerDestinationName() {
        return "liferay/alloy/scheduler/".concat(this.getMessageListenerGroupName());
    }

    protected String getSchedulerJobName() {
        return this.getMessageListenerGroupName();
    }

    protected StorageType getSchedulerStorageType() {
        return StorageType.MEMORY_CLUSTERED;
    }

    protected Trigger getSchedulerTrigger() {
        Calendar calendar = CalendarFactoryUtil.getCalendar();
        return TriggerFactoryUtil.createTrigger((String)this.getSchedulerJobName(), (String)this.getMessageListenerGroupName(), (Date)calendar.getTime(), (int)1, (TimeUnit)TimeUnit.DAY);
    }

    protected Map<String, Serializable> getSearchAttributes(Object ... attributes) throws Exception {
        HashMap<String, Serializable> attributesMap = new HashMap<String, Serializable>();
        if (attributes.length == 0 || attributes.length % 2 != 0) {
            throw new Exception("Arguments length is not an even number");
        }
        for (int i = 0; i < attributes.length; i += 2) {
            String name = String.valueOf(attributes[i]);
            Serializable value = (Serializable)attributes[i + 1];
            attributesMap.put(name, value);
        }
        return attributesMap;
    }

    protected String getStackTrace(Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    protected boolean hasPermission() {
        return !this.permissioned || AlloyPermission.contains(this.themeDisplay, this.portlet.getRootPortletId(), this.controllerPath, this.actionPath);
    }

    protected void include(String path) throws Exception {
        PortletRequestDispatcher portletRequestDispatcher = this.portletContext.getRequestDispatcher(path);
        if (portletRequestDispatcher != null) {
            portletRequestDispatcher.include(this.portletRequest, this.portletResponse);
        } else {
            log.error((Object)(path + " is not a valid include"));
        }
    }

    protected long increment(String name) throws Exception {
        return CounterLocalServiceUtil.increment((String)name);
    }

    protected void initClass() {
        this.clazz = this.getClass();
        this.classLoader = this.clazz.getClassLoader();
    }

    protected void initIndexer() {
        this.indexer = this.buildIndexer();
        if (this.indexer == null) {
            return;
        }
        this.indexerClassName = this.indexer.getClassNames()[0];
        Indexer existingIndexer = IndexerRegistryUtil.getIndexer((String)this.indexerClassName);
        if (existingIndexer != null && existingIndexer == this.indexer) {
            BaseAlloyIndexer baseAlloyIndexer = (BaseAlloyIndexer)this.indexer;
            this.alloyServiceInvoker = baseAlloyIndexer.getAlloyServiceInvoker();
            return;
        }
        this.alloyServiceInvoker = new AlloyServiceInvoker(this.indexerClassName);
        BaseAlloyIndexer baseAlloyIndexer = (BaseAlloyIndexer)this.indexer;
        baseAlloyIndexer.setAlloyServiceInvoker(this.alloyServiceInvoker);
        baseAlloyIndexer.setClassName(this.portlet.getModelClassName());
        PortletBag portletBag = PortletBagPool.get((String)this.portlet.getPortletId());
        List indexerInstances = portletBag.getIndexerInstances();
        if (existingIndexer != null) {
            IndexerRegistryUtil.unregister((Indexer)existingIndexer);
            indexerInstances.remove(existingIndexer);
        }
        IndexerRegistryUtil.register(this.indexer);
        indexerInstances.add(this.indexer);
    }

    protected void initMessageListener(String destinationName, MessageListener messageListener, boolean enableScheduler) {
        MessageBus messageBus = MessageBusUtil.getMessageBus();
        Destination destination = messageBus.getDestination(destinationName);
        if (destination != null) {
            Set messageListeners = destination.getMessageListeners();
            for (MessageListener curMessageListener : messageListeners) {
                Class<?> curMessageListenerClass;
                if (!(curMessageListener instanceof InvokerMessageListener)) continue;
                InvokerMessageListener invokerMessageListener = (InvokerMessageListener)curMessageListener;
                if (messageListener == (curMessageListener = invokerMessageListener.getMessageListener())) {
                    return;
                }
                Class<?> messageListenerClass = messageListener.getClass();
                String messageListenerClassName = messageListenerClass.getName();
                if (!messageListenerClassName.equals((curMessageListenerClass = curMessageListener.getClass()).getName())) continue;
                try {
                    if (enableScheduler) {
                        SchedulerEngineHelperUtil.unschedule((String)this.getSchedulerJobName(), (String)this.getMessageListenerGroupName(), (StorageType)this.getSchedulerStorageType());
                    }
                    MessageBusUtil.unregisterMessageListener((String)destinationName, (MessageListener)curMessageListener);
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
                break;
            }
        } else {
            SerialDestination serialDestination = new SerialDestination();
            serialDestination.setName(destinationName);
            serialDestination.afterPropertiesSet();
            serialDestination.open();
            MessageBusUtil.addDestination((Destination)serialDestination);
        }
        try {
            MessageBusUtil.registerMessageListener((String)destinationName, (MessageListener)messageListener);
            if (enableScheduler) {
                SchedulerEngineHelperUtil.schedule((Trigger)this.getSchedulerTrigger(), (StorageType)this.getSchedulerStorageType(), null, (String)destinationName, null, (int)0);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    protected void initMessageListeners() {
        this.controllerMessageListener = this.buildControllerMessageListener();
        if (this.controllerMessageListener != null) {
            this.initMessageListener(this.getControllerDestinationName(), this.controllerMessageListener, false);
        }
        this.schedulerMessageListener = this.buildSchedulerMessageListener();
        if (this.schedulerMessageListener != null) {
            this.initMessageListener(this.getSchedulerDestinationName(), this.schedulerMessageListener, true);
        }
    }

    protected void initMethods() {
        Method[] methods;
        this.methodsMap = new HashMap<String, Method>();
        for (Method method : methods = this.clazz.getMethods()) {
            String methodKey = this.getMethodKey(method.getName(), method.getParameterTypes());
            this.methodsMap.put(methodKey, method);
        }
    }

    protected void initPaths() {
        Map<String, String> defaultRouteParameters;
        this.controllerPath = ParamUtil.getString((HttpServletRequest)this.request, (String)"controller");
        if (Validator.isNull((String)this.controllerPath)) {
            defaultRouteParameters = this.alloyPortlet.getDefaultRouteParameters();
            this.controllerPath = defaultRouteParameters.get("controller");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Controller path " + this.controllerPath));
        }
        this.actionPath = ParamUtil.getString((HttpServletRequest)this.request, (String)"action");
        if (Validator.isNull((String)this.actionPath)) {
            defaultRouteParameters = this.alloyPortlet.getDefaultRouteParameters();
            this.actionPath = defaultRouteParameters.get("action");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Action path " + this.actionPath));
        }
        this.viewPath = GetterUtil.getString((String)((String)this.request.getAttribute(VIEW_PATH)));
        this.request.removeAttribute(VIEW_PATH);
        if (log.isDebugEnabled()) {
            log.debug((Object)("View path " + this.viewPath));
        }
        this.format = ParamUtil.getString((HttpServletRequest)this.request, (String)"format");
        if (Validator.isNull((String)this.format)) {
            defaultRouteParameters = this.alloyPortlet.getDefaultRouteParameters();
            this.format = defaultRouteParameters.get("format");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Format " + this.format));
        }
        if (this.mimeResponse != null) {
            this.portletURL = this.mimeResponse.createRenderURL();
            this.portletURL.setParameter("action", this.actionPath);
            this.portletURL.setParameter("controller", this.controllerPath);
            if (Validator.isNotNull((String)this.format)) {
                this.portletURL.setParameter("format", this.format);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Portlet URL " + this.portletURL));
            }
        }
    }

    protected void initPortletVariables() {
        this.liferayPortletConfig = (LiferayPortletConfig)this.request.getAttribute("javax.portlet.config");
        this.portletContext = this.liferayPortletConfig.getPortletContext();
        this.portlet = this.liferayPortletConfig.getPortlet();
        this.alloyPortlet = (AlloyPortlet)((Object)this.request.getAttribute("javax.portlet.portlet"));
        this.portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        this.portletResponse = (PortletResponse)this.request.getAttribute("javax.portlet.response");
        this.liferayPortletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)this.portletResponse);
        this.lifecycle = GetterUtil.getString((String)((String)this.request.getAttribute("javax.portlet.lifecycle_phase")));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lifecycle " + this.lifecycle));
        }
        if (this.lifecycle.equals("ACTION_PHASE")) {
            this.actionRequest = (ActionRequest)this.portletRequest;
            this.actionResponse = (ActionResponse)this.portletResponse;
        } else if (this.lifecycle.equals("EVENT_PHASE")) {
            this.eventRequest = (EventRequest)this.portletRequest;
            this.eventResponse = (EventResponse)this.portletResponse;
        } else if (this.lifecycle.equals("RENDER_PHASE")) {
            this.mimeResponse = (MimeResponse)this.portletResponse;
            this.renderRequest = (RenderRequest)this.portletRequest;
            this.renderResponse = (RenderResponse)this.portletResponse;
        } else if (this.lifecycle.equals("RESOURCE_PHASE")) {
            this.mimeResponse = (MimeResponse)this.portletResponse;
            this.resourceRequest = (ResourceRequest)this.portletRequest;
            this.resourceResponse = (ResourceResponse)this.portletResponse;
        }
    }

    protected void initServletVariables() {
        this.servletConfig = this.pageContext.getServletConfig();
        this.servletContext = this.pageContext.getServletContext();
        this.request = (HttpServletRequest)this.pageContext.getRequest();
        this.response = (HttpServletResponse)this.pageContext.getResponse();
    }

    protected void initThemeDisplayVariables() {
        this.themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this.company = this.themeDisplay.getCompany();
        this.locale = this.themeDisplay.getLocale();
        this.user = this.themeDisplay.getUser();
    }

    protected JSONSerializable invokeAlloyController(String controller, String lifecycle, String action, Object[] parameters) throws Exception {
        AlloyControllerInvokerManager alloyControllerInvokerManager = this.alloyPortlet.getAlloyInvokerManager();
        return alloyControllerInvokerManager.invokeAlloyController(controller, lifecycle, action, parameters);
    }

    protected boolean isRespondingTo() {
        return Validator.isNotNull((String)this.format);
    }

    protected boolean isRespondingTo(String format) {
        return StringUtil.equalsIgnoreCase((String)this.format, (String)format);
    }

    @Transactional(isolation=Isolation.PORTAL, propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    protected String processDataRequest(ActionRequest actionRequest) throws Exception {
        return null;
    }

    protected void redirectTo(PortletURL portletURL) {
        this.redirectTo(portletURL.toString());
    }

    protected void redirectTo(String redirect) {
        if (!this.lifecycle.equals("ACTION_PHASE")) {
            throw new IllegalArgumentException("redirectTo can only be called during the action phase");
        }
        if (Validator.isNotNull((String)this.viewPath)) {
            throw new IllegalArgumentException("redirectTo cannot be called if render has been called");
        }
        this.redirect = redirect;
    }

    protected void registerAlloyController() {
        this.alloyPortlet.registerAlloyController(this);
    }

    protected void render(String actionPath) {
        if (Validator.isNotNull((String)this.redirect)) {
            throw new IllegalArgumentException("render cannot be called if redirectTo has been called");
        }
        this.viewPath = actionPath;
    }

    protected void renderError(int status, Exception e, String pattern, Object ... arguments) throws Exception {
        Throwable rootCause = this.getRootCause(e);
        if (this.isRespondingTo()) {
            this.responseContent = this.buildResponseContent(rootCause, this.translate(pattern, arguments), status);
            return;
        }
        this.portletRequest.setAttribute("arguments", (Object)arguments);
        String stackTrace = this.getStackTrace((Exception)rootCause);
        this.portletRequest.setAttribute("data", (Object)stackTrace);
        this.portletRequest.setAttribute("pattern", (Object)pattern);
        this.portletRequest.setAttribute("status", (Object)status);
        this.render(VIEW_PATH_ERROR);
    }

    protected void renderError(int status, String pattern, Object ... arguments) throws Exception {
        AlloyException alloyException = new AlloyException(this.translate("unspecified-cause", new Object[0]));
        this.renderError(status, alloyException, pattern, arguments);
    }

    protected void renderError(String pattern, Object ... arguments) throws Exception {
        this.renderError(400, pattern, arguments);
    }

    protected boolean respondWith(int status, String message, Object object) throws Exception {
        Object data = null;
        if (this.isRespondingTo("json")) {
            if (object instanceof AlloySearchResult) {
                Hits hits = ((AlloySearchResult)object).getHits();
                Object[] documents = hits.getDocs();
                data = this.toJSONArray(documents);
            } else if (object instanceof Collection) {
                Object[] objects = ((Collection)object).toArray(new BaseModel[0]);
                data = this.toJSONArray(objects);
            } else if (object instanceof JSONArray) {
                data = object;
            } else if (object != null) {
                data = this.toJSONObject(object);
            }
        }
        this.responseContent = this.buildResponseContent(data, message, status);
        return true;
    }

    protected boolean respondWith(Object object) throws Exception {
        return this.respondWith(200, null, object);
    }

    protected boolean respondWith(String message) throws Exception {
        return this.respondWith(message, null);
    }

    protected boolean respondWith(String message, Object object) throws Exception {
        return this.respondWith(200, message, object);
    }

    protected AlloySearchResult search(HttpServletRequest request, PortletRequest portletRequest, Map<String, Serializable> attributes, String keywords, Sort[] sorts) throws Exception {
        return this.search(request, portletRequest, null, attributes, keywords, sorts);
    }

    protected AlloySearchResult search(HttpServletRequest request, PortletRequest portletRequest, SearchContainer<? extends BaseModel<?>> searchContainer, Map<String, Serializable> attributes, String keywords, Sort[] sorts) throws Exception {
        return this.search(this.indexer, this.alloyServiceInvoker, request, portletRequest, searchContainer, attributes, keywords, sorts);
    }

    protected AlloySearchResult search(Indexer indexer, AlloyServiceInvoker alloyServiceInvoker, HttpServletRequest request, PortletRequest portletRequest, Map<String, Serializable> attributes, String keywords, Sort[] sorts) throws Exception {
        return this.search(indexer, alloyServiceInvoker, request, portletRequest, null, attributes, keywords, sorts);
    }

    protected AlloySearchResult search(Indexer indexer, AlloyServiceInvoker alloyServiceInvoker, HttpServletRequest request, PortletRequest portletRequest, Map<String, Serializable> attributes, String keywords, Sort[] sorts, int start, int end) throws Exception {
        if (indexer == null) {
            throw new Exception("No indexer found for " + this.controllerPath);
        }
        AlloySearchResult alloySearchResult = new AlloySearchResult();
        alloySearchResult.setAlloyServiceInvoker(alloyServiceInvoker);
        SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)request);
        boolean andOperator = false;
        boolean advancedSearch = ParamUtil.getBoolean((HttpServletRequest)request, (String)"advancedSearch");
        if (advancedSearch) {
            andOperator = ParamUtil.getBoolean((HttpServletRequest)request, (String)"andOperator");
        }
        searchContext.setAndSearch(andOperator);
        if (attributes != null && !attributes.isEmpty()) {
            searchContext.setAttributes(attributes);
        }
        searchContext.setEnd(end);
        String modelClassName = indexer.getClassNames()[0];
        int pos = modelClassName.indexOf(".model.");
        String simpleClassName = modelClassName.substring(pos + 7);
        String serviceClassName = StringBundler.concat((String[])new String[]{modelClassName.substring(0, pos), ".service.", simpleClassName, "LocalService"});
        IdentifiableOSGiService identifiableOSGiService = IdentifiableOSGiServiceUtil.getIdentifiableOSGiService((String)serviceClassName);
        Class<?> serviceClass = identifiableOSGiService.getClass();
        Method createModelMethod = serviceClass.getMethod("create" + simpleClassName, Long.TYPE);
        Class<?> indexerClass = createModelMethod.getReturnType();
        if (!GroupedModel.class.isAssignableFrom(indexerClass)) {
            searchContext.setGroupIds(null);
        } else if (searchContext.getAttribute("groupId") != null) {
            long groupId = GetterUtil.getLong((Object)searchContext.getAttribute("groupId"));
            searchContext.setGroupIds(new long[]{groupId});
        }
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (ArrayUtil.isNotEmpty((Object[])sorts)) {
            searchContext.setSorts(sorts);
        }
        searchContext.setStart(start);
        Hits hits = indexer.search(searchContext);
        alloySearchResult.setHits(hits);
        if (this.portletURL != null) {
            alloySearchResult.setPortletURL(this.portletURL, searchContext.getAttributes());
        }
        alloySearchResult.afterPropertiesSet();
        return alloySearchResult;
    }

    protected AlloySearchResult search(Indexer indexer, AlloyServiceInvoker alloyServiceInvoker, HttpServletRequest request, PortletRequest portletRequest, SearchContainer<? extends BaseModel<?>> searchContainer, Map<String, Serializable> attributes, String keywords, Sort[] sorts) throws Exception {
        if (searchContainer == null) {
            searchContainer = new SearchContainer(portletRequest, this.portletURL, null, null);
        }
        return this.search(indexer, alloyServiceInvoker, request, portletRequest, attributes, keywords, sorts, searchContainer.getStart(), searchContainer.getEnd());
    }

    protected AlloySearchResult search(Map<String, Serializable> attributes, String keywords, Sort sort) throws Exception {
        return this.search(attributes, keywords, new Sort[]{sort});
    }

    protected AlloySearchResult search(Map<String, Serializable> attributes, String keywords, Sort[] sorts) throws Exception {
        return this.search(this.request, this.portletRequest, attributes, keywords, sorts);
    }

    protected AlloySearchResult search(Map<String, Serializable> attributes, String keywords, Sort[] sorts, int start, int end) throws Exception {
        return this.search(this.indexer, this.alloyServiceInvoker, this.request, this.portletRequest, attributes, keywords, sorts, start, end);
    }

    protected AlloySearchResult search(String keywords) throws Exception {
        return this.search(keywords, (Sort[])null);
    }

    protected AlloySearchResult search(String keywords, Sort sort) throws Exception {
        return this.search(keywords, new Sort[]{sort});
    }

    protected AlloySearchResult search(String keywords, Sort[] sorts) throws Exception {
        return this.search(null, keywords, sorts);
    }

    protected void setAlloyNotificationEventHelper(AlloyNotificationEventHelper alloyNotificationEventHelper) {
        this.alloyNotificationEventHelper = alloyNotificationEventHelper;
        this.alloyNotificationEventHelperPayloadJSONObject = null;
    }

    protected void setAlloyServiceInvokerClass(Class<?> clazz) {
        this.alloyServiceInvoker = new AlloyServiceInvoker(clazz.getName());
    }

    protected void setAttachedModel(BaseModel<?> baseModel) throws Exception {
        long classPK;
        if (!(baseModel instanceof AttachedModel)) {
            return;
        }
        AttachedModel attachedModel = (AttachedModel)baseModel;
        long classNameId = 0L;
        String className = ParamUtil.getString((HttpServletRequest)this.request, (String)"className");
        if (Validator.isNotNull((String)className)) {
            classNameId = PortalUtil.getClassNameId((String)className);
        }
        if (classNameId > 0L) {
            attachedModel.setClassNameId(classNameId);
        }
        if ((classPK = ParamUtil.getLong((HttpServletRequest)this.request, (String)"classPK")) > 0L) {
            attachedModel.setClassPK(classPK);
        }
    }

    protected void setAuditedModel(BaseModel<?> baseModel) throws Exception {
        BaseAlloyControllerImpl.setAuditedModel(baseModel, this.company, this.user);
    }

    protected void setGroupedModel(BaseModel<?> baseModel) throws Exception {
        if (!(baseModel instanceof GroupedModel) || !baseModel.isNew()) {
            return;
        }
        GroupedModel groupedModel = (GroupedModel)baseModel;
        groupedModel.setGroupId(this.themeDisplay.getScopeGroupId());
    }

    protected void setLocalizedProperties(BaseModel<?> baseModel) throws Exception {
        BaseAlloyControllerImpl.setLocalizedProperties(baseModel, this.request, this.request.getLocale());
    }

    protected void setLocalizedProperties(BaseModel<?> baseModel, Locale locale) throws Exception {
        BaseAlloyControllerImpl.setLocalizedProperties(baseModel, this.request, locale);
    }

    protected void setOpenerSuccessMessage() {
        SessionMessages.add((PortletRequest)this.portletRequest, (String)(this.portlet.getPortletId() + ".refreshPortlet"), (Object)this.portlet.getPortletId());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("addSuccessMessage", "true");
        SessionMessages.add((HttpServletRequest)this.request, (String)(this.portlet.getPortletId() + ".refreshPortletData"), data);
    }

    protected void setPermissioned(boolean permissioned) {
        this.permissioned = permissioned;
    }

    protected JSONArray toJSONArray(Object[] objects) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (Object object : objects) {
            jsonArray.put(this.toJSONObject(object));
        }
        return jsonArray;
    }

    protected JSONObject toJSONObject(BaseModel<?> baseModel) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        Map modelAttributes = baseModel.getModelAttributes();
        for (Map.Entry entry : modelAttributes.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                jsonObject.put(String.valueOf(key), (Object)((Boolean)value));
                continue;
            }
            if (value instanceof Date) {
                jsonObject.put(String.valueOf(key), (Date)value);
                continue;
            }
            if (value instanceof Double) {
                jsonObject.put(String.valueOf(key), (Object)((Double)value));
                continue;
            }
            if (value instanceof Integer) {
                jsonObject.put(String.valueOf(key), (Object)((Integer)value));
                continue;
            }
            if (value instanceof Long) {
                jsonObject.put(String.valueOf(key), (Object)((Long)value));
                continue;
            }
            if (value instanceof Short) {
                jsonObject.put(String.valueOf(key), (Object)((Short)value));
                continue;
            }
            jsonObject.put(String.valueOf(key), String.valueOf(value));
        }
        return jsonObject;
    }

    protected JSONObject toJSONObject(Document document) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        Map fields = document.getFields();
        for (Map.Entry entry : fields.entrySet()) {
            Field field = (Field)entry.getValue();
            jsonObject.put(field.getName(), field.getValue());
        }
        return jsonObject;
    }

    protected JSONObject toJSONObject(Object object) throws Exception {
        if (object instanceof BaseModel) {
            return this.toJSONObject((BaseModel)object);
        }
        if (object instanceof Document) {
            return this.toJSONObject((Document)object);
        }
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new AlloyException("Unable to convert " + object + " to a JSON object");
    }

    protected void touch() throws Exception {
        Boolean touch = (Boolean)this.portletContext.getAttribute(TOUCH + this.portlet.getRootPortletId());
        if (touch != null) {
            return;
        }
        String touchPath = "/alloy_mvc/jsp/" + this.portlet.getFriendlyURLMapping() + "/views/touch.jsp";
        if (log.isDebugEnabled()) {
            log.debug((Object)StringBundler.concat((String[])new String[]{"Touch ", this.portlet.getRootPortletId(), " by including ", touchPath}));
        }
        this.portletContext.setAttribute(TOUCH + this.portlet.getRootPortletId(), (Object)Boolean.FALSE);
        this.include(touchPath);
    }

    protected void writeResponse(Object content, String contentType) throws Exception {
        HttpServletResponse response = this.response;
        if (!(response instanceof AlloyMockUtil.MockHttpServletResponse)) {
            response = PortalUtil.getHttpServletResponse((PortletResponse)this.portletResponse);
        }
        response.setContentType(contentType);
        ServletResponseUtil.write((HttpServletResponse)response, (String)content.toString());
    }
}

